/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLogInterval is the corresponding interface of BACnetConstructedDataLogInterval
type BACnetConstructedDataLogInterval interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLogInterval returns LogInterval (property field)
	GetLogInterval() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataLogInterval is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLogInterval()
	// CreateBuilder creates a BACnetConstructedDataLogIntervalBuilder
	CreateBACnetConstructedDataLogIntervalBuilder() BACnetConstructedDataLogIntervalBuilder
}

// _BACnetConstructedDataLogInterval is the data-structure of this message
type _BACnetConstructedDataLogInterval struct {
	BACnetConstructedDataContract
	LogInterval BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataLogInterval = (*_BACnetConstructedDataLogInterval)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLogInterval)(nil)

// NewBACnetConstructedDataLogInterval factory function for _BACnetConstructedDataLogInterval
func NewBACnetConstructedDataLogInterval(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, logInterval BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLogInterval {
	if logInterval == nil {
		panic("logInterval of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataLogInterval must not be nil")
	}
	_result := &_BACnetConstructedDataLogInterval{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LogInterval:                   logInterval,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLogIntervalBuilder is a builder for BACnetConstructedDataLogInterval
type BACnetConstructedDataLogIntervalBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(logInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLogIntervalBuilder
	// WithLogInterval adds LogInterval (property field)
	WithLogInterval(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLogIntervalBuilder
	// WithLogIntervalBuilder adds LogInterval (property field) which is build by the builder
	WithLogIntervalBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataLogIntervalBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLogInterval or returns an error if something is wrong
	Build() (BACnetConstructedDataLogInterval, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLogInterval
}

// NewBACnetConstructedDataLogIntervalBuilder() creates a BACnetConstructedDataLogIntervalBuilder
func NewBACnetConstructedDataLogIntervalBuilder() BACnetConstructedDataLogIntervalBuilder {
	return &_BACnetConstructedDataLogIntervalBuilder{_BACnetConstructedDataLogInterval: new(_BACnetConstructedDataLogInterval)}
}

type _BACnetConstructedDataLogIntervalBuilder struct {
	*_BACnetConstructedDataLogInterval

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataLogIntervalBuilder) = (*_BACnetConstructedDataLogIntervalBuilder)(nil)

func (b *_BACnetConstructedDataLogIntervalBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLogInterval
}

func (b *_BACnetConstructedDataLogIntervalBuilder) WithMandatoryFields(logInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLogIntervalBuilder {
	return b.WithLogInterval(logInterval)
}

func (b *_BACnetConstructedDataLogIntervalBuilder) WithLogInterval(logInterval BACnetApplicationTagUnsignedInteger) BACnetConstructedDataLogIntervalBuilder {
	b.LogInterval = logInterval
	return b
}

func (b *_BACnetConstructedDataLogIntervalBuilder) WithLogIntervalBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataLogIntervalBuilder {
	builder := builderSupplier(b.LogInterval.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.LogInterval, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLogIntervalBuilder) Build() (BACnetConstructedDataLogInterval, error) {
	if b.LogInterval == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'logInterval' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataLogInterval.deepCopy(), nil
}

func (b *_BACnetConstructedDataLogIntervalBuilder) MustBuild() BACnetConstructedDataLogInterval {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLogIntervalBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLogIntervalBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLogIntervalBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLogIntervalBuilder().(*_BACnetConstructedDataLogIntervalBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataLogIntervalBuilder creates a BACnetConstructedDataLogIntervalBuilder
func (b *_BACnetConstructedDataLogInterval) CreateBACnetConstructedDataLogIntervalBuilder() BACnetConstructedDataLogIntervalBuilder {
	if b == nil {
		return NewBACnetConstructedDataLogIntervalBuilder()
	}
	return &_BACnetConstructedDataLogIntervalBuilder{_BACnetConstructedDataLogInterval: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLogInterval) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLogInterval) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LOG_INTERVAL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLogInterval) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLogInterval) GetLogInterval() BACnetApplicationTagUnsignedInteger {
	return m.LogInterval
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLogInterval) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetLogInterval())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLogInterval(structType any) BACnetConstructedDataLogInterval {
	if casted, ok := structType.(BACnetConstructedDataLogInterval); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLogInterval); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLogInterval) GetTypeName() string {
	return "BACnetConstructedDataLogInterval"
}

func (m *_BACnetConstructedDataLogInterval) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (logInterval)
	lengthInBits += m.LogInterval.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLogInterval) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLogInterval) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLogInterval BACnetConstructedDataLogInterval, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLogInterval"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLogInterval")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	logInterval, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "logInterval", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'logInterval' field"))
	}
	m.LogInterval = logInterval

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), logInterval)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLogInterval"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLogInterval")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLogInterval) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLogInterval) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLogInterval"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLogInterval")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "logInterval", m.GetLogInterval(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'logInterval' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLogInterval"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLogInterval")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLogInterval) IsBACnetConstructedDataLogInterval() {}

func (m *_BACnetConstructedDataLogInterval) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLogInterval) deepCopy() *_BACnetConstructedDataLogInterval {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLogIntervalCopy := &_BACnetConstructedDataLogInterval{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.LogInterval),
	}
	_BACnetConstructedDataLogIntervalCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLogIntervalCopy
}

func (m *_BACnetConstructedDataLogInterval) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
