/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLocalForwardingOnly is the corresponding interface of BACnetConstructedDataLocalForwardingOnly
type BACnetConstructedDataLocalForwardingOnly interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLocalForwardingOnly returns LocalForwardingOnly (property field)
	GetLocalForwardingOnly() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataLocalForwardingOnly is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLocalForwardingOnly()
	// CreateBuilder creates a BACnetConstructedDataLocalForwardingOnlyBuilder
	CreateBACnetConstructedDataLocalForwardingOnlyBuilder() BACnetConstructedDataLocalForwardingOnlyBuilder
}

// _BACnetConstructedDataLocalForwardingOnly is the data-structure of this message
type _BACnetConstructedDataLocalForwardingOnly struct {
	BACnetConstructedDataContract
	LocalForwardingOnly BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataLocalForwardingOnly = (*_BACnetConstructedDataLocalForwardingOnly)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLocalForwardingOnly)(nil)

// NewBACnetConstructedDataLocalForwardingOnly factory function for _BACnetConstructedDataLocalForwardingOnly
func NewBACnetConstructedDataLocalForwardingOnly(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, localForwardingOnly BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLocalForwardingOnly {
	if localForwardingOnly == nil {
		panic("localForwardingOnly of type BACnetApplicationTagBoolean for BACnetConstructedDataLocalForwardingOnly must not be nil")
	}
	_result := &_BACnetConstructedDataLocalForwardingOnly{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LocalForwardingOnly:           localForwardingOnly,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLocalForwardingOnlyBuilder is a builder for BACnetConstructedDataLocalForwardingOnly
type BACnetConstructedDataLocalForwardingOnlyBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(localForwardingOnly BACnetApplicationTagBoolean) BACnetConstructedDataLocalForwardingOnlyBuilder
	// WithLocalForwardingOnly adds LocalForwardingOnly (property field)
	WithLocalForwardingOnly(BACnetApplicationTagBoolean) BACnetConstructedDataLocalForwardingOnlyBuilder
	// WithLocalForwardingOnlyBuilder adds LocalForwardingOnly (property field) which is build by the builder
	WithLocalForwardingOnlyBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataLocalForwardingOnlyBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLocalForwardingOnly or returns an error if something is wrong
	Build() (BACnetConstructedDataLocalForwardingOnly, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLocalForwardingOnly
}

// NewBACnetConstructedDataLocalForwardingOnlyBuilder() creates a BACnetConstructedDataLocalForwardingOnlyBuilder
func NewBACnetConstructedDataLocalForwardingOnlyBuilder() BACnetConstructedDataLocalForwardingOnlyBuilder {
	return &_BACnetConstructedDataLocalForwardingOnlyBuilder{_BACnetConstructedDataLocalForwardingOnly: new(_BACnetConstructedDataLocalForwardingOnly)}
}

type _BACnetConstructedDataLocalForwardingOnlyBuilder struct {
	*_BACnetConstructedDataLocalForwardingOnly

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataLocalForwardingOnlyBuilder) = (*_BACnetConstructedDataLocalForwardingOnlyBuilder)(nil)

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLocalForwardingOnly
}

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) WithMandatoryFields(localForwardingOnly BACnetApplicationTagBoolean) BACnetConstructedDataLocalForwardingOnlyBuilder {
	return b.WithLocalForwardingOnly(localForwardingOnly)
}

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) WithLocalForwardingOnly(localForwardingOnly BACnetApplicationTagBoolean) BACnetConstructedDataLocalForwardingOnlyBuilder {
	b.LocalForwardingOnly = localForwardingOnly
	return b
}

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) WithLocalForwardingOnlyBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataLocalForwardingOnlyBuilder {
	builder := builderSupplier(b.LocalForwardingOnly.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.LocalForwardingOnly, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) Build() (BACnetConstructedDataLocalForwardingOnly, error) {
	if b.LocalForwardingOnly == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'localForwardingOnly' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataLocalForwardingOnly.deepCopy(), nil
}

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) MustBuild() BACnetConstructedDataLocalForwardingOnly {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLocalForwardingOnlyBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLocalForwardingOnlyBuilder().(*_BACnetConstructedDataLocalForwardingOnlyBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataLocalForwardingOnlyBuilder creates a BACnetConstructedDataLocalForwardingOnlyBuilder
func (b *_BACnetConstructedDataLocalForwardingOnly) CreateBACnetConstructedDataLocalForwardingOnlyBuilder() BACnetConstructedDataLocalForwardingOnlyBuilder {
	if b == nil {
		return NewBACnetConstructedDataLocalForwardingOnlyBuilder()
	}
	return &_BACnetConstructedDataLocalForwardingOnlyBuilder{_BACnetConstructedDataLocalForwardingOnly: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLocalForwardingOnly) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LOCAL_FORWARDING_ONLY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLocalForwardingOnly) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLocalForwardingOnly) GetLocalForwardingOnly() BACnetApplicationTagBoolean {
	return m.LocalForwardingOnly
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLocalForwardingOnly) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetLocalForwardingOnly())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLocalForwardingOnly(structType any) BACnetConstructedDataLocalForwardingOnly {
	if casted, ok := structType.(BACnetConstructedDataLocalForwardingOnly); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLocalForwardingOnly); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetTypeName() string {
	return "BACnetConstructedDataLocalForwardingOnly"
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (localForwardingOnly)
	lengthInBits += m.LocalForwardingOnly.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLocalForwardingOnly) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLocalForwardingOnly) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLocalForwardingOnly BACnetConstructedDataLocalForwardingOnly, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLocalForwardingOnly"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLocalForwardingOnly")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	localForwardingOnly, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "localForwardingOnly", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'localForwardingOnly' field"))
	}
	m.LocalForwardingOnly = localForwardingOnly

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), localForwardingOnly)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLocalForwardingOnly"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLocalForwardingOnly")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLocalForwardingOnly) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLocalForwardingOnly) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLocalForwardingOnly"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLocalForwardingOnly")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "localForwardingOnly", m.GetLocalForwardingOnly(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'localForwardingOnly' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLocalForwardingOnly"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLocalForwardingOnly")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLocalForwardingOnly) IsBACnetConstructedDataLocalForwardingOnly() {}

func (m *_BACnetConstructedDataLocalForwardingOnly) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLocalForwardingOnly) deepCopy() *_BACnetConstructedDataLocalForwardingOnly {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLocalForwardingOnlyCopy := &_BACnetConstructedDataLocalForwardingOnly{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.LocalForwardingOnly),
	}
	_BACnetConstructedDataLocalForwardingOnlyCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLocalForwardingOnlyCopy
}

func (m *_BACnetConstructedDataLocalForwardingOnly) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
