/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataLastCredentialAddedTime is the corresponding interface of BACnetConstructedDataLastCredentialAddedTime
type BACnetConstructedDataLastCredentialAddedTime interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetLastCredentialAddedTime returns LastCredentialAddedTime (property field)
	GetLastCredentialAddedTime() BACnetDateTime
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateTime
	// IsBACnetConstructedDataLastCredentialAddedTime is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataLastCredentialAddedTime()
	// CreateBuilder creates a BACnetConstructedDataLastCredentialAddedTimeBuilder
	CreateBACnetConstructedDataLastCredentialAddedTimeBuilder() BACnetConstructedDataLastCredentialAddedTimeBuilder
}

// _BACnetConstructedDataLastCredentialAddedTime is the data-structure of this message
type _BACnetConstructedDataLastCredentialAddedTime struct {
	BACnetConstructedDataContract
	LastCredentialAddedTime BACnetDateTime
}

var _ BACnetConstructedDataLastCredentialAddedTime = (*_BACnetConstructedDataLastCredentialAddedTime)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataLastCredentialAddedTime)(nil)

// NewBACnetConstructedDataLastCredentialAddedTime factory function for _BACnetConstructedDataLastCredentialAddedTime
func NewBACnetConstructedDataLastCredentialAddedTime(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, lastCredentialAddedTime BACnetDateTime, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataLastCredentialAddedTime {
	if lastCredentialAddedTime == nil {
		panic("lastCredentialAddedTime of type BACnetDateTime for BACnetConstructedDataLastCredentialAddedTime must not be nil")
	}
	_result := &_BACnetConstructedDataLastCredentialAddedTime{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		LastCredentialAddedTime:       lastCredentialAddedTime,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataLastCredentialAddedTimeBuilder is a builder for BACnetConstructedDataLastCredentialAddedTime
type BACnetConstructedDataLastCredentialAddedTimeBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(lastCredentialAddedTime BACnetDateTime) BACnetConstructedDataLastCredentialAddedTimeBuilder
	// WithLastCredentialAddedTime adds LastCredentialAddedTime (property field)
	WithLastCredentialAddedTime(BACnetDateTime) BACnetConstructedDataLastCredentialAddedTimeBuilder
	// WithLastCredentialAddedTimeBuilder adds LastCredentialAddedTime (property field) which is build by the builder
	WithLastCredentialAddedTimeBuilder(func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataLastCredentialAddedTimeBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataLastCredentialAddedTime or returns an error if something is wrong
	Build() (BACnetConstructedDataLastCredentialAddedTime, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataLastCredentialAddedTime
}

// NewBACnetConstructedDataLastCredentialAddedTimeBuilder() creates a BACnetConstructedDataLastCredentialAddedTimeBuilder
func NewBACnetConstructedDataLastCredentialAddedTimeBuilder() BACnetConstructedDataLastCredentialAddedTimeBuilder {
	return &_BACnetConstructedDataLastCredentialAddedTimeBuilder{_BACnetConstructedDataLastCredentialAddedTime: new(_BACnetConstructedDataLastCredentialAddedTime)}
}

type _BACnetConstructedDataLastCredentialAddedTimeBuilder struct {
	*_BACnetConstructedDataLastCredentialAddedTime

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataLastCredentialAddedTimeBuilder) = (*_BACnetConstructedDataLastCredentialAddedTimeBuilder)(nil)

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataLastCredentialAddedTime
}

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) WithMandatoryFields(lastCredentialAddedTime BACnetDateTime) BACnetConstructedDataLastCredentialAddedTimeBuilder {
	return b.WithLastCredentialAddedTime(lastCredentialAddedTime)
}

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) WithLastCredentialAddedTime(lastCredentialAddedTime BACnetDateTime) BACnetConstructedDataLastCredentialAddedTimeBuilder {
	b.LastCredentialAddedTime = lastCredentialAddedTime
	return b
}

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) WithLastCredentialAddedTimeBuilder(builderSupplier func(BACnetDateTimeBuilder) BACnetDateTimeBuilder) BACnetConstructedDataLastCredentialAddedTimeBuilder {
	builder := builderSupplier(b.LastCredentialAddedTime.CreateBACnetDateTimeBuilder())
	var err error
	b.LastCredentialAddedTime, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDateTimeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) Build() (BACnetConstructedDataLastCredentialAddedTime, error) {
	if b.LastCredentialAddedTime == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'lastCredentialAddedTime' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataLastCredentialAddedTime.deepCopy(), nil
}

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) MustBuild() BACnetConstructedDataLastCredentialAddedTime {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataLastCredentialAddedTimeBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataLastCredentialAddedTimeBuilder().(*_BACnetConstructedDataLastCredentialAddedTimeBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataLastCredentialAddedTimeBuilder creates a BACnetConstructedDataLastCredentialAddedTimeBuilder
func (b *_BACnetConstructedDataLastCredentialAddedTime) CreateBACnetConstructedDataLastCredentialAddedTimeBuilder() BACnetConstructedDataLastCredentialAddedTimeBuilder {
	if b == nil {
		return NewBACnetConstructedDataLastCredentialAddedTimeBuilder()
	}
	return &_BACnetConstructedDataLastCredentialAddedTimeBuilder{_BACnetConstructedDataLastCredentialAddedTime: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataLastCredentialAddedTime) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_LAST_CREDENTIAL_ADDED_TIME
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataLastCredentialAddedTime) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataLastCredentialAddedTime) GetLastCredentialAddedTime() BACnetDateTime {
	return m.LastCredentialAddedTime
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataLastCredentialAddedTime) GetActualValue() BACnetDateTime {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateTime(m.GetLastCredentialAddedTime())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataLastCredentialAddedTime(structType any) BACnetConstructedDataLastCredentialAddedTime {
	if casted, ok := structType.(BACnetConstructedDataLastCredentialAddedTime); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataLastCredentialAddedTime); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) GetTypeName() string {
	return "BACnetConstructedDataLastCredentialAddedTime"
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (lastCredentialAddedTime)
	lengthInBits += m.LastCredentialAddedTime.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataLastCredentialAddedTime BACnetConstructedDataLastCredentialAddedTime, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataLastCredentialAddedTime"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataLastCredentialAddedTime")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	lastCredentialAddedTime, err := ReadSimpleField[BACnetDateTime](ctx, "lastCredentialAddedTime", ReadComplex[BACnetDateTime](BACnetDateTimeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'lastCredentialAddedTime' field"))
	}
	m.LastCredentialAddedTime = lastCredentialAddedTime

	actualValue, err := ReadVirtualField[BACnetDateTime](ctx, "actualValue", (*BACnetDateTime)(nil), lastCredentialAddedTime)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataLastCredentialAddedTime"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataLastCredentialAddedTime")
	}

	return m, nil
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataLastCredentialAddedTime"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataLastCredentialAddedTime")
		}

		if err := WriteSimpleField[BACnetDateTime](ctx, "lastCredentialAddedTime", m.GetLastCredentialAddedTime(), WriteComplex[BACnetDateTime](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'lastCredentialAddedTime' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataLastCredentialAddedTime"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataLastCredentialAddedTime")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) IsBACnetConstructedDataLastCredentialAddedTime() {
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) deepCopy() *_BACnetConstructedDataLastCredentialAddedTime {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataLastCredentialAddedTimeCopy := &_BACnetConstructedDataLastCredentialAddedTime{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateTime](m.LastCredentialAddedTime),
	}
	_BACnetConstructedDataLastCredentialAddedTimeCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataLastCredentialAddedTimeCopy
}

func (m *_BACnetConstructedDataLastCredentialAddedTime) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
