/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataHigherDeck is the corresponding interface of BACnetConstructedDataHigherDeck
type BACnetConstructedDataHigherDeck interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetHigherDeck returns HigherDeck (property field)
	GetHigherDeck() BACnetApplicationTagObjectIdentifier
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagObjectIdentifier
	// IsBACnetConstructedDataHigherDeck is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataHigherDeck()
	// CreateBuilder creates a BACnetConstructedDataHigherDeckBuilder
	CreateBACnetConstructedDataHigherDeckBuilder() BACnetConstructedDataHigherDeckBuilder
}

// _BACnetConstructedDataHigherDeck is the data-structure of this message
type _BACnetConstructedDataHigherDeck struct {
	BACnetConstructedDataContract
	HigherDeck BACnetApplicationTagObjectIdentifier
}

var _ BACnetConstructedDataHigherDeck = (*_BACnetConstructedDataHigherDeck)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataHigherDeck)(nil)

// NewBACnetConstructedDataHigherDeck factory function for _BACnetConstructedDataHigherDeck
func NewBACnetConstructedDataHigherDeck(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, higherDeck BACnetApplicationTagObjectIdentifier, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataHigherDeck {
	if higherDeck == nil {
		panic("higherDeck of type BACnetApplicationTagObjectIdentifier for BACnetConstructedDataHigherDeck must not be nil")
	}
	_result := &_BACnetConstructedDataHigherDeck{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		HigherDeck:                    higherDeck,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataHigherDeckBuilder is a builder for BACnetConstructedDataHigherDeck
type BACnetConstructedDataHigherDeckBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(higherDeck BACnetApplicationTagObjectIdentifier) BACnetConstructedDataHigherDeckBuilder
	// WithHigherDeck adds HigherDeck (property field)
	WithHigherDeck(BACnetApplicationTagObjectIdentifier) BACnetConstructedDataHigherDeckBuilder
	// WithHigherDeckBuilder adds HigherDeck (property field) which is build by the builder
	WithHigherDeckBuilder(func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetConstructedDataHigherDeckBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataHigherDeck or returns an error if something is wrong
	Build() (BACnetConstructedDataHigherDeck, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataHigherDeck
}

// NewBACnetConstructedDataHigherDeckBuilder() creates a BACnetConstructedDataHigherDeckBuilder
func NewBACnetConstructedDataHigherDeckBuilder() BACnetConstructedDataHigherDeckBuilder {
	return &_BACnetConstructedDataHigherDeckBuilder{_BACnetConstructedDataHigherDeck: new(_BACnetConstructedDataHigherDeck)}
}

type _BACnetConstructedDataHigherDeckBuilder struct {
	*_BACnetConstructedDataHigherDeck

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataHigherDeckBuilder) = (*_BACnetConstructedDataHigherDeckBuilder)(nil)

func (b *_BACnetConstructedDataHigherDeckBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataHigherDeck
}

func (b *_BACnetConstructedDataHigherDeckBuilder) WithMandatoryFields(higherDeck BACnetApplicationTagObjectIdentifier) BACnetConstructedDataHigherDeckBuilder {
	return b.WithHigherDeck(higherDeck)
}

func (b *_BACnetConstructedDataHigherDeckBuilder) WithHigherDeck(higherDeck BACnetApplicationTagObjectIdentifier) BACnetConstructedDataHigherDeckBuilder {
	b.HigherDeck = higherDeck
	return b
}

func (b *_BACnetConstructedDataHigherDeckBuilder) WithHigherDeckBuilder(builderSupplier func(BACnetApplicationTagObjectIdentifierBuilder) BACnetApplicationTagObjectIdentifierBuilder) BACnetConstructedDataHigherDeckBuilder {
	builder := builderSupplier(b.HigherDeck.CreateBACnetApplicationTagObjectIdentifierBuilder())
	var err error
	b.HigherDeck, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagObjectIdentifierBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataHigherDeckBuilder) Build() (BACnetConstructedDataHigherDeck, error) {
	if b.HigherDeck == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'higherDeck' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataHigherDeck.deepCopy(), nil
}

func (b *_BACnetConstructedDataHigherDeckBuilder) MustBuild() BACnetConstructedDataHigherDeck {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataHigherDeckBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataHigherDeckBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataHigherDeckBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataHigherDeckBuilder().(*_BACnetConstructedDataHigherDeckBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataHigherDeckBuilder creates a BACnetConstructedDataHigherDeckBuilder
func (b *_BACnetConstructedDataHigherDeck) CreateBACnetConstructedDataHigherDeckBuilder() BACnetConstructedDataHigherDeckBuilder {
	if b == nil {
		return NewBACnetConstructedDataHigherDeckBuilder()
	}
	return &_BACnetConstructedDataHigherDeckBuilder{_BACnetConstructedDataHigherDeck: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataHigherDeck) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataHigherDeck) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_HIGHER_DECK
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataHigherDeck) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataHigherDeck) GetHigherDeck() BACnetApplicationTagObjectIdentifier {
	return m.HigherDeck
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataHigherDeck) GetActualValue() BACnetApplicationTagObjectIdentifier {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagObjectIdentifier(m.GetHigherDeck())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataHigherDeck(structType any) BACnetConstructedDataHigherDeck {
	if casted, ok := structType.(BACnetConstructedDataHigherDeck); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataHigherDeck); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataHigherDeck) GetTypeName() string {
	return "BACnetConstructedDataHigherDeck"
}

func (m *_BACnetConstructedDataHigherDeck) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (higherDeck)
	lengthInBits += m.HigherDeck.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataHigherDeck) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataHigherDeck) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataHigherDeck BACnetConstructedDataHigherDeck, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataHigherDeck"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataHigherDeck")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	higherDeck, err := ReadSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "higherDeck", ReadComplex[BACnetApplicationTagObjectIdentifier](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagObjectIdentifier](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'higherDeck' field"))
	}
	m.HigherDeck = higherDeck

	actualValue, err := ReadVirtualField[BACnetApplicationTagObjectIdentifier](ctx, "actualValue", (*BACnetApplicationTagObjectIdentifier)(nil), higherDeck)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataHigherDeck"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataHigherDeck")
	}

	return m, nil
}

func (m *_BACnetConstructedDataHigherDeck) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataHigherDeck) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataHigherDeck"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataHigherDeck")
		}

		if err := WriteSimpleField[BACnetApplicationTagObjectIdentifier](ctx, "higherDeck", m.GetHigherDeck(), WriteComplex[BACnetApplicationTagObjectIdentifier](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'higherDeck' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataHigherDeck"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataHigherDeck")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataHigherDeck) IsBACnetConstructedDataHigherDeck() {}

func (m *_BACnetConstructedDataHigherDeck) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataHigherDeck) deepCopy() *_BACnetConstructedDataHigherDeck {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataHigherDeckCopy := &_BACnetConstructedDataHigherDeck{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagObjectIdentifier](m.HigherDeck),
	}
	_BACnetConstructedDataHigherDeckCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataHigherDeckCopy
}

func (m *_BACnetConstructedDataHigherDeck) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
