/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataGlobalGroupAll is the corresponding interface of BACnetConstructedDataGlobalGroupAll
type BACnetConstructedDataGlobalGroupAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataGlobalGroupAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataGlobalGroupAll()
	// CreateBuilder creates a BACnetConstructedDataGlobalGroupAllBuilder
	CreateBACnetConstructedDataGlobalGroupAllBuilder() BACnetConstructedDataGlobalGroupAllBuilder
}

// _BACnetConstructedDataGlobalGroupAll is the data-structure of this message
type _BACnetConstructedDataGlobalGroupAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataGlobalGroupAll = (*_BACnetConstructedDataGlobalGroupAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataGlobalGroupAll)(nil)

// NewBACnetConstructedDataGlobalGroupAll factory function for _BACnetConstructedDataGlobalGroupAll
func NewBACnetConstructedDataGlobalGroupAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataGlobalGroupAll {
	_result := &_BACnetConstructedDataGlobalGroupAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataGlobalGroupAllBuilder is a builder for BACnetConstructedDataGlobalGroupAll
type BACnetConstructedDataGlobalGroupAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataGlobalGroupAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataGlobalGroupAll or returns an error if something is wrong
	Build() (BACnetConstructedDataGlobalGroupAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataGlobalGroupAll
}

// NewBACnetConstructedDataGlobalGroupAllBuilder() creates a BACnetConstructedDataGlobalGroupAllBuilder
func NewBACnetConstructedDataGlobalGroupAllBuilder() BACnetConstructedDataGlobalGroupAllBuilder {
	return &_BACnetConstructedDataGlobalGroupAllBuilder{_BACnetConstructedDataGlobalGroupAll: new(_BACnetConstructedDataGlobalGroupAll)}
}

type _BACnetConstructedDataGlobalGroupAllBuilder struct {
	*_BACnetConstructedDataGlobalGroupAll

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataGlobalGroupAllBuilder) = (*_BACnetConstructedDataGlobalGroupAllBuilder)(nil)

func (b *_BACnetConstructedDataGlobalGroupAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataGlobalGroupAll
}

func (b *_BACnetConstructedDataGlobalGroupAllBuilder) WithMandatoryFields() BACnetConstructedDataGlobalGroupAllBuilder {
	return b
}

func (b *_BACnetConstructedDataGlobalGroupAllBuilder) Build() (BACnetConstructedDataGlobalGroupAll, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataGlobalGroupAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataGlobalGroupAllBuilder) MustBuild() BACnetConstructedDataGlobalGroupAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataGlobalGroupAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataGlobalGroupAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataGlobalGroupAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataGlobalGroupAllBuilder().(*_BACnetConstructedDataGlobalGroupAllBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataGlobalGroupAllBuilder creates a BACnetConstructedDataGlobalGroupAllBuilder
func (b *_BACnetConstructedDataGlobalGroupAll) CreateBACnetConstructedDataGlobalGroupAllBuilder() BACnetConstructedDataGlobalGroupAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataGlobalGroupAllBuilder()
	}
	return &_BACnetConstructedDataGlobalGroupAllBuilder{_BACnetConstructedDataGlobalGroupAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataGlobalGroupAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_GLOBAL_GROUP
}

func (m *_BACnetConstructedDataGlobalGroupAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataGlobalGroupAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataGlobalGroupAll(structType any) BACnetConstructedDataGlobalGroupAll {
	if casted, ok := structType.(BACnetConstructedDataGlobalGroupAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataGlobalGroupAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataGlobalGroupAll) GetTypeName() string {
	return "BACnetConstructedDataGlobalGroupAll"
}

func (m *_BACnetConstructedDataGlobalGroupAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataGlobalGroupAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataGlobalGroupAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataGlobalGroupAll BACnetConstructedDataGlobalGroupAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataGlobalGroupAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataGlobalGroupAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataGlobalGroupAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataGlobalGroupAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataGlobalGroupAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataGlobalGroupAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataGlobalGroupAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataGlobalGroupAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataGlobalGroupAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataGlobalGroupAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataGlobalGroupAll) IsBACnetConstructedDataGlobalGroupAll() {}

func (m *_BACnetConstructedDataGlobalGroupAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataGlobalGroupAll) deepCopy() *_BACnetConstructedDataGlobalGroupAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataGlobalGroupAllCopy := &_BACnetConstructedDataGlobalGroupAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataGlobalGroupAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataGlobalGroupAllCopy
}

func (m *_BACnetConstructedDataGlobalGroupAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
