/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataEffectivePeriod is the corresponding interface of BACnetConstructedDataEffectivePeriod
type BACnetConstructedDataEffectivePeriod interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDateRange returns DateRange (property field)
	GetDateRange() BACnetDateRange
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDateRange
	// IsBACnetConstructedDataEffectivePeriod is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataEffectivePeriod()
	// CreateBuilder creates a BACnetConstructedDataEffectivePeriodBuilder
	CreateBACnetConstructedDataEffectivePeriodBuilder() BACnetConstructedDataEffectivePeriodBuilder
}

// _BACnetConstructedDataEffectivePeriod is the data-structure of this message
type _BACnetConstructedDataEffectivePeriod struct {
	BACnetConstructedDataContract
	DateRange BACnetDateRange
}

var _ BACnetConstructedDataEffectivePeriod = (*_BACnetConstructedDataEffectivePeriod)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataEffectivePeriod)(nil)

// NewBACnetConstructedDataEffectivePeriod factory function for _BACnetConstructedDataEffectivePeriod
func NewBACnetConstructedDataEffectivePeriod(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, dateRange BACnetDateRange, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataEffectivePeriod {
	if dateRange == nil {
		panic("dateRange of type BACnetDateRange for BACnetConstructedDataEffectivePeriod must not be nil")
	}
	_result := &_BACnetConstructedDataEffectivePeriod{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DateRange:                     dateRange,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataEffectivePeriodBuilder is a builder for BACnetConstructedDataEffectivePeriod
type BACnetConstructedDataEffectivePeriodBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dateRange BACnetDateRange) BACnetConstructedDataEffectivePeriodBuilder
	// WithDateRange adds DateRange (property field)
	WithDateRange(BACnetDateRange) BACnetConstructedDataEffectivePeriodBuilder
	// WithDateRangeBuilder adds DateRange (property field) which is build by the builder
	WithDateRangeBuilder(func(BACnetDateRangeBuilder) BACnetDateRangeBuilder) BACnetConstructedDataEffectivePeriodBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataEffectivePeriod or returns an error if something is wrong
	Build() (BACnetConstructedDataEffectivePeriod, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataEffectivePeriod
}

// NewBACnetConstructedDataEffectivePeriodBuilder() creates a BACnetConstructedDataEffectivePeriodBuilder
func NewBACnetConstructedDataEffectivePeriodBuilder() BACnetConstructedDataEffectivePeriodBuilder {
	return &_BACnetConstructedDataEffectivePeriodBuilder{_BACnetConstructedDataEffectivePeriod: new(_BACnetConstructedDataEffectivePeriod)}
}

type _BACnetConstructedDataEffectivePeriodBuilder struct {
	*_BACnetConstructedDataEffectivePeriod

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataEffectivePeriodBuilder) = (*_BACnetConstructedDataEffectivePeriodBuilder)(nil)

func (b *_BACnetConstructedDataEffectivePeriodBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataEffectivePeriod
}

func (b *_BACnetConstructedDataEffectivePeriodBuilder) WithMandatoryFields(dateRange BACnetDateRange) BACnetConstructedDataEffectivePeriodBuilder {
	return b.WithDateRange(dateRange)
}

func (b *_BACnetConstructedDataEffectivePeriodBuilder) WithDateRange(dateRange BACnetDateRange) BACnetConstructedDataEffectivePeriodBuilder {
	b.DateRange = dateRange
	return b
}

func (b *_BACnetConstructedDataEffectivePeriodBuilder) WithDateRangeBuilder(builderSupplier func(BACnetDateRangeBuilder) BACnetDateRangeBuilder) BACnetConstructedDataEffectivePeriodBuilder {
	builder := builderSupplier(b.DateRange.CreateBACnetDateRangeBuilder())
	var err error
	b.DateRange, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDateRangeBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataEffectivePeriodBuilder) Build() (BACnetConstructedDataEffectivePeriod, error) {
	if b.DateRange == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dateRange' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataEffectivePeriod.deepCopy(), nil
}

func (b *_BACnetConstructedDataEffectivePeriodBuilder) MustBuild() BACnetConstructedDataEffectivePeriod {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataEffectivePeriodBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataEffectivePeriodBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataEffectivePeriodBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataEffectivePeriodBuilder().(*_BACnetConstructedDataEffectivePeriodBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataEffectivePeriodBuilder creates a BACnetConstructedDataEffectivePeriodBuilder
func (b *_BACnetConstructedDataEffectivePeriod) CreateBACnetConstructedDataEffectivePeriodBuilder() BACnetConstructedDataEffectivePeriodBuilder {
	if b == nil {
		return NewBACnetConstructedDataEffectivePeriodBuilder()
	}
	return &_BACnetConstructedDataEffectivePeriodBuilder{_BACnetConstructedDataEffectivePeriod: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataEffectivePeriod) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataEffectivePeriod) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_EFFECTIVE_PERIOD
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataEffectivePeriod) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataEffectivePeriod) GetDateRange() BACnetDateRange {
	return m.DateRange
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataEffectivePeriod) GetActualValue() BACnetDateRange {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDateRange(m.GetDateRange())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataEffectivePeriod(structType any) BACnetConstructedDataEffectivePeriod {
	if casted, ok := structType.(BACnetConstructedDataEffectivePeriod); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataEffectivePeriod); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataEffectivePeriod) GetTypeName() string {
	return "BACnetConstructedDataEffectivePeriod"
}

func (m *_BACnetConstructedDataEffectivePeriod) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (dateRange)
	lengthInBits += m.DateRange.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataEffectivePeriod) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataEffectivePeriod) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataEffectivePeriod BACnetConstructedDataEffectivePeriod, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataEffectivePeriod"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataEffectivePeriod")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dateRange, err := ReadSimpleField[BACnetDateRange](ctx, "dateRange", ReadComplex[BACnetDateRange](BACnetDateRangeParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dateRange' field"))
	}
	m.DateRange = dateRange

	actualValue, err := ReadVirtualField[BACnetDateRange](ctx, "actualValue", (*BACnetDateRange)(nil), dateRange)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataEffectivePeriod"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataEffectivePeriod")
	}

	return m, nil
}

func (m *_BACnetConstructedDataEffectivePeriod) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataEffectivePeriod) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataEffectivePeriod"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataEffectivePeriod")
		}

		if err := WriteSimpleField[BACnetDateRange](ctx, "dateRange", m.GetDateRange(), WriteComplex[BACnetDateRange](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dateRange' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataEffectivePeriod"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataEffectivePeriod")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataEffectivePeriod) IsBACnetConstructedDataEffectivePeriod() {}

func (m *_BACnetConstructedDataEffectivePeriod) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataEffectivePeriod) deepCopy() *_BACnetConstructedDataEffectivePeriod {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataEffectivePeriodCopy := &_BACnetConstructedDataEffectivePeriod{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDateRange](m.DateRange),
	}
	_BACnetConstructedDataEffectivePeriodCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataEffectivePeriodCopy
}

func (m *_BACnetConstructedDataEffectivePeriod) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
