/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataDefaultTimeout is the corresponding interface of BACnetConstructedDataDefaultTimeout
type BACnetConstructedDataDefaultTimeout interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetDefaultTimeout returns DefaultTimeout (property field)
	GetDefaultTimeout() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataDefaultTimeout is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataDefaultTimeout()
	// CreateBuilder creates a BACnetConstructedDataDefaultTimeoutBuilder
	CreateBACnetConstructedDataDefaultTimeoutBuilder() BACnetConstructedDataDefaultTimeoutBuilder
}

// _BACnetConstructedDataDefaultTimeout is the data-structure of this message
type _BACnetConstructedDataDefaultTimeout struct {
	BACnetConstructedDataContract
	DefaultTimeout BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataDefaultTimeout = (*_BACnetConstructedDataDefaultTimeout)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataDefaultTimeout)(nil)

// NewBACnetConstructedDataDefaultTimeout factory function for _BACnetConstructedDataDefaultTimeout
func NewBACnetConstructedDataDefaultTimeout(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, defaultTimeout BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataDefaultTimeout {
	if defaultTimeout == nil {
		panic("defaultTimeout of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataDefaultTimeout must not be nil")
	}
	_result := &_BACnetConstructedDataDefaultTimeout{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		DefaultTimeout:                defaultTimeout,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataDefaultTimeoutBuilder is a builder for BACnetConstructedDataDefaultTimeout
type BACnetConstructedDataDefaultTimeoutBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(defaultTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDefaultTimeoutBuilder
	// WithDefaultTimeout adds DefaultTimeout (property field)
	WithDefaultTimeout(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDefaultTimeoutBuilder
	// WithDefaultTimeoutBuilder adds DefaultTimeout (property field) which is build by the builder
	WithDefaultTimeoutBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDefaultTimeoutBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataDefaultTimeout or returns an error if something is wrong
	Build() (BACnetConstructedDataDefaultTimeout, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataDefaultTimeout
}

// NewBACnetConstructedDataDefaultTimeoutBuilder() creates a BACnetConstructedDataDefaultTimeoutBuilder
func NewBACnetConstructedDataDefaultTimeoutBuilder() BACnetConstructedDataDefaultTimeoutBuilder {
	return &_BACnetConstructedDataDefaultTimeoutBuilder{_BACnetConstructedDataDefaultTimeout: new(_BACnetConstructedDataDefaultTimeout)}
}

type _BACnetConstructedDataDefaultTimeoutBuilder struct {
	*_BACnetConstructedDataDefaultTimeout

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataDefaultTimeoutBuilder) = (*_BACnetConstructedDataDefaultTimeoutBuilder)(nil)

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataDefaultTimeout
}

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) WithMandatoryFields(defaultTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDefaultTimeoutBuilder {
	return b.WithDefaultTimeout(defaultTimeout)
}

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) WithDefaultTimeout(defaultTimeout BACnetApplicationTagUnsignedInteger) BACnetConstructedDataDefaultTimeoutBuilder {
	b.DefaultTimeout = defaultTimeout
	return b
}

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) WithDefaultTimeoutBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataDefaultTimeoutBuilder {
	builder := builderSupplier(b.DefaultTimeout.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.DefaultTimeout, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) Build() (BACnetConstructedDataDefaultTimeout, error) {
	if b.DefaultTimeout == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'defaultTimeout' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataDefaultTimeout.deepCopy(), nil
}

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) MustBuild() BACnetConstructedDataDefaultTimeout {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataDefaultTimeoutBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataDefaultTimeoutBuilder().(*_BACnetConstructedDataDefaultTimeoutBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataDefaultTimeoutBuilder creates a BACnetConstructedDataDefaultTimeoutBuilder
func (b *_BACnetConstructedDataDefaultTimeout) CreateBACnetConstructedDataDefaultTimeoutBuilder() BACnetConstructedDataDefaultTimeoutBuilder {
	if b == nil {
		return NewBACnetConstructedDataDefaultTimeoutBuilder()
	}
	return &_BACnetConstructedDataDefaultTimeoutBuilder{_BACnetConstructedDataDefaultTimeout: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataDefaultTimeout) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataDefaultTimeout) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_DEFAULT_TIMEOUT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataDefaultTimeout) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataDefaultTimeout) GetDefaultTimeout() BACnetApplicationTagUnsignedInteger {
	return m.DefaultTimeout
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataDefaultTimeout) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetDefaultTimeout())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataDefaultTimeout(structType any) BACnetConstructedDataDefaultTimeout {
	if casted, ok := structType.(BACnetConstructedDataDefaultTimeout); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataDefaultTimeout); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataDefaultTimeout) GetTypeName() string {
	return "BACnetConstructedDataDefaultTimeout"
}

func (m *_BACnetConstructedDataDefaultTimeout) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (defaultTimeout)
	lengthInBits += m.DefaultTimeout.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataDefaultTimeout) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataDefaultTimeout) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataDefaultTimeout BACnetConstructedDataDefaultTimeout, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataDefaultTimeout"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataDefaultTimeout")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	defaultTimeout, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "defaultTimeout", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'defaultTimeout' field"))
	}
	m.DefaultTimeout = defaultTimeout

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), defaultTimeout)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataDefaultTimeout"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataDefaultTimeout")
	}

	return m, nil
}

func (m *_BACnetConstructedDataDefaultTimeout) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataDefaultTimeout) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataDefaultTimeout"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataDefaultTimeout")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "defaultTimeout", m.GetDefaultTimeout(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'defaultTimeout' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataDefaultTimeout"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataDefaultTimeout")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataDefaultTimeout) IsBACnetConstructedDataDefaultTimeout() {}

func (m *_BACnetConstructedDataDefaultTimeout) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataDefaultTimeout) deepCopy() *_BACnetConstructedDataDefaultTimeout {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataDefaultTimeoutCopy := &_BACnetConstructedDataDefaultTimeout{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.DefaultTimeout),
	}
	_BACnetConstructedDataDefaultTimeoutCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataDefaultTimeoutCopy
}

func (m *_BACnetConstructedDataDefaultTimeout) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
