/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataCarAssignedDirection is the corresponding interface of BACnetConstructedDataCarAssignedDirection
type BACnetConstructedDataCarAssignedDirection interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAssignedDirection returns AssignedDirection (property field)
	GetAssignedDirection() BACnetLiftCarDirectionTagged
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetLiftCarDirectionTagged
	// IsBACnetConstructedDataCarAssignedDirection is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataCarAssignedDirection()
	// CreateBuilder creates a BACnetConstructedDataCarAssignedDirectionBuilder
	CreateBACnetConstructedDataCarAssignedDirectionBuilder() BACnetConstructedDataCarAssignedDirectionBuilder
}

// _BACnetConstructedDataCarAssignedDirection is the data-structure of this message
type _BACnetConstructedDataCarAssignedDirection struct {
	BACnetConstructedDataContract
	AssignedDirection BACnetLiftCarDirectionTagged
}

var _ BACnetConstructedDataCarAssignedDirection = (*_BACnetConstructedDataCarAssignedDirection)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataCarAssignedDirection)(nil)

// NewBACnetConstructedDataCarAssignedDirection factory function for _BACnetConstructedDataCarAssignedDirection
func NewBACnetConstructedDataCarAssignedDirection(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, assignedDirection BACnetLiftCarDirectionTagged, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataCarAssignedDirection {
	if assignedDirection == nil {
		panic("assignedDirection of type BACnetLiftCarDirectionTagged for BACnetConstructedDataCarAssignedDirection must not be nil")
	}
	_result := &_BACnetConstructedDataCarAssignedDirection{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AssignedDirection:             assignedDirection,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataCarAssignedDirectionBuilder is a builder for BACnetConstructedDataCarAssignedDirection
type BACnetConstructedDataCarAssignedDirectionBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(assignedDirection BACnetLiftCarDirectionTagged) BACnetConstructedDataCarAssignedDirectionBuilder
	// WithAssignedDirection adds AssignedDirection (property field)
	WithAssignedDirection(BACnetLiftCarDirectionTagged) BACnetConstructedDataCarAssignedDirectionBuilder
	// WithAssignedDirectionBuilder adds AssignedDirection (property field) which is build by the builder
	WithAssignedDirectionBuilder(func(BACnetLiftCarDirectionTaggedBuilder) BACnetLiftCarDirectionTaggedBuilder) BACnetConstructedDataCarAssignedDirectionBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataCarAssignedDirection or returns an error if something is wrong
	Build() (BACnetConstructedDataCarAssignedDirection, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataCarAssignedDirection
}

// NewBACnetConstructedDataCarAssignedDirectionBuilder() creates a BACnetConstructedDataCarAssignedDirectionBuilder
func NewBACnetConstructedDataCarAssignedDirectionBuilder() BACnetConstructedDataCarAssignedDirectionBuilder {
	return &_BACnetConstructedDataCarAssignedDirectionBuilder{_BACnetConstructedDataCarAssignedDirection: new(_BACnetConstructedDataCarAssignedDirection)}
}

type _BACnetConstructedDataCarAssignedDirectionBuilder struct {
	*_BACnetConstructedDataCarAssignedDirection

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataCarAssignedDirectionBuilder) = (*_BACnetConstructedDataCarAssignedDirectionBuilder)(nil)

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataCarAssignedDirection
}

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) WithMandatoryFields(assignedDirection BACnetLiftCarDirectionTagged) BACnetConstructedDataCarAssignedDirectionBuilder {
	return b.WithAssignedDirection(assignedDirection)
}

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) WithAssignedDirection(assignedDirection BACnetLiftCarDirectionTagged) BACnetConstructedDataCarAssignedDirectionBuilder {
	b.AssignedDirection = assignedDirection
	return b
}

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) WithAssignedDirectionBuilder(builderSupplier func(BACnetLiftCarDirectionTaggedBuilder) BACnetLiftCarDirectionTaggedBuilder) BACnetConstructedDataCarAssignedDirectionBuilder {
	builder := builderSupplier(b.AssignedDirection.CreateBACnetLiftCarDirectionTaggedBuilder())
	var err error
	b.AssignedDirection, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetLiftCarDirectionTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) Build() (BACnetConstructedDataCarAssignedDirection, error) {
	if b.AssignedDirection == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'assignedDirection' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataCarAssignedDirection.deepCopy(), nil
}

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) MustBuild() BACnetConstructedDataCarAssignedDirection {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataCarAssignedDirectionBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataCarAssignedDirectionBuilder().(*_BACnetConstructedDataCarAssignedDirectionBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataCarAssignedDirectionBuilder creates a BACnetConstructedDataCarAssignedDirectionBuilder
func (b *_BACnetConstructedDataCarAssignedDirection) CreateBACnetConstructedDataCarAssignedDirectionBuilder() BACnetConstructedDataCarAssignedDirectionBuilder {
	if b == nil {
		return NewBACnetConstructedDataCarAssignedDirectionBuilder()
	}
	return &_BACnetConstructedDataCarAssignedDirectionBuilder{_BACnetConstructedDataCarAssignedDirection: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataCarAssignedDirection) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataCarAssignedDirection) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_CAR_ASSIGNED_DIRECTION
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataCarAssignedDirection) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataCarAssignedDirection) GetAssignedDirection() BACnetLiftCarDirectionTagged {
	return m.AssignedDirection
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataCarAssignedDirection) GetActualValue() BACnetLiftCarDirectionTagged {
	ctx := context.Background()
	_ = ctx
	return CastBACnetLiftCarDirectionTagged(m.GetAssignedDirection())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataCarAssignedDirection(structType any) BACnetConstructedDataCarAssignedDirection {
	if casted, ok := structType.(BACnetConstructedDataCarAssignedDirection); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataCarAssignedDirection); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataCarAssignedDirection) GetTypeName() string {
	return "BACnetConstructedDataCarAssignedDirection"
}

func (m *_BACnetConstructedDataCarAssignedDirection) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (assignedDirection)
	lengthInBits += m.AssignedDirection.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataCarAssignedDirection) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataCarAssignedDirection) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataCarAssignedDirection BACnetConstructedDataCarAssignedDirection, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataCarAssignedDirection"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataCarAssignedDirection")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	assignedDirection, err := ReadSimpleField[BACnetLiftCarDirectionTagged](ctx, "assignedDirection", ReadComplex[BACnetLiftCarDirectionTagged](BACnetLiftCarDirectionTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_APPLICATION_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'assignedDirection' field"))
	}
	m.AssignedDirection = assignedDirection

	actualValue, err := ReadVirtualField[BACnetLiftCarDirectionTagged](ctx, "actualValue", (*BACnetLiftCarDirectionTagged)(nil), assignedDirection)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataCarAssignedDirection"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataCarAssignedDirection")
	}

	return m, nil
}

func (m *_BACnetConstructedDataCarAssignedDirection) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataCarAssignedDirection) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataCarAssignedDirection"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataCarAssignedDirection")
		}

		if err := WriteSimpleField[BACnetLiftCarDirectionTagged](ctx, "assignedDirection", m.GetAssignedDirection(), WriteComplex[BACnetLiftCarDirectionTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'assignedDirection' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataCarAssignedDirection"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataCarAssignedDirection")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataCarAssignedDirection) IsBACnetConstructedDataCarAssignedDirection() {}

func (m *_BACnetConstructedDataCarAssignedDirection) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataCarAssignedDirection) deepCopy() *_BACnetConstructedDataCarAssignedDirection {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataCarAssignedDirectionCopy := &_BACnetConstructedDataCarAssignedDirection{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetLiftCarDirectionTagged](m.AssignedDirection),
	}
	_BACnetConstructedDataCarAssignedDirectionCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataCarAssignedDirectionCopy
}

func (m *_BACnetConstructedDataCarAssignedDirection) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
