/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBlinkWarnEnable is the corresponding interface of BACnetConstructedDataBlinkWarnEnable
type BACnetConstructedDataBlinkWarnEnable interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetBlinkWarnEnable returns BlinkWarnEnable (property field)
	GetBlinkWarnEnable() BACnetApplicationTagBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBoolean
	// IsBACnetConstructedDataBlinkWarnEnable is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBlinkWarnEnable()
	// CreateBuilder creates a BACnetConstructedDataBlinkWarnEnableBuilder
	CreateBACnetConstructedDataBlinkWarnEnableBuilder() BACnetConstructedDataBlinkWarnEnableBuilder
}

// _BACnetConstructedDataBlinkWarnEnable is the data-structure of this message
type _BACnetConstructedDataBlinkWarnEnable struct {
	BACnetConstructedDataContract
	BlinkWarnEnable BACnetApplicationTagBoolean
}

var _ BACnetConstructedDataBlinkWarnEnable = (*_BACnetConstructedDataBlinkWarnEnable)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBlinkWarnEnable)(nil)

// NewBACnetConstructedDataBlinkWarnEnable factory function for _BACnetConstructedDataBlinkWarnEnable
func NewBACnetConstructedDataBlinkWarnEnable(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, blinkWarnEnable BACnetApplicationTagBoolean, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBlinkWarnEnable {
	if blinkWarnEnable == nil {
		panic("blinkWarnEnable of type BACnetApplicationTagBoolean for BACnetConstructedDataBlinkWarnEnable must not be nil")
	}
	_result := &_BACnetConstructedDataBlinkWarnEnable{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		BlinkWarnEnable:               blinkWarnEnable,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBlinkWarnEnableBuilder is a builder for BACnetConstructedDataBlinkWarnEnable
type BACnetConstructedDataBlinkWarnEnableBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(blinkWarnEnable BACnetApplicationTagBoolean) BACnetConstructedDataBlinkWarnEnableBuilder
	// WithBlinkWarnEnable adds BlinkWarnEnable (property field)
	WithBlinkWarnEnable(BACnetApplicationTagBoolean) BACnetConstructedDataBlinkWarnEnableBuilder
	// WithBlinkWarnEnableBuilder adds BlinkWarnEnable (property field) which is build by the builder
	WithBlinkWarnEnableBuilder(func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataBlinkWarnEnableBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBlinkWarnEnable or returns an error if something is wrong
	Build() (BACnetConstructedDataBlinkWarnEnable, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBlinkWarnEnable
}

// NewBACnetConstructedDataBlinkWarnEnableBuilder() creates a BACnetConstructedDataBlinkWarnEnableBuilder
func NewBACnetConstructedDataBlinkWarnEnableBuilder() BACnetConstructedDataBlinkWarnEnableBuilder {
	return &_BACnetConstructedDataBlinkWarnEnableBuilder{_BACnetConstructedDataBlinkWarnEnable: new(_BACnetConstructedDataBlinkWarnEnable)}
}

type _BACnetConstructedDataBlinkWarnEnableBuilder struct {
	*_BACnetConstructedDataBlinkWarnEnable

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataBlinkWarnEnableBuilder) = (*_BACnetConstructedDataBlinkWarnEnableBuilder)(nil)

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBlinkWarnEnable
}

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) WithMandatoryFields(blinkWarnEnable BACnetApplicationTagBoolean) BACnetConstructedDataBlinkWarnEnableBuilder {
	return b.WithBlinkWarnEnable(blinkWarnEnable)
}

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) WithBlinkWarnEnable(blinkWarnEnable BACnetApplicationTagBoolean) BACnetConstructedDataBlinkWarnEnableBuilder {
	b.BlinkWarnEnable = blinkWarnEnable
	return b
}

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) WithBlinkWarnEnableBuilder(builderSupplier func(BACnetApplicationTagBooleanBuilder) BACnetApplicationTagBooleanBuilder) BACnetConstructedDataBlinkWarnEnableBuilder {
	builder := builderSupplier(b.BlinkWarnEnable.CreateBACnetApplicationTagBooleanBuilder())
	var err error
	b.BlinkWarnEnable, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) Build() (BACnetConstructedDataBlinkWarnEnable, error) {
	if b.BlinkWarnEnable == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'blinkWarnEnable' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataBlinkWarnEnable.deepCopy(), nil
}

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) MustBuild() BACnetConstructedDataBlinkWarnEnable {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBlinkWarnEnableBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBlinkWarnEnableBuilder().(*_BACnetConstructedDataBlinkWarnEnableBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataBlinkWarnEnableBuilder creates a BACnetConstructedDataBlinkWarnEnableBuilder
func (b *_BACnetConstructedDataBlinkWarnEnable) CreateBACnetConstructedDataBlinkWarnEnableBuilder() BACnetConstructedDataBlinkWarnEnableBuilder {
	if b == nil {
		return NewBACnetConstructedDataBlinkWarnEnableBuilder()
	}
	return &_BACnetConstructedDataBlinkWarnEnableBuilder{_BACnetConstructedDataBlinkWarnEnable: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBlinkWarnEnable) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataBlinkWarnEnable) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_BLINK_WARN_ENABLE
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBlinkWarnEnable) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataBlinkWarnEnable) GetBlinkWarnEnable() BACnetApplicationTagBoolean {
	return m.BlinkWarnEnable
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataBlinkWarnEnable) GetActualValue() BACnetApplicationTagBoolean {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBoolean(m.GetBlinkWarnEnable())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBlinkWarnEnable(structType any) BACnetConstructedDataBlinkWarnEnable {
	if casted, ok := structType.(BACnetConstructedDataBlinkWarnEnable); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBlinkWarnEnable); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBlinkWarnEnable) GetTypeName() string {
	return "BACnetConstructedDataBlinkWarnEnable"
}

func (m *_BACnetConstructedDataBlinkWarnEnable) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (blinkWarnEnable)
	lengthInBits += m.BlinkWarnEnable.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataBlinkWarnEnable) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBlinkWarnEnable) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBlinkWarnEnable BACnetConstructedDataBlinkWarnEnable, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBlinkWarnEnable"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBlinkWarnEnable")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	blinkWarnEnable, err := ReadSimpleField[BACnetApplicationTagBoolean](ctx, "blinkWarnEnable", ReadComplex[BACnetApplicationTagBoolean](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBoolean](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'blinkWarnEnable' field"))
	}
	m.BlinkWarnEnable = blinkWarnEnable

	actualValue, err := ReadVirtualField[BACnetApplicationTagBoolean](ctx, "actualValue", (*BACnetApplicationTagBoolean)(nil), blinkWarnEnable)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBlinkWarnEnable"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBlinkWarnEnable")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBlinkWarnEnable) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBlinkWarnEnable) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBlinkWarnEnable"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBlinkWarnEnable")
		}

		if err := WriteSimpleField[BACnetApplicationTagBoolean](ctx, "blinkWarnEnable", m.GetBlinkWarnEnable(), WriteComplex[BACnetApplicationTagBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'blinkWarnEnable' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBlinkWarnEnable"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBlinkWarnEnable")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBlinkWarnEnable) IsBACnetConstructedDataBlinkWarnEnable() {}

func (m *_BACnetConstructedDataBlinkWarnEnable) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBlinkWarnEnable) deepCopy() *_BACnetConstructedDataBlinkWarnEnable {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBlinkWarnEnableCopy := &_BACnetConstructedDataBlinkWarnEnable{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBoolean](m.BlinkWarnEnable),
	}
	_BACnetConstructedDataBlinkWarnEnableCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBlinkWarnEnableCopy
}

func (m *_BACnetConstructedDataBlinkWarnEnable) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
