/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBitMask is the corresponding interface of BACnetConstructedDataBitMask
type BACnetConstructedDataBitMask interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetBitString returns BitString (property field)
	GetBitString() BACnetApplicationTagBitString
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagBitString
	// IsBACnetConstructedDataBitMask is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBitMask()
	// CreateBuilder creates a BACnetConstructedDataBitMaskBuilder
	CreateBACnetConstructedDataBitMaskBuilder() BACnetConstructedDataBitMaskBuilder
}

// _BACnetConstructedDataBitMask is the data-structure of this message
type _BACnetConstructedDataBitMask struct {
	BACnetConstructedDataContract
	BitString BACnetApplicationTagBitString
}

var _ BACnetConstructedDataBitMask = (*_BACnetConstructedDataBitMask)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBitMask)(nil)

// NewBACnetConstructedDataBitMask factory function for _BACnetConstructedDataBitMask
func NewBACnetConstructedDataBitMask(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, bitString BACnetApplicationTagBitString, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBitMask {
	if bitString == nil {
		panic("bitString of type BACnetApplicationTagBitString for BACnetConstructedDataBitMask must not be nil")
	}
	_result := &_BACnetConstructedDataBitMask{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		BitString:                     bitString,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBitMaskBuilder is a builder for BACnetConstructedDataBitMask
type BACnetConstructedDataBitMaskBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(bitString BACnetApplicationTagBitString) BACnetConstructedDataBitMaskBuilder
	// WithBitString adds BitString (property field)
	WithBitString(BACnetApplicationTagBitString) BACnetConstructedDataBitMaskBuilder
	// WithBitStringBuilder adds BitString (property field) which is build by the builder
	WithBitStringBuilder(func(BACnetApplicationTagBitStringBuilder) BACnetApplicationTagBitStringBuilder) BACnetConstructedDataBitMaskBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBitMask or returns an error if something is wrong
	Build() (BACnetConstructedDataBitMask, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBitMask
}

// NewBACnetConstructedDataBitMaskBuilder() creates a BACnetConstructedDataBitMaskBuilder
func NewBACnetConstructedDataBitMaskBuilder() BACnetConstructedDataBitMaskBuilder {
	return &_BACnetConstructedDataBitMaskBuilder{_BACnetConstructedDataBitMask: new(_BACnetConstructedDataBitMask)}
}

type _BACnetConstructedDataBitMaskBuilder struct {
	*_BACnetConstructedDataBitMask

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataBitMaskBuilder) = (*_BACnetConstructedDataBitMaskBuilder)(nil)

func (b *_BACnetConstructedDataBitMaskBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBitMask
}

func (b *_BACnetConstructedDataBitMaskBuilder) WithMandatoryFields(bitString BACnetApplicationTagBitString) BACnetConstructedDataBitMaskBuilder {
	return b.WithBitString(bitString)
}

func (b *_BACnetConstructedDataBitMaskBuilder) WithBitString(bitString BACnetApplicationTagBitString) BACnetConstructedDataBitMaskBuilder {
	b.BitString = bitString
	return b
}

func (b *_BACnetConstructedDataBitMaskBuilder) WithBitStringBuilder(builderSupplier func(BACnetApplicationTagBitStringBuilder) BACnetApplicationTagBitStringBuilder) BACnetConstructedDataBitMaskBuilder {
	builder := builderSupplier(b.BitString.CreateBACnetApplicationTagBitStringBuilder())
	var err error
	b.BitString, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagBitStringBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBitMaskBuilder) Build() (BACnetConstructedDataBitMask, error) {
	if b.BitString == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'bitString' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataBitMask.deepCopy(), nil
}

func (b *_BACnetConstructedDataBitMaskBuilder) MustBuild() BACnetConstructedDataBitMask {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBitMaskBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBitMaskBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBitMaskBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBitMaskBuilder().(*_BACnetConstructedDataBitMaskBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataBitMaskBuilder creates a BACnetConstructedDataBitMaskBuilder
func (b *_BACnetConstructedDataBitMask) CreateBACnetConstructedDataBitMaskBuilder() BACnetConstructedDataBitMaskBuilder {
	if b == nil {
		return NewBACnetConstructedDataBitMaskBuilder()
	}
	return &_BACnetConstructedDataBitMaskBuilder{_BACnetConstructedDataBitMask: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBitMask) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataBitMask) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_BIT_MASK
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBitMask) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataBitMask) GetBitString() BACnetApplicationTagBitString {
	return m.BitString
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataBitMask) GetActualValue() BACnetApplicationTagBitString {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagBitString(m.GetBitString())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBitMask(structType any) BACnetConstructedDataBitMask {
	if casted, ok := structType.(BACnetConstructedDataBitMask); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBitMask); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBitMask) GetTypeName() string {
	return "BACnetConstructedDataBitMask"
}

func (m *_BACnetConstructedDataBitMask) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (bitString)
	lengthInBits += m.BitString.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataBitMask) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBitMask) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBitMask BACnetConstructedDataBitMask, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBitMask"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBitMask")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	bitString, err := ReadSimpleField[BACnetApplicationTagBitString](ctx, "bitString", ReadComplex[BACnetApplicationTagBitString](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagBitString](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bitString' field"))
	}
	m.BitString = bitString

	actualValue, err := ReadVirtualField[BACnetApplicationTagBitString](ctx, "actualValue", (*BACnetApplicationTagBitString)(nil), bitString)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBitMask"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBitMask")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBitMask) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBitMask) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBitMask"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBitMask")
		}

		if err := WriteSimpleField[BACnetApplicationTagBitString](ctx, "bitString", m.GetBitString(), WriteComplex[BACnetApplicationTagBitString](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'bitString' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBitMask"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBitMask")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBitMask) IsBACnetConstructedDataBitMask() {}

func (m *_BACnetConstructedDataBitMask) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBitMask) deepCopy() *_BACnetConstructedDataBitMask {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBitMaskCopy := &_BACnetConstructedDataBitMask{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagBitString](m.BitString),
	}
	_BACnetConstructedDataBitMaskCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBitMaskCopy
}

func (m *_BACnetConstructedDataBitMask) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
