/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBinaryValueAll is the corresponding interface of BACnetConstructedDataBinaryValueAll
type BACnetConstructedDataBinaryValueAll interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// IsBACnetConstructedDataBinaryValueAll is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBinaryValueAll()
	// CreateBuilder creates a BACnetConstructedDataBinaryValueAllBuilder
	CreateBACnetConstructedDataBinaryValueAllBuilder() BACnetConstructedDataBinaryValueAllBuilder
}

// _BACnetConstructedDataBinaryValueAll is the data-structure of this message
type _BACnetConstructedDataBinaryValueAll struct {
	BACnetConstructedDataContract
}

var _ BACnetConstructedDataBinaryValueAll = (*_BACnetConstructedDataBinaryValueAll)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBinaryValueAll)(nil)

// NewBACnetConstructedDataBinaryValueAll factory function for _BACnetConstructedDataBinaryValueAll
func NewBACnetConstructedDataBinaryValueAll(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBinaryValueAll {
	_result := &_BACnetConstructedDataBinaryValueAll{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBinaryValueAllBuilder is a builder for BACnetConstructedDataBinaryValueAll
type BACnetConstructedDataBinaryValueAllBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetConstructedDataBinaryValueAllBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBinaryValueAll or returns an error if something is wrong
	Build() (BACnetConstructedDataBinaryValueAll, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBinaryValueAll
}

// NewBACnetConstructedDataBinaryValueAllBuilder() creates a BACnetConstructedDataBinaryValueAllBuilder
func NewBACnetConstructedDataBinaryValueAllBuilder() BACnetConstructedDataBinaryValueAllBuilder {
	return &_BACnetConstructedDataBinaryValueAllBuilder{_BACnetConstructedDataBinaryValueAll: new(_BACnetConstructedDataBinaryValueAll)}
}

type _BACnetConstructedDataBinaryValueAllBuilder struct {
	*_BACnetConstructedDataBinaryValueAll

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataBinaryValueAllBuilder) = (*_BACnetConstructedDataBinaryValueAllBuilder)(nil)

func (b *_BACnetConstructedDataBinaryValueAllBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBinaryValueAll
}

func (b *_BACnetConstructedDataBinaryValueAllBuilder) WithMandatoryFields() BACnetConstructedDataBinaryValueAllBuilder {
	return b
}

func (b *_BACnetConstructedDataBinaryValueAllBuilder) Build() (BACnetConstructedDataBinaryValueAll, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataBinaryValueAll.deepCopy(), nil
}

func (b *_BACnetConstructedDataBinaryValueAllBuilder) MustBuild() BACnetConstructedDataBinaryValueAll {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBinaryValueAllBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBinaryValueAllBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBinaryValueAllBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBinaryValueAllBuilder().(*_BACnetConstructedDataBinaryValueAllBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataBinaryValueAllBuilder creates a BACnetConstructedDataBinaryValueAllBuilder
func (b *_BACnetConstructedDataBinaryValueAll) CreateBACnetConstructedDataBinaryValueAllBuilder() BACnetConstructedDataBinaryValueAllBuilder {
	if b == nil {
		return NewBACnetConstructedDataBinaryValueAllBuilder()
	}
	return &_BACnetConstructedDataBinaryValueAllBuilder{_BACnetConstructedDataBinaryValueAll: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBinaryValueAll) GetObjectTypeArgument() BACnetObjectType {
	return BACnetObjectType_BINARY_VALUE
}

func (m *_BACnetConstructedDataBinaryValueAll) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ALL
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBinaryValueAll) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBinaryValueAll(structType any) BACnetConstructedDataBinaryValueAll {
	if casted, ok := structType.(BACnetConstructedDataBinaryValueAll); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBinaryValueAll); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBinaryValueAll) GetTypeName() string {
	return "BACnetConstructedDataBinaryValueAll"
}

func (m *_BACnetConstructedDataBinaryValueAll) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_BACnetConstructedDataBinaryValueAll) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBinaryValueAll) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBinaryValueAll BACnetConstructedDataBinaryValueAll, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBinaryValueAll"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBinaryValueAll")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "All should never occur in context of constructed data. If it does please report"})
	}

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBinaryValueAll"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBinaryValueAll")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBinaryValueAll) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBinaryValueAll) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBinaryValueAll"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBinaryValueAll")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBinaryValueAll"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBinaryValueAll")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBinaryValueAll) IsBACnetConstructedDataBinaryValueAll() {}

func (m *_BACnetConstructedDataBinaryValueAll) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBinaryValueAll) deepCopy() *_BACnetConstructedDataBinaryValueAll {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBinaryValueAllCopy := &_BACnetConstructedDataBinaryValueAll{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
	}
	_BACnetConstructedDataBinaryValueAllCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBinaryValueAllCopy
}

func (m *_BACnetConstructedDataBinaryValueAll) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
