/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataBACnetIPGlobalAddress is the corresponding interface of BACnetConstructedDataBACnetIPGlobalAddress
type BACnetConstructedDataBACnetIPGlobalAddress interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetBacnetIpGlobalAddress returns BacnetIpGlobalAddress (property field)
	GetBacnetIpGlobalAddress() BACnetHostNPort
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetHostNPort
	// IsBACnetConstructedDataBACnetIPGlobalAddress is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataBACnetIPGlobalAddress()
	// CreateBuilder creates a BACnetConstructedDataBACnetIPGlobalAddressBuilder
	CreateBACnetConstructedDataBACnetIPGlobalAddressBuilder() BACnetConstructedDataBACnetIPGlobalAddressBuilder
}

// _BACnetConstructedDataBACnetIPGlobalAddress is the data-structure of this message
type _BACnetConstructedDataBACnetIPGlobalAddress struct {
	BACnetConstructedDataContract
	BacnetIpGlobalAddress BACnetHostNPort
}

var _ BACnetConstructedDataBACnetIPGlobalAddress = (*_BACnetConstructedDataBACnetIPGlobalAddress)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataBACnetIPGlobalAddress)(nil)

// NewBACnetConstructedDataBACnetIPGlobalAddress factory function for _BACnetConstructedDataBACnetIPGlobalAddress
func NewBACnetConstructedDataBACnetIPGlobalAddress(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, bacnetIpGlobalAddress BACnetHostNPort, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataBACnetIPGlobalAddress {
	if bacnetIpGlobalAddress == nil {
		panic("bacnetIpGlobalAddress of type BACnetHostNPort for BACnetConstructedDataBACnetIPGlobalAddress must not be nil")
	}
	_result := &_BACnetConstructedDataBACnetIPGlobalAddress{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		BacnetIpGlobalAddress:         bacnetIpGlobalAddress,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataBACnetIPGlobalAddressBuilder is a builder for BACnetConstructedDataBACnetIPGlobalAddress
type BACnetConstructedDataBACnetIPGlobalAddressBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(bacnetIpGlobalAddress BACnetHostNPort) BACnetConstructedDataBACnetIPGlobalAddressBuilder
	// WithBacnetIpGlobalAddress adds BacnetIpGlobalAddress (property field)
	WithBacnetIpGlobalAddress(BACnetHostNPort) BACnetConstructedDataBACnetIPGlobalAddressBuilder
	// WithBacnetIpGlobalAddressBuilder adds BacnetIpGlobalAddress (property field) which is build by the builder
	WithBacnetIpGlobalAddressBuilder(func(BACnetHostNPortBuilder) BACnetHostNPortBuilder) BACnetConstructedDataBACnetIPGlobalAddressBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataBACnetIPGlobalAddress or returns an error if something is wrong
	Build() (BACnetConstructedDataBACnetIPGlobalAddress, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataBACnetIPGlobalAddress
}

// NewBACnetConstructedDataBACnetIPGlobalAddressBuilder() creates a BACnetConstructedDataBACnetIPGlobalAddressBuilder
func NewBACnetConstructedDataBACnetIPGlobalAddressBuilder() BACnetConstructedDataBACnetIPGlobalAddressBuilder {
	return &_BACnetConstructedDataBACnetIPGlobalAddressBuilder{_BACnetConstructedDataBACnetIPGlobalAddress: new(_BACnetConstructedDataBACnetIPGlobalAddress)}
}

type _BACnetConstructedDataBACnetIPGlobalAddressBuilder struct {
	*_BACnetConstructedDataBACnetIPGlobalAddress

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataBACnetIPGlobalAddressBuilder) = (*_BACnetConstructedDataBACnetIPGlobalAddressBuilder)(nil)

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataBACnetIPGlobalAddress
}

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) WithMandatoryFields(bacnetIpGlobalAddress BACnetHostNPort) BACnetConstructedDataBACnetIPGlobalAddressBuilder {
	return b.WithBacnetIpGlobalAddress(bacnetIpGlobalAddress)
}

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) WithBacnetIpGlobalAddress(bacnetIpGlobalAddress BACnetHostNPort) BACnetConstructedDataBACnetIPGlobalAddressBuilder {
	b.BacnetIpGlobalAddress = bacnetIpGlobalAddress
	return b
}

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) WithBacnetIpGlobalAddressBuilder(builderSupplier func(BACnetHostNPortBuilder) BACnetHostNPortBuilder) BACnetConstructedDataBACnetIPGlobalAddressBuilder {
	builder := builderSupplier(b.BacnetIpGlobalAddress.CreateBACnetHostNPortBuilder())
	var err error
	b.BacnetIpGlobalAddress, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetHostNPortBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) Build() (BACnetConstructedDataBACnetIPGlobalAddress, error) {
	if b.BacnetIpGlobalAddress == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'bacnetIpGlobalAddress' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataBACnetIPGlobalAddress.deepCopy(), nil
}

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) MustBuild() BACnetConstructedDataBACnetIPGlobalAddress {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataBACnetIPGlobalAddressBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataBACnetIPGlobalAddressBuilder().(*_BACnetConstructedDataBACnetIPGlobalAddressBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataBACnetIPGlobalAddressBuilder creates a BACnetConstructedDataBACnetIPGlobalAddressBuilder
func (b *_BACnetConstructedDataBACnetIPGlobalAddress) CreateBACnetConstructedDataBACnetIPGlobalAddressBuilder() BACnetConstructedDataBACnetIPGlobalAddressBuilder {
	if b == nil {
		return NewBACnetConstructedDataBACnetIPGlobalAddressBuilder()
	}
	return &_BACnetConstructedDataBACnetIPGlobalAddressBuilder{_BACnetConstructedDataBACnetIPGlobalAddress: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_BACNET_IP_GLOBAL_ADDRESS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) GetBacnetIpGlobalAddress() BACnetHostNPort {
	return m.BacnetIpGlobalAddress
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) GetActualValue() BACnetHostNPort {
	ctx := context.Background()
	_ = ctx
	return CastBACnetHostNPort(m.GetBacnetIpGlobalAddress())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataBACnetIPGlobalAddress(structType any) BACnetConstructedDataBACnetIPGlobalAddress {
	if casted, ok := structType.(BACnetConstructedDataBACnetIPGlobalAddress); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataBACnetIPGlobalAddress); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) GetTypeName() string {
	return "BACnetConstructedDataBACnetIPGlobalAddress"
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (bacnetIpGlobalAddress)
	lengthInBits += m.BacnetIpGlobalAddress.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataBACnetIPGlobalAddress BACnetConstructedDataBACnetIPGlobalAddress, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataBACnetIPGlobalAddress"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataBACnetIPGlobalAddress")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	bacnetIpGlobalAddress, err := ReadSimpleField[BACnetHostNPort](ctx, "bacnetIpGlobalAddress", ReadComplex[BACnetHostNPort](BACnetHostNPortParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'bacnetIpGlobalAddress' field"))
	}
	m.BacnetIpGlobalAddress = bacnetIpGlobalAddress

	actualValue, err := ReadVirtualField[BACnetHostNPort](ctx, "actualValue", (*BACnetHostNPort)(nil), bacnetIpGlobalAddress)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataBACnetIPGlobalAddress"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataBACnetIPGlobalAddress")
	}

	return m, nil
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataBACnetIPGlobalAddress"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataBACnetIPGlobalAddress")
		}

		if err := WriteSimpleField[BACnetHostNPort](ctx, "bacnetIpGlobalAddress", m.GetBacnetIpGlobalAddress(), WriteComplex[BACnetHostNPort](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'bacnetIpGlobalAddress' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataBACnetIPGlobalAddress"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataBACnetIPGlobalAddress")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) IsBACnetConstructedDataBACnetIPGlobalAddress() {
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) deepCopy() *_BACnetConstructedDataBACnetIPGlobalAddress {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataBACnetIPGlobalAddressCopy := &_BACnetConstructedDataBACnetIPGlobalAddress{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetHostNPort](m.BacnetIpGlobalAddress),
	}
	_BACnetConstructedDataBACnetIPGlobalAddressCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataBACnetIPGlobalAddressCopy
}

func (m *_BACnetConstructedDataBACnetIPGlobalAddress) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
