/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataActiveVTSessions is the corresponding interface of BACnetConstructedDataActiveVTSessions
type BACnetConstructedDataActiveVTSessions interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetActiveVTSession returns ActiveVTSession (property field)
	GetActiveVTSession() []BACnetVTSession
	// IsBACnetConstructedDataActiveVTSessions is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataActiveVTSessions()
	// CreateBuilder creates a BACnetConstructedDataActiveVTSessionsBuilder
	CreateBACnetConstructedDataActiveVTSessionsBuilder() BACnetConstructedDataActiveVTSessionsBuilder
}

// _BACnetConstructedDataActiveVTSessions is the data-structure of this message
type _BACnetConstructedDataActiveVTSessions struct {
	BACnetConstructedDataContract
	ActiveVTSession []BACnetVTSession
}

var _ BACnetConstructedDataActiveVTSessions = (*_BACnetConstructedDataActiveVTSessions)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataActiveVTSessions)(nil)

// NewBACnetConstructedDataActiveVTSessions factory function for _BACnetConstructedDataActiveVTSessions
func NewBACnetConstructedDataActiveVTSessions(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, activeVTSession []BACnetVTSession, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataActiveVTSessions {
	_result := &_BACnetConstructedDataActiveVTSessions{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ActiveVTSession:               activeVTSession,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataActiveVTSessionsBuilder is a builder for BACnetConstructedDataActiveVTSessions
type BACnetConstructedDataActiveVTSessionsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(activeVTSession []BACnetVTSession) BACnetConstructedDataActiveVTSessionsBuilder
	// WithActiveVTSession adds ActiveVTSession (property field)
	WithActiveVTSession(...BACnetVTSession) BACnetConstructedDataActiveVTSessionsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataActiveVTSessions or returns an error if something is wrong
	Build() (BACnetConstructedDataActiveVTSessions, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataActiveVTSessions
}

// NewBACnetConstructedDataActiveVTSessionsBuilder() creates a BACnetConstructedDataActiveVTSessionsBuilder
func NewBACnetConstructedDataActiveVTSessionsBuilder() BACnetConstructedDataActiveVTSessionsBuilder {
	return &_BACnetConstructedDataActiveVTSessionsBuilder{_BACnetConstructedDataActiveVTSessions: new(_BACnetConstructedDataActiveVTSessions)}
}

type _BACnetConstructedDataActiveVTSessionsBuilder struct {
	*_BACnetConstructedDataActiveVTSessions

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataActiveVTSessionsBuilder) = (*_BACnetConstructedDataActiveVTSessionsBuilder)(nil)

func (b *_BACnetConstructedDataActiveVTSessionsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataActiveVTSessions
}

func (b *_BACnetConstructedDataActiveVTSessionsBuilder) WithMandatoryFields(activeVTSession []BACnetVTSession) BACnetConstructedDataActiveVTSessionsBuilder {
	return b.WithActiveVTSession(activeVTSession...)
}

func (b *_BACnetConstructedDataActiveVTSessionsBuilder) WithActiveVTSession(activeVTSession ...BACnetVTSession) BACnetConstructedDataActiveVTSessionsBuilder {
	b.ActiveVTSession = activeVTSession
	return b
}

func (b *_BACnetConstructedDataActiveVTSessionsBuilder) Build() (BACnetConstructedDataActiveVTSessions, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataActiveVTSessions.deepCopy(), nil
}

func (b *_BACnetConstructedDataActiveVTSessionsBuilder) MustBuild() BACnetConstructedDataActiveVTSessions {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataActiveVTSessionsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataActiveVTSessionsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataActiveVTSessionsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataActiveVTSessionsBuilder().(*_BACnetConstructedDataActiveVTSessionsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataActiveVTSessionsBuilder creates a BACnetConstructedDataActiveVTSessionsBuilder
func (b *_BACnetConstructedDataActiveVTSessions) CreateBACnetConstructedDataActiveVTSessionsBuilder() BACnetConstructedDataActiveVTSessionsBuilder {
	if b == nil {
		return NewBACnetConstructedDataActiveVTSessionsBuilder()
	}
	return &_BACnetConstructedDataActiveVTSessionsBuilder{_BACnetConstructedDataActiveVTSessions: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataActiveVTSessions) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataActiveVTSessions) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACTIVE_VT_SESSIONS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataActiveVTSessions) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataActiveVTSessions) GetActiveVTSession() []BACnetVTSession {
	return m.ActiveVTSession
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataActiveVTSessions(structType any) BACnetConstructedDataActiveVTSessions {
	if casted, ok := structType.(BACnetConstructedDataActiveVTSessions); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataActiveVTSessions); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataActiveVTSessions) GetTypeName() string {
	return "BACnetConstructedDataActiveVTSessions"
}

func (m *_BACnetConstructedDataActiveVTSessions) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.ActiveVTSession) > 0 {
		for _, element := range m.ActiveVTSession {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataActiveVTSessions) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataActiveVTSessions) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataActiveVTSessions BACnetConstructedDataActiveVTSessions, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataActiveVTSessions"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataActiveVTSessions")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	activeVTSession, err := ReadTerminatedArrayField[BACnetVTSession](ctx, "activeVTSession", ReadComplex[BACnetVTSession](BACnetVTSessionParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'activeVTSession' field"))
	}
	m.ActiveVTSession = activeVTSession

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataActiveVTSessions"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataActiveVTSessions")
	}

	return m, nil
}

func (m *_BACnetConstructedDataActiveVTSessions) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataActiveVTSessions) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataActiveVTSessions"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataActiveVTSessions")
		}

		if err := WriteComplexTypeArrayField(ctx, "activeVTSession", m.GetActiveVTSession(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'activeVTSession' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataActiveVTSessions"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataActiveVTSessions")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataActiveVTSessions) IsBACnetConstructedDataActiveVTSessions() {}

func (m *_BACnetConstructedDataActiveVTSessions) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataActiveVTSessions) deepCopy() *_BACnetConstructedDataActiveVTSessions {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataActiveVTSessionsCopy := &_BACnetConstructedDataActiveVTSessions{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetVTSession, BACnetVTSession](m.ActiveVTSession),
	}
	_BACnetConstructedDataActiveVTSessionsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataActiveVTSessionsCopy
}

func (m *_BACnetConstructedDataActiveVTSessions) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
