/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataActiveCOVSubscriptions is the corresponding interface of BACnetConstructedDataActiveCOVSubscriptions
type BACnetConstructedDataActiveCOVSubscriptions interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetActiveCOVSubscriptions returns ActiveCOVSubscriptions (property field)
	GetActiveCOVSubscriptions() []BACnetCOVSubscription
	// IsBACnetConstructedDataActiveCOVSubscriptions is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataActiveCOVSubscriptions()
	// CreateBuilder creates a BACnetConstructedDataActiveCOVSubscriptionsBuilder
	CreateBACnetConstructedDataActiveCOVSubscriptionsBuilder() BACnetConstructedDataActiveCOVSubscriptionsBuilder
}

// _BACnetConstructedDataActiveCOVSubscriptions is the data-structure of this message
type _BACnetConstructedDataActiveCOVSubscriptions struct {
	BACnetConstructedDataContract
	ActiveCOVSubscriptions []BACnetCOVSubscription
}

var _ BACnetConstructedDataActiveCOVSubscriptions = (*_BACnetConstructedDataActiveCOVSubscriptions)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataActiveCOVSubscriptions)(nil)

// NewBACnetConstructedDataActiveCOVSubscriptions factory function for _BACnetConstructedDataActiveCOVSubscriptions
func NewBACnetConstructedDataActiveCOVSubscriptions(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, activeCOVSubscriptions []BACnetCOVSubscription, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataActiveCOVSubscriptions {
	_result := &_BACnetConstructedDataActiveCOVSubscriptions{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		ActiveCOVSubscriptions:        activeCOVSubscriptions,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataActiveCOVSubscriptionsBuilder is a builder for BACnetConstructedDataActiveCOVSubscriptions
type BACnetConstructedDataActiveCOVSubscriptionsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(activeCOVSubscriptions []BACnetCOVSubscription) BACnetConstructedDataActiveCOVSubscriptionsBuilder
	// WithActiveCOVSubscriptions adds ActiveCOVSubscriptions (property field)
	WithActiveCOVSubscriptions(...BACnetCOVSubscription) BACnetConstructedDataActiveCOVSubscriptionsBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataActiveCOVSubscriptions or returns an error if something is wrong
	Build() (BACnetConstructedDataActiveCOVSubscriptions, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataActiveCOVSubscriptions
}

// NewBACnetConstructedDataActiveCOVSubscriptionsBuilder() creates a BACnetConstructedDataActiveCOVSubscriptionsBuilder
func NewBACnetConstructedDataActiveCOVSubscriptionsBuilder() BACnetConstructedDataActiveCOVSubscriptionsBuilder {
	return &_BACnetConstructedDataActiveCOVSubscriptionsBuilder{_BACnetConstructedDataActiveCOVSubscriptions: new(_BACnetConstructedDataActiveCOVSubscriptions)}
}

type _BACnetConstructedDataActiveCOVSubscriptionsBuilder struct {
	*_BACnetConstructedDataActiveCOVSubscriptions

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataActiveCOVSubscriptionsBuilder) = (*_BACnetConstructedDataActiveCOVSubscriptionsBuilder)(nil)

func (b *_BACnetConstructedDataActiveCOVSubscriptionsBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataActiveCOVSubscriptions
}

func (b *_BACnetConstructedDataActiveCOVSubscriptionsBuilder) WithMandatoryFields(activeCOVSubscriptions []BACnetCOVSubscription) BACnetConstructedDataActiveCOVSubscriptionsBuilder {
	return b.WithActiveCOVSubscriptions(activeCOVSubscriptions...)
}

func (b *_BACnetConstructedDataActiveCOVSubscriptionsBuilder) WithActiveCOVSubscriptions(activeCOVSubscriptions ...BACnetCOVSubscription) BACnetConstructedDataActiveCOVSubscriptionsBuilder {
	b.ActiveCOVSubscriptions = activeCOVSubscriptions
	return b
}

func (b *_BACnetConstructedDataActiveCOVSubscriptionsBuilder) Build() (BACnetConstructedDataActiveCOVSubscriptions, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataActiveCOVSubscriptions.deepCopy(), nil
}

func (b *_BACnetConstructedDataActiveCOVSubscriptionsBuilder) MustBuild() BACnetConstructedDataActiveCOVSubscriptions {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataActiveCOVSubscriptionsBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataActiveCOVSubscriptionsBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataActiveCOVSubscriptionsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataActiveCOVSubscriptionsBuilder().(*_BACnetConstructedDataActiveCOVSubscriptionsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataActiveCOVSubscriptionsBuilder creates a BACnetConstructedDataActiveCOVSubscriptionsBuilder
func (b *_BACnetConstructedDataActiveCOVSubscriptions) CreateBACnetConstructedDataActiveCOVSubscriptionsBuilder() BACnetConstructedDataActiveCOVSubscriptionsBuilder {
	if b == nil {
		return NewBACnetConstructedDataActiveCOVSubscriptionsBuilder()
	}
	return &_BACnetConstructedDataActiveCOVSubscriptionsBuilder{_BACnetConstructedDataActiveCOVSubscriptions: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataActiveCOVSubscriptions) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACTIVE_COV_SUBSCRIPTIONS
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataActiveCOVSubscriptions) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataActiveCOVSubscriptions) GetActiveCOVSubscriptions() []BACnetCOVSubscription {
	return m.ActiveCOVSubscriptions
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataActiveCOVSubscriptions(structType any) BACnetConstructedDataActiveCOVSubscriptions {
	if casted, ok := structType.(BACnetConstructedDataActiveCOVSubscriptions); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataActiveCOVSubscriptions); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) GetTypeName() string {
	return "BACnetConstructedDataActiveCOVSubscriptions"
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Array field
	if len(m.ActiveCOVSubscriptions) > 0 {
		for _, element := range m.ActiveCOVSubscriptions {
			lengthInBits += element.GetLengthInBits(ctx)
		}
	}

	return lengthInBits
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataActiveCOVSubscriptions BACnetConstructedDataActiveCOVSubscriptions, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataActiveCOVSubscriptions"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataActiveCOVSubscriptions")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	activeCOVSubscriptions, err := ReadTerminatedArrayField[BACnetCOVSubscription](ctx, "activeCOVSubscriptions", ReadComplex[BACnetCOVSubscription](BACnetCOVSubscriptionParseWithBuffer, readBuffer), IsBACnetConstructedDataClosingTag(ctx, readBuffer, false, tagNumber))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'activeCOVSubscriptions' field"))
	}
	m.ActiveCOVSubscriptions = activeCOVSubscriptions

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataActiveCOVSubscriptions"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataActiveCOVSubscriptions")
	}

	return m, nil
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataActiveCOVSubscriptions"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataActiveCOVSubscriptions")
		}

		if err := WriteComplexTypeArrayField(ctx, "activeCOVSubscriptions", m.GetActiveCOVSubscriptions(), writeBuffer); err != nil {
			return errors.Wrap(err, "Error serializing 'activeCOVSubscriptions' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataActiveCOVSubscriptions"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataActiveCOVSubscriptions")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) IsBACnetConstructedDataActiveCOVSubscriptions() {
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) deepCopy() *_BACnetConstructedDataActiveCOVSubscriptions {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataActiveCOVSubscriptionsCopy := &_BACnetConstructedDataActiveCOVSubscriptions{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopySlice[BACnetCOVSubscription, BACnetCOVSubscription](m.ActiveCOVSubscriptions),
	}
	_BACnetConstructedDataActiveCOVSubscriptionsCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataActiveCOVSubscriptionsCopy
}

func (m *_BACnetConstructedDataActiveCOVSubscriptions) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
