/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAccompaniment is the corresponding interface of BACnetConstructedDataAccompaniment
type BACnetConstructedDataAccompaniment interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAccompaniment returns Accompaniment (property field)
	GetAccompaniment() BACnetDeviceObjectReference
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetDeviceObjectReference
	// IsBACnetConstructedDataAccompaniment is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAccompaniment()
	// CreateBuilder creates a BACnetConstructedDataAccompanimentBuilder
	CreateBACnetConstructedDataAccompanimentBuilder() BACnetConstructedDataAccompanimentBuilder
}

// _BACnetConstructedDataAccompaniment is the data-structure of this message
type _BACnetConstructedDataAccompaniment struct {
	BACnetConstructedDataContract
	Accompaniment BACnetDeviceObjectReference
}

var _ BACnetConstructedDataAccompaniment = (*_BACnetConstructedDataAccompaniment)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAccompaniment)(nil)

// NewBACnetConstructedDataAccompaniment factory function for _BACnetConstructedDataAccompaniment
func NewBACnetConstructedDataAccompaniment(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, accompaniment BACnetDeviceObjectReference, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAccompaniment {
	if accompaniment == nil {
		panic("accompaniment of type BACnetDeviceObjectReference for BACnetConstructedDataAccompaniment must not be nil")
	}
	_result := &_BACnetConstructedDataAccompaniment{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		Accompaniment:                 accompaniment,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAccompanimentBuilder is a builder for BACnetConstructedDataAccompaniment
type BACnetConstructedDataAccompanimentBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(accompaniment BACnetDeviceObjectReference) BACnetConstructedDataAccompanimentBuilder
	// WithAccompaniment adds Accompaniment (property field)
	WithAccompaniment(BACnetDeviceObjectReference) BACnetConstructedDataAccompanimentBuilder
	// WithAccompanimentBuilder adds Accompaniment (property field) which is build by the builder
	WithAccompanimentBuilder(func(BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceBuilder) BACnetConstructedDataAccompanimentBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAccompaniment or returns an error if something is wrong
	Build() (BACnetConstructedDataAccompaniment, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAccompaniment
}

// NewBACnetConstructedDataAccompanimentBuilder() creates a BACnetConstructedDataAccompanimentBuilder
func NewBACnetConstructedDataAccompanimentBuilder() BACnetConstructedDataAccompanimentBuilder {
	return &_BACnetConstructedDataAccompanimentBuilder{_BACnetConstructedDataAccompaniment: new(_BACnetConstructedDataAccompaniment)}
}

type _BACnetConstructedDataAccompanimentBuilder struct {
	*_BACnetConstructedDataAccompaniment

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataAccompanimentBuilder) = (*_BACnetConstructedDataAccompanimentBuilder)(nil)

func (b *_BACnetConstructedDataAccompanimentBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAccompaniment
}

func (b *_BACnetConstructedDataAccompanimentBuilder) WithMandatoryFields(accompaniment BACnetDeviceObjectReference) BACnetConstructedDataAccompanimentBuilder {
	return b.WithAccompaniment(accompaniment)
}

func (b *_BACnetConstructedDataAccompanimentBuilder) WithAccompaniment(accompaniment BACnetDeviceObjectReference) BACnetConstructedDataAccompanimentBuilder {
	b.Accompaniment = accompaniment
	return b
}

func (b *_BACnetConstructedDataAccompanimentBuilder) WithAccompanimentBuilder(builderSupplier func(BACnetDeviceObjectReferenceBuilder) BACnetDeviceObjectReferenceBuilder) BACnetConstructedDataAccompanimentBuilder {
	builder := builderSupplier(b.Accompaniment.CreateBACnetDeviceObjectReferenceBuilder())
	var err error
	b.Accompaniment, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectReferenceBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAccompanimentBuilder) Build() (BACnetConstructedDataAccompaniment, error) {
	if b.Accompaniment == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'accompaniment' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataAccompaniment.deepCopy(), nil
}

func (b *_BACnetConstructedDataAccompanimentBuilder) MustBuild() BACnetConstructedDataAccompaniment {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAccompanimentBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAccompanimentBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAccompanimentBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAccompanimentBuilder().(*_BACnetConstructedDataAccompanimentBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataAccompanimentBuilder creates a BACnetConstructedDataAccompanimentBuilder
func (b *_BACnetConstructedDataAccompaniment) CreateBACnetConstructedDataAccompanimentBuilder() BACnetConstructedDataAccompanimentBuilder {
	if b == nil {
		return NewBACnetConstructedDataAccompanimentBuilder()
	}
	return &_BACnetConstructedDataAccompanimentBuilder{_BACnetConstructedDataAccompaniment: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAccompaniment) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAccompaniment) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ACCOMPANIMENT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAccompaniment) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAccompaniment) GetAccompaniment() BACnetDeviceObjectReference {
	return m.Accompaniment
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAccompaniment) GetActualValue() BACnetDeviceObjectReference {
	ctx := context.Background()
	_ = ctx
	return CastBACnetDeviceObjectReference(m.GetAccompaniment())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAccompaniment(structType any) BACnetConstructedDataAccompaniment {
	if casted, ok := structType.(BACnetConstructedDataAccompaniment); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAccompaniment); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAccompaniment) GetTypeName() string {
	return "BACnetConstructedDataAccompaniment"
}

func (m *_BACnetConstructedDataAccompaniment) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (accompaniment)
	lengthInBits += m.Accompaniment.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAccompaniment) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAccompaniment) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAccompaniment BACnetConstructedDataAccompaniment, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAccompaniment"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAccompaniment")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	accompaniment, err := ReadSimpleField[BACnetDeviceObjectReference](ctx, "accompaniment", ReadComplex[BACnetDeviceObjectReference](BACnetDeviceObjectReferenceParseWithBuffer, readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'accompaniment' field"))
	}
	m.Accompaniment = accompaniment

	actualValue, err := ReadVirtualField[BACnetDeviceObjectReference](ctx, "actualValue", (*BACnetDeviceObjectReference)(nil), accompaniment)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAccompaniment"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAccompaniment")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAccompaniment) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAccompaniment) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAccompaniment"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAccompaniment")
		}

		if err := WriteSimpleField[BACnetDeviceObjectReference](ctx, "accompaniment", m.GetAccompaniment(), WriteComplex[BACnetDeviceObjectReference](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'accompaniment' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAccompaniment"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAccompaniment")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAccompaniment) IsBACnetConstructedDataAccompaniment() {}

func (m *_BACnetConstructedDataAccompaniment) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAccompaniment) deepCopy() *_BACnetConstructedDataAccompaniment {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAccompanimentCopy := &_BACnetConstructedDataAccompaniment{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetDeviceObjectReference](m.Accompaniment),
	}
	_BACnetConstructedDataAccompanimentCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAccompanimentCopy
}

func (m *_BACnetConstructedDataAccompaniment) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
