/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConstructedDataAbsenteeLimit is the corresponding interface of BACnetConstructedDataAbsenteeLimit
type BACnetConstructedDataAbsenteeLimit interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConstructedData
	// GetAbsenteeLimit returns AbsenteeLimit (property field)
	GetAbsenteeLimit() BACnetApplicationTagUnsignedInteger
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() BACnetApplicationTagUnsignedInteger
	// IsBACnetConstructedDataAbsenteeLimit is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConstructedDataAbsenteeLimit()
	// CreateBuilder creates a BACnetConstructedDataAbsenteeLimitBuilder
	CreateBACnetConstructedDataAbsenteeLimitBuilder() BACnetConstructedDataAbsenteeLimitBuilder
}

// _BACnetConstructedDataAbsenteeLimit is the data-structure of this message
type _BACnetConstructedDataAbsenteeLimit struct {
	BACnetConstructedDataContract
	AbsenteeLimit BACnetApplicationTagUnsignedInteger
}

var _ BACnetConstructedDataAbsenteeLimit = (*_BACnetConstructedDataAbsenteeLimit)(nil)
var _ BACnetConstructedDataRequirements = (*_BACnetConstructedDataAbsenteeLimit)(nil)

// NewBACnetConstructedDataAbsenteeLimit factory function for _BACnetConstructedDataAbsenteeLimit
func NewBACnetConstructedDataAbsenteeLimit(openingTag BACnetOpeningTag, peekedTagHeader BACnetTagHeader, closingTag BACnetClosingTag, absenteeLimit BACnetApplicationTagUnsignedInteger, tagNumber uint8, arrayIndexArgument BACnetTagPayloadUnsignedInteger) *_BACnetConstructedDataAbsenteeLimit {
	if absenteeLimit == nil {
		panic("absenteeLimit of type BACnetApplicationTagUnsignedInteger for BACnetConstructedDataAbsenteeLimit must not be nil")
	}
	_result := &_BACnetConstructedDataAbsenteeLimit{
		BACnetConstructedDataContract: NewBACnetConstructedData(openingTag, peekedTagHeader, closingTag, tagNumber, arrayIndexArgument),
		AbsenteeLimit:                 absenteeLimit,
	}
	_result.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConstructedDataAbsenteeLimitBuilder is a builder for BACnetConstructedDataAbsenteeLimit
type BACnetConstructedDataAbsenteeLimitBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(absenteeLimit BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAbsenteeLimitBuilder
	// WithAbsenteeLimit adds AbsenteeLimit (property field)
	WithAbsenteeLimit(BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAbsenteeLimitBuilder
	// WithAbsenteeLimitBuilder adds AbsenteeLimit (property field) which is build by the builder
	WithAbsenteeLimitBuilder(func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataAbsenteeLimitBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConstructedDataBuilder
	// Build builds the BACnetConstructedDataAbsenteeLimit or returns an error if something is wrong
	Build() (BACnetConstructedDataAbsenteeLimit, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConstructedDataAbsenteeLimit
}

// NewBACnetConstructedDataAbsenteeLimitBuilder() creates a BACnetConstructedDataAbsenteeLimitBuilder
func NewBACnetConstructedDataAbsenteeLimitBuilder() BACnetConstructedDataAbsenteeLimitBuilder {
	return &_BACnetConstructedDataAbsenteeLimitBuilder{_BACnetConstructedDataAbsenteeLimit: new(_BACnetConstructedDataAbsenteeLimit)}
}

type _BACnetConstructedDataAbsenteeLimitBuilder struct {
	*_BACnetConstructedDataAbsenteeLimit

	parentBuilder *_BACnetConstructedDataBuilder

	err *utils.MultiError
}

var _ (BACnetConstructedDataAbsenteeLimitBuilder) = (*_BACnetConstructedDataAbsenteeLimitBuilder)(nil)

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) setParent(contract BACnetConstructedDataContract) {
	b.BACnetConstructedDataContract = contract
	contract.(*_BACnetConstructedData)._SubType = b._BACnetConstructedDataAbsenteeLimit
}

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) WithMandatoryFields(absenteeLimit BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAbsenteeLimitBuilder {
	return b.WithAbsenteeLimit(absenteeLimit)
}

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) WithAbsenteeLimit(absenteeLimit BACnetApplicationTagUnsignedInteger) BACnetConstructedDataAbsenteeLimitBuilder {
	b.AbsenteeLimit = absenteeLimit
	return b
}

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) WithAbsenteeLimitBuilder(builderSupplier func(BACnetApplicationTagUnsignedIntegerBuilder) BACnetApplicationTagUnsignedIntegerBuilder) BACnetConstructedDataAbsenteeLimitBuilder {
	builder := builderSupplier(b.AbsenteeLimit.CreateBACnetApplicationTagUnsignedIntegerBuilder())
	var err error
	b.AbsenteeLimit, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) Build() (BACnetConstructedDataAbsenteeLimit, error) {
	if b.AbsenteeLimit == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'absenteeLimit' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConstructedDataAbsenteeLimit.deepCopy(), nil
}

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) MustBuild() BACnetConstructedDataAbsenteeLimit {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) Done() BACnetConstructedDataBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConstructedDataBuilder().(*_BACnetConstructedDataBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) buildForBACnetConstructedData() (BACnetConstructedData, error) {
	return b.Build()
}

func (b *_BACnetConstructedDataAbsenteeLimitBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConstructedDataAbsenteeLimitBuilder().(*_BACnetConstructedDataAbsenteeLimitBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConstructedDataAbsenteeLimitBuilder creates a BACnetConstructedDataAbsenteeLimitBuilder
func (b *_BACnetConstructedDataAbsenteeLimit) CreateBACnetConstructedDataAbsenteeLimitBuilder() BACnetConstructedDataAbsenteeLimitBuilder {
	if b == nil {
		return NewBACnetConstructedDataAbsenteeLimitBuilder()
	}
	return &_BACnetConstructedDataAbsenteeLimitBuilder{_BACnetConstructedDataAbsenteeLimit: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConstructedDataAbsenteeLimit) GetObjectTypeArgument() BACnetObjectType {
	return 0
}

func (m *_BACnetConstructedDataAbsenteeLimit) GetPropertyIdentifierArgument() BACnetPropertyIdentifier {
	return BACnetPropertyIdentifier_ABSENTEE_LIMIT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConstructedDataAbsenteeLimit) GetParent() BACnetConstructedDataContract {
	return m.BACnetConstructedDataContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConstructedDataAbsenteeLimit) GetAbsenteeLimit() BACnetApplicationTagUnsignedInteger {
	return m.AbsenteeLimit
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetConstructedDataAbsenteeLimit) GetActualValue() BACnetApplicationTagUnsignedInteger {
	ctx := context.Background()
	_ = ctx
	return CastBACnetApplicationTagUnsignedInteger(m.GetAbsenteeLimit())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConstructedDataAbsenteeLimit(structType any) BACnetConstructedDataAbsenteeLimit {
	if casted, ok := structType.(BACnetConstructedDataAbsenteeLimit); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConstructedDataAbsenteeLimit); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConstructedDataAbsenteeLimit) GetTypeName() string {
	return "BACnetConstructedDataAbsenteeLimit"
}

func (m *_BACnetConstructedDataAbsenteeLimit) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConstructedDataContract.(*_BACnetConstructedData).getLengthInBits(ctx))

	// Simple field (absenteeLimit)
	lengthInBits += m.AbsenteeLimit.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetConstructedDataAbsenteeLimit) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConstructedDataAbsenteeLimit) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConstructedData, tagNumber uint8, objectTypeArgument BACnetObjectType, propertyIdentifierArgument BACnetPropertyIdentifier, arrayIndexArgument BACnetTagPayloadUnsignedInteger) (__bACnetConstructedDataAbsenteeLimit BACnetConstructedDataAbsenteeLimit, err error) {
	m.BACnetConstructedDataContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConstructedDataAbsenteeLimit"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConstructedDataAbsenteeLimit")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	absenteeLimit, err := ReadSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "absenteeLimit", ReadComplex[BACnetApplicationTagUnsignedInteger](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagUnsignedInteger](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'absenteeLimit' field"))
	}
	m.AbsenteeLimit = absenteeLimit

	actualValue, err := ReadVirtualField[BACnetApplicationTagUnsignedInteger](ctx, "actualValue", (*BACnetApplicationTagUnsignedInteger)(nil), absenteeLimit)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetConstructedDataAbsenteeLimit"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConstructedDataAbsenteeLimit")
	}

	return m, nil
}

func (m *_BACnetConstructedDataAbsenteeLimit) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConstructedDataAbsenteeLimit) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConstructedDataAbsenteeLimit"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConstructedDataAbsenteeLimit")
		}

		if err := WriteSimpleField[BACnetApplicationTagUnsignedInteger](ctx, "absenteeLimit", m.GetAbsenteeLimit(), WriteComplex[BACnetApplicationTagUnsignedInteger](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'absenteeLimit' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConstructedDataAbsenteeLimit"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConstructedDataAbsenteeLimit")
		}
		return nil
	}
	return m.BACnetConstructedDataContract.(*_BACnetConstructedData).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConstructedDataAbsenteeLimit) IsBACnetConstructedDataAbsenteeLimit() {}

func (m *_BACnetConstructedDataAbsenteeLimit) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConstructedDataAbsenteeLimit) deepCopy() *_BACnetConstructedDataAbsenteeLimit {
	if m == nil {
		return nil
	}
	_BACnetConstructedDataAbsenteeLimitCopy := &_BACnetConstructedDataAbsenteeLimit{
		m.BACnetConstructedDataContract.(*_BACnetConstructedData).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagUnsignedInteger](m.AbsenteeLimit),
	}
	_BACnetConstructedDataAbsenteeLimitCopy.BACnetConstructedDataContract.(*_BACnetConstructedData)._SubType = m
	return _BACnetConstructedDataAbsenteeLimitCopy
}

func (m *_BACnetConstructedDataAbsenteeLimit) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
