/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetConfirmedServiceRequestGetEnrollmentSummary is the corresponding interface of BACnetConfirmedServiceRequestGetEnrollmentSummary
type BACnetConfirmedServiceRequestGetEnrollmentSummary interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetConfirmedServiceRequest
	// GetAcknowledgmentFilter returns AcknowledgmentFilter (property field)
	GetAcknowledgmentFilter() BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged
	// GetEnrollmentFilter returns EnrollmentFilter (property field)
	GetEnrollmentFilter() BACnetRecipientProcessEnclosed
	// GetEventStateFilter returns EventStateFilter (property field)
	GetEventStateFilter() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged
	// GetEventTypeFilter returns EventTypeFilter (property field)
	GetEventTypeFilter() BACnetEventTypeTagged
	// GetPriorityFilter returns PriorityFilter (property field)
	GetPriorityFilter() BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter
	// GetNotificationClassFilter returns NotificationClassFilter (property field)
	GetNotificationClassFilter() BACnetContextTagUnsignedInteger
	// IsBACnetConfirmedServiceRequestGetEnrollmentSummary is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetConfirmedServiceRequestGetEnrollmentSummary()
	// CreateBuilder creates a BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder() BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
}

// _BACnetConfirmedServiceRequestGetEnrollmentSummary is the data-structure of this message
type _BACnetConfirmedServiceRequestGetEnrollmentSummary struct {
	BACnetConfirmedServiceRequestContract
	AcknowledgmentFilter    BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged
	EnrollmentFilter        BACnetRecipientProcessEnclosed
	EventStateFilter        BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged
	EventTypeFilter         BACnetEventTypeTagged
	PriorityFilter          BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter
	NotificationClassFilter BACnetContextTagUnsignedInteger
}

var _ BACnetConfirmedServiceRequestGetEnrollmentSummary = (*_BACnetConfirmedServiceRequestGetEnrollmentSummary)(nil)
var _ BACnetConfirmedServiceRequestRequirements = (*_BACnetConfirmedServiceRequestGetEnrollmentSummary)(nil)

// NewBACnetConfirmedServiceRequestGetEnrollmentSummary factory function for _BACnetConfirmedServiceRequestGetEnrollmentSummary
func NewBACnetConfirmedServiceRequestGetEnrollmentSummary(acknowledgmentFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged, enrollmentFilter BACnetRecipientProcessEnclosed, eventStateFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged, eventTypeFilter BACnetEventTypeTagged, priorityFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter, notificationClassFilter BACnetContextTagUnsignedInteger, serviceRequestLength uint32) *_BACnetConfirmedServiceRequestGetEnrollmentSummary {
	if acknowledgmentFilter == nil {
		panic("acknowledgmentFilter of type BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged for BACnetConfirmedServiceRequestGetEnrollmentSummary must not be nil")
	}
	_result := &_BACnetConfirmedServiceRequestGetEnrollmentSummary{
		BACnetConfirmedServiceRequestContract: NewBACnetConfirmedServiceRequest(serviceRequestLength),
		AcknowledgmentFilter:                  acknowledgmentFilter,
		EnrollmentFilter:                      enrollmentFilter,
		EventStateFilter:                      eventStateFilter,
		EventTypeFilter:                       eventTypeFilter,
		PriorityFilter:                        priorityFilter,
		NotificationClassFilter:               notificationClassFilter,
	}
	_result.BACnetConfirmedServiceRequestContract.(*_BACnetConfirmedServiceRequest)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder is a builder for BACnetConfirmedServiceRequestGetEnrollmentSummary
type BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(acknowledgmentFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithAcknowledgmentFilter adds AcknowledgmentFilter (property field)
	WithAcknowledgmentFilter(BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithAcknowledgmentFilterBuilder adds AcknowledgmentFilter (property field) which is build by the builder
	WithAcknowledgmentFilterBuilder(func(BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithEnrollmentFilter adds EnrollmentFilter (property field)
	WithOptionalEnrollmentFilter(BACnetRecipientProcessEnclosed) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithOptionalEnrollmentFilterBuilder adds EnrollmentFilter (property field) which is build by the builder
	WithOptionalEnrollmentFilterBuilder(func(BACnetRecipientProcessEnclosedBuilder) BACnetRecipientProcessEnclosedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithEventStateFilter adds EventStateFilter (property field)
	WithOptionalEventStateFilter(BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithOptionalEventStateFilterBuilder adds EventStateFilter (property field) which is build by the builder
	WithOptionalEventStateFilterBuilder(func(BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithEventTypeFilter adds EventTypeFilter (property field)
	WithOptionalEventTypeFilter(BACnetEventTypeTagged) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithOptionalEventTypeFilterBuilder adds EventTypeFilter (property field) which is build by the builder
	WithOptionalEventTypeFilterBuilder(func(BACnetEventTypeTaggedBuilder) BACnetEventTypeTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithPriorityFilter adds PriorityFilter (property field)
	WithOptionalPriorityFilter(BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithOptionalPriorityFilterBuilder adds PriorityFilter (property field) which is build by the builder
	WithOptionalPriorityFilterBuilder(func(BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithNotificationClassFilter adds NotificationClassFilter (property field)
	WithOptionalNotificationClassFilter(BACnetContextTagUnsignedInteger) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// WithOptionalNotificationClassFilterBuilder adds NotificationClassFilter (property field) which is build by the builder
	WithOptionalNotificationClassFilterBuilder(func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetConfirmedServiceRequestBuilder
	// Build builds the BACnetConfirmedServiceRequestGetEnrollmentSummary or returns an error if something is wrong
	Build() (BACnetConfirmedServiceRequestGetEnrollmentSummary, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetConfirmedServiceRequestGetEnrollmentSummary
}

// NewBACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder() creates a BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
func NewBACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder() BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	return &_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder{_BACnetConfirmedServiceRequestGetEnrollmentSummary: new(_BACnetConfirmedServiceRequestGetEnrollmentSummary)}
}

type _BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder struct {
	*_BACnetConfirmedServiceRequestGetEnrollmentSummary

	parentBuilder *_BACnetConfirmedServiceRequestBuilder

	err *utils.MultiError
}

var _ (BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) = (*_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder)(nil)

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) setParent(contract BACnetConfirmedServiceRequestContract) {
	b.BACnetConfirmedServiceRequestContract = contract
	contract.(*_BACnetConfirmedServiceRequest)._SubType = b._BACnetConfirmedServiceRequestGetEnrollmentSummary
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithMandatoryFields(acknowledgmentFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	return b.WithAcknowledgmentFilter(acknowledgmentFilter)
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithAcknowledgmentFilter(acknowledgmentFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	b.AcknowledgmentFilter = acknowledgmentFilter
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithAcknowledgmentFilterBuilder(builderSupplier func(BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	builder := builderSupplier(b.AcknowledgmentFilter.CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedBuilder())
	var err error
	b.AcknowledgmentFilter, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalEnrollmentFilter(enrollmentFilter BACnetRecipientProcessEnclosed) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	b.EnrollmentFilter = enrollmentFilter
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalEnrollmentFilterBuilder(builderSupplier func(BACnetRecipientProcessEnclosedBuilder) BACnetRecipientProcessEnclosedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	builder := builderSupplier(b.EnrollmentFilter.CreateBACnetRecipientProcessEnclosedBuilder())
	var err error
	b.EnrollmentFilter, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetRecipientProcessEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalEventStateFilter(eventStateFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	b.EventStateFilter = eventStateFilter
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalEventStateFilterBuilder(builderSupplier func(BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	builder := builderSupplier(b.EventStateFilter.CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder())
	var err error
	b.EventStateFilter, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalEventTypeFilter(eventTypeFilter BACnetEventTypeTagged) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	b.EventTypeFilter = eventTypeFilter
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalEventTypeFilterBuilder(builderSupplier func(BACnetEventTypeTaggedBuilder) BACnetEventTypeTaggedBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	builder := builderSupplier(b.EventTypeFilter.CreateBACnetEventTypeTaggedBuilder())
	var err error
	b.EventTypeFilter, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetEventTypeTaggedBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalPriorityFilter(priorityFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	b.PriorityFilter = priorityFilter
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalPriorityFilterBuilder(builderSupplier func(BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	builder := builderSupplier(b.PriorityFilter.CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterBuilder())
	var err error
	b.PriorityFilter, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalNotificationClassFilter(notificationClassFilter BACnetContextTagUnsignedInteger) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	b.NotificationClassFilter = notificationClassFilter
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) WithOptionalNotificationClassFilterBuilder(builderSupplier func(BACnetContextTagUnsignedIntegerBuilder) BACnetContextTagUnsignedIntegerBuilder) BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	builder := builderSupplier(b.NotificationClassFilter.CreateBACnetContextTagUnsignedIntegerBuilder())
	var err error
	b.NotificationClassFilter, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagUnsignedIntegerBuilder failed"))
	}
	return b
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) Build() (BACnetConfirmedServiceRequestGetEnrollmentSummary, error) {
	if b.AcknowledgmentFilter == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'acknowledgmentFilter' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetConfirmedServiceRequestGetEnrollmentSummary.deepCopy(), nil
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) MustBuild() BACnetConfirmedServiceRequestGetEnrollmentSummary {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) Done() BACnetConfirmedServiceRequestBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetConfirmedServiceRequestBuilder().(*_BACnetConfirmedServiceRequestBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) buildForBACnetConfirmedServiceRequest() (BACnetConfirmedServiceRequest, error) {
	return b.Build()
}

func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder) DeepCopy() any {
	_copy := b.CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder().(*_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder creates a BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder
func (b *_BACnetConfirmedServiceRequestGetEnrollmentSummary) CreateBACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder() BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder {
	if b == nil {
		return NewBACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder()
	}
	return &_BACnetConfirmedServiceRequestGetEnrollmentSummaryBuilder{_BACnetConfirmedServiceRequestGetEnrollmentSummary: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetServiceChoice() BACnetConfirmedServiceChoice {
	return BACnetConfirmedServiceChoice_GET_ENROLLMENT_SUMMARY
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetParent() BACnetConfirmedServiceRequestContract {
	return m.BACnetConfirmedServiceRequestContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetAcknowledgmentFilter() BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged {
	return m.AcknowledgmentFilter
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetEnrollmentFilter() BACnetRecipientProcessEnclosed {
	return m.EnrollmentFilter
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetEventStateFilter() BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged {
	return m.EventStateFilter
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetEventTypeFilter() BACnetEventTypeTagged {
	return m.EventTypeFilter
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetPriorityFilter() BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter {
	return m.PriorityFilter
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetNotificationClassFilter() BACnetContextTagUnsignedInteger {
	return m.NotificationClassFilter
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetConfirmedServiceRequestGetEnrollmentSummary(structType any) BACnetConfirmedServiceRequestGetEnrollmentSummary {
	if casted, ok := structType.(BACnetConfirmedServiceRequestGetEnrollmentSummary); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetConfirmedServiceRequestGetEnrollmentSummary); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetTypeName() string {
	return "BACnetConfirmedServiceRequestGetEnrollmentSummary"
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetConfirmedServiceRequestContract.(*_BACnetConfirmedServiceRequest).getLengthInBits(ctx))

	// Simple field (acknowledgmentFilter)
	lengthInBits += m.AcknowledgmentFilter.GetLengthInBits(ctx)

	// Optional Field (enrollmentFilter)
	if m.EnrollmentFilter != nil {
		lengthInBits += m.EnrollmentFilter.GetLengthInBits(ctx)
	}

	// Optional Field (eventStateFilter)
	if m.EventStateFilter != nil {
		lengthInBits += m.EventStateFilter.GetLengthInBits(ctx)
	}

	// Optional Field (eventTypeFilter)
	if m.EventTypeFilter != nil {
		lengthInBits += m.EventTypeFilter.GetLengthInBits(ctx)
	}

	// Optional Field (priorityFilter)
	if m.PriorityFilter != nil {
		lengthInBits += m.PriorityFilter.GetLengthInBits(ctx)
	}

	// Optional Field (notificationClassFilter)
	if m.NotificationClassFilter != nil {
		lengthInBits += m.NotificationClassFilter.GetLengthInBits(ctx)
	}

	return lengthInBits
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetConfirmedServiceRequest, serviceRequestLength uint32) (__bACnetConfirmedServiceRequestGetEnrollmentSummary BACnetConfirmedServiceRequestGetEnrollmentSummary, err error) {
	m.BACnetConfirmedServiceRequestContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetConfirmedServiceRequestGetEnrollmentSummary"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetConfirmedServiceRequestGetEnrollmentSummary")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	acknowledgmentFilter, err := ReadSimpleField[BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged](ctx, "acknowledgmentFilter", ReadComplex[BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged](BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTaggedParseWithBufferProducer((uint8)(uint8(0)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'acknowledgmentFilter' field"))
	}
	m.AcknowledgmentFilter = acknowledgmentFilter

	var enrollmentFilter BACnetRecipientProcessEnclosed
	_enrollmentFilter, err := ReadOptionalField[BACnetRecipientProcessEnclosed](ctx, "enrollmentFilter", ReadComplex[BACnetRecipientProcessEnclosed](BACnetRecipientProcessEnclosedParseWithBufferProducer((uint8)(uint8(1))), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enrollmentFilter' field"))
	}
	if _enrollmentFilter != nil {
		enrollmentFilter = *_enrollmentFilter
		m.EnrollmentFilter = enrollmentFilter
	}

	var eventStateFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged
	_eventStateFilter, err := ReadOptionalField[BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged](ctx, "eventStateFilter", ReadComplex[BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged](BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTaggedParseWithBufferProducer((uint8)(uint8(2)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventStateFilter' field"))
	}
	if _eventStateFilter != nil {
		eventStateFilter = *_eventStateFilter
		m.EventStateFilter = eventStateFilter
	}

	var eventTypeFilter BACnetEventTypeTagged
	_eventTypeFilter, err := ReadOptionalField[BACnetEventTypeTagged](ctx, "eventTypeFilter", ReadComplex[BACnetEventTypeTagged](BACnetEventTypeTaggedParseWithBufferProducer((uint8)(uint8(3)), (TagClass)(TagClass_CONTEXT_SPECIFIC_TAGS)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'eventTypeFilter' field"))
	}
	if _eventTypeFilter != nil {
		eventTypeFilter = *_eventTypeFilter
		m.EventTypeFilter = eventTypeFilter
	}

	var priorityFilter BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter
	_priorityFilter, err := ReadOptionalField[BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter](ctx, "priorityFilter", ReadComplex[BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter](BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilterParseWithBufferProducer((uint8)(uint8(4))), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'priorityFilter' field"))
	}
	if _priorityFilter != nil {
		priorityFilter = *_priorityFilter
		m.PriorityFilter = priorityFilter
	}

	var notificationClassFilter BACnetContextTagUnsignedInteger
	_notificationClassFilter, err := ReadOptionalField[BACnetContextTagUnsignedInteger](ctx, "notificationClassFilter", ReadComplex[BACnetContextTagUnsignedInteger](BACnetContextTagParseWithBufferProducer[BACnetContextTagUnsignedInteger]((uint8)(uint8(5)), (BACnetDataType)(BACnetDataType_UNSIGNED_INTEGER)), readBuffer), true)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'notificationClassFilter' field"))
	}
	if _notificationClassFilter != nil {
		notificationClassFilter = *_notificationClassFilter
		m.NotificationClassFilter = notificationClassFilter
	}

	if closeErr := readBuffer.CloseContext("BACnetConfirmedServiceRequestGetEnrollmentSummary"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetConfirmedServiceRequestGetEnrollmentSummary")
	}

	return m, nil
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetConfirmedServiceRequestGetEnrollmentSummary"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetConfirmedServiceRequestGetEnrollmentSummary")
		}

		if err := WriteSimpleField[BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged](ctx, "acknowledgmentFilter", m.GetAcknowledgmentFilter(), WriteComplex[BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'acknowledgmentFilter' field")
		}

		if err := WriteOptionalField[BACnetRecipientProcessEnclosed](ctx, "enrollmentFilter", GetRef(m.GetEnrollmentFilter()), WriteComplex[BACnetRecipientProcessEnclosed](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'enrollmentFilter' field")
		}

		if err := WriteOptionalField[BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged](ctx, "eventStateFilter", GetRef(m.GetEventStateFilter()), WriteComplex[BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'eventStateFilter' field")
		}

		if err := WriteOptionalField[BACnetEventTypeTagged](ctx, "eventTypeFilter", GetRef(m.GetEventTypeFilter()), WriteComplex[BACnetEventTypeTagged](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'eventTypeFilter' field")
		}

		if err := WriteOptionalField[BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter](ctx, "priorityFilter", GetRef(m.GetPriorityFilter()), WriteComplex[BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'priorityFilter' field")
		}

		if err := WriteOptionalField[BACnetContextTagUnsignedInteger](ctx, "notificationClassFilter", GetRef(m.GetNotificationClassFilter()), WriteComplex[BACnetContextTagUnsignedInteger](writeBuffer), true); err != nil {
			return errors.Wrap(err, "Error serializing 'notificationClassFilter' field")
		}

		if popErr := writeBuffer.PopContext("BACnetConfirmedServiceRequestGetEnrollmentSummary"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetConfirmedServiceRequestGetEnrollmentSummary")
		}
		return nil
	}
	return m.BACnetConfirmedServiceRequestContract.(*_BACnetConfirmedServiceRequest).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) IsBACnetConfirmedServiceRequestGetEnrollmentSummary() {
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) deepCopy() *_BACnetConfirmedServiceRequestGetEnrollmentSummary {
	if m == nil {
		return nil
	}
	_BACnetConfirmedServiceRequestGetEnrollmentSummaryCopy := &_BACnetConfirmedServiceRequestGetEnrollmentSummary{
		m.BACnetConfirmedServiceRequestContract.(*_BACnetConfirmedServiceRequest).deepCopy(),
		utils.DeepCopy[BACnetConfirmedServiceRequestGetEnrollmentSummaryAcknowledgementFilterTagged](m.AcknowledgmentFilter),
		utils.DeepCopy[BACnetRecipientProcessEnclosed](m.EnrollmentFilter),
		utils.DeepCopy[BACnetConfirmedServiceRequestGetEnrollmentSummaryEventStateFilterTagged](m.EventStateFilter),
		utils.DeepCopy[BACnetEventTypeTagged](m.EventTypeFilter),
		utils.DeepCopy[BACnetConfirmedServiceRequestGetEnrollmentSummaryPriorityFilter](m.PriorityFilter),
		utils.DeepCopy[BACnetContextTagUnsignedInteger](m.NotificationClassFilter),
	}
	_BACnetConfirmedServiceRequestGetEnrollmentSummaryCopy.BACnetConfirmedServiceRequestContract.(*_BACnetConfirmedServiceRequest)._SubType = m
	return _BACnetConfirmedServiceRequestGetEnrollmentSummaryCopy
}

func (m *_BACnetConfirmedServiceRequestGetEnrollmentSummary) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
