/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetChannelValueDate is the corresponding interface of BACnetChannelValueDate
type BACnetChannelValueDate interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetChannelValue
	// GetDateValue returns DateValue (property field)
	GetDateValue() BACnetApplicationTagDate
	// IsBACnetChannelValueDate is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetChannelValueDate()
	// CreateBuilder creates a BACnetChannelValueDateBuilder
	CreateBACnetChannelValueDateBuilder() BACnetChannelValueDateBuilder
}

// _BACnetChannelValueDate is the data-structure of this message
type _BACnetChannelValueDate struct {
	BACnetChannelValueContract
	DateValue BACnetApplicationTagDate
}

var _ BACnetChannelValueDate = (*_BACnetChannelValueDate)(nil)
var _ BACnetChannelValueRequirements = (*_BACnetChannelValueDate)(nil)

// NewBACnetChannelValueDate factory function for _BACnetChannelValueDate
func NewBACnetChannelValueDate(peekedTagHeader BACnetTagHeader, dateValue BACnetApplicationTagDate) *_BACnetChannelValueDate {
	if dateValue == nil {
		panic("dateValue of type BACnetApplicationTagDate for BACnetChannelValueDate must not be nil")
	}
	_result := &_BACnetChannelValueDate{
		BACnetChannelValueContract: NewBACnetChannelValue(peekedTagHeader),
		DateValue:                  dateValue,
	}
	_result.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetChannelValueDateBuilder is a builder for BACnetChannelValueDate
type BACnetChannelValueDateBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(dateValue BACnetApplicationTagDate) BACnetChannelValueDateBuilder
	// WithDateValue adds DateValue (property field)
	WithDateValue(BACnetApplicationTagDate) BACnetChannelValueDateBuilder
	// WithDateValueBuilder adds DateValue (property field) which is build by the builder
	WithDateValueBuilder(func(BACnetApplicationTagDateBuilder) BACnetApplicationTagDateBuilder) BACnetChannelValueDateBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetChannelValueBuilder
	// Build builds the BACnetChannelValueDate or returns an error if something is wrong
	Build() (BACnetChannelValueDate, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetChannelValueDate
}

// NewBACnetChannelValueDateBuilder() creates a BACnetChannelValueDateBuilder
func NewBACnetChannelValueDateBuilder() BACnetChannelValueDateBuilder {
	return &_BACnetChannelValueDateBuilder{_BACnetChannelValueDate: new(_BACnetChannelValueDate)}
}

type _BACnetChannelValueDateBuilder struct {
	*_BACnetChannelValueDate

	parentBuilder *_BACnetChannelValueBuilder

	err *utils.MultiError
}

var _ (BACnetChannelValueDateBuilder) = (*_BACnetChannelValueDateBuilder)(nil)

func (b *_BACnetChannelValueDateBuilder) setParent(contract BACnetChannelValueContract) {
	b.BACnetChannelValueContract = contract
	contract.(*_BACnetChannelValue)._SubType = b._BACnetChannelValueDate
}

func (b *_BACnetChannelValueDateBuilder) WithMandatoryFields(dateValue BACnetApplicationTagDate) BACnetChannelValueDateBuilder {
	return b.WithDateValue(dateValue)
}

func (b *_BACnetChannelValueDateBuilder) WithDateValue(dateValue BACnetApplicationTagDate) BACnetChannelValueDateBuilder {
	b.DateValue = dateValue
	return b
}

func (b *_BACnetChannelValueDateBuilder) WithDateValueBuilder(builderSupplier func(BACnetApplicationTagDateBuilder) BACnetApplicationTagDateBuilder) BACnetChannelValueDateBuilder {
	builder := builderSupplier(b.DateValue.CreateBACnetApplicationTagDateBuilder())
	var err error
	b.DateValue, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetApplicationTagDateBuilder failed"))
	}
	return b
}

func (b *_BACnetChannelValueDateBuilder) Build() (BACnetChannelValueDate, error) {
	if b.DateValue == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'dateValue' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetChannelValueDate.deepCopy(), nil
}

func (b *_BACnetChannelValueDateBuilder) MustBuild() BACnetChannelValueDate {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetChannelValueDateBuilder) Done() BACnetChannelValueBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetChannelValueBuilder().(*_BACnetChannelValueBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetChannelValueDateBuilder) buildForBACnetChannelValue() (BACnetChannelValue, error) {
	return b.Build()
}

func (b *_BACnetChannelValueDateBuilder) DeepCopy() any {
	_copy := b.CreateBACnetChannelValueDateBuilder().(*_BACnetChannelValueDateBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetChannelValueDateBuilder creates a BACnetChannelValueDateBuilder
func (b *_BACnetChannelValueDate) CreateBACnetChannelValueDateBuilder() BACnetChannelValueDateBuilder {
	if b == nil {
		return NewBACnetChannelValueDateBuilder()
	}
	return &_BACnetChannelValueDateBuilder{_BACnetChannelValueDate: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetChannelValueDate) GetParent() BACnetChannelValueContract {
	return m.BACnetChannelValueContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetChannelValueDate) GetDateValue() BACnetApplicationTagDate {
	return m.DateValue
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetChannelValueDate(structType any) BACnetChannelValueDate {
	if casted, ok := structType.(BACnetChannelValueDate); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetChannelValueDate); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetChannelValueDate) GetTypeName() string {
	return "BACnetChannelValueDate"
}

func (m *_BACnetChannelValueDate) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetChannelValueContract.(*_BACnetChannelValue).getLengthInBits(ctx))

	// Simple field (dateValue)
	lengthInBits += m.DateValue.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetChannelValueDate) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetChannelValueDate) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetChannelValue) (__bACnetChannelValueDate BACnetChannelValueDate, err error) {
	m.BACnetChannelValueContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetChannelValueDate"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetChannelValueDate")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	dateValue, err := ReadSimpleField[BACnetApplicationTagDate](ctx, "dateValue", ReadComplex[BACnetApplicationTagDate](BACnetApplicationTagParseWithBufferProducer[BACnetApplicationTagDate](), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'dateValue' field"))
	}
	m.DateValue = dateValue

	if closeErr := readBuffer.CloseContext("BACnetChannelValueDate"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetChannelValueDate")
	}

	return m, nil
}

func (m *_BACnetChannelValueDate) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetChannelValueDate) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetChannelValueDate"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetChannelValueDate")
		}

		if err := WriteSimpleField[BACnetApplicationTagDate](ctx, "dateValue", m.GetDateValue(), WriteComplex[BACnetApplicationTagDate](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'dateValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetChannelValueDate"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetChannelValueDate")
		}
		return nil
	}
	return m.BACnetChannelValueContract.(*_BACnetChannelValue).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetChannelValueDate) IsBACnetChannelValueDate() {}

func (m *_BACnetChannelValueDate) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetChannelValueDate) deepCopy() *_BACnetChannelValueDate {
	if m == nil {
		return nil
	}
	_BACnetChannelValueDateCopy := &_BACnetChannelValueDate{
		m.BACnetChannelValueContract.(*_BACnetChannelValue).deepCopy(),
		utils.DeepCopy[BACnetApplicationTagDate](m.DateValue),
	}
	_BACnetChannelValueDateCopy.BACnetChannelValueContract.(*_BACnetChannelValue)._SubType = m
	return _BACnetChannelValueDateCopy
}

func (m *_BACnetChannelValueDate) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
