/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetAssignedAccessRights is the corresponding interface of BACnetAssignedAccessRights
type BACnetAssignedAccessRights interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// GetAssignedAccessRights returns AssignedAccessRights (property field)
	GetAssignedAccessRights() BACnetDeviceObjectReferenceEnclosed
	// GetEnable returns Enable (property field)
	GetEnable() BACnetContextTagBoolean
	// IsBACnetAssignedAccessRights is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetAssignedAccessRights()
	// CreateBuilder creates a BACnetAssignedAccessRightsBuilder
	CreateBACnetAssignedAccessRightsBuilder() BACnetAssignedAccessRightsBuilder
}

// _BACnetAssignedAccessRights is the data-structure of this message
type _BACnetAssignedAccessRights struct {
	AssignedAccessRights BACnetDeviceObjectReferenceEnclosed
	Enable               BACnetContextTagBoolean
}

var _ BACnetAssignedAccessRights = (*_BACnetAssignedAccessRights)(nil)

// NewBACnetAssignedAccessRights factory function for _BACnetAssignedAccessRights
func NewBACnetAssignedAccessRights(assignedAccessRights BACnetDeviceObjectReferenceEnclosed, enable BACnetContextTagBoolean) *_BACnetAssignedAccessRights {
	if assignedAccessRights == nil {
		panic("assignedAccessRights of type BACnetDeviceObjectReferenceEnclosed for BACnetAssignedAccessRights must not be nil")
	}
	if enable == nil {
		panic("enable of type BACnetContextTagBoolean for BACnetAssignedAccessRights must not be nil")
	}
	return &_BACnetAssignedAccessRights{AssignedAccessRights: assignedAccessRights, Enable: enable}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetAssignedAccessRightsBuilder is a builder for BACnetAssignedAccessRights
type BACnetAssignedAccessRightsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(assignedAccessRights BACnetDeviceObjectReferenceEnclosed, enable BACnetContextTagBoolean) BACnetAssignedAccessRightsBuilder
	// WithAssignedAccessRights adds AssignedAccessRights (property field)
	WithAssignedAccessRights(BACnetDeviceObjectReferenceEnclosed) BACnetAssignedAccessRightsBuilder
	// WithAssignedAccessRightsBuilder adds AssignedAccessRights (property field) which is build by the builder
	WithAssignedAccessRightsBuilder(func(BACnetDeviceObjectReferenceEnclosedBuilder) BACnetDeviceObjectReferenceEnclosedBuilder) BACnetAssignedAccessRightsBuilder
	// WithEnable adds Enable (property field)
	WithEnable(BACnetContextTagBoolean) BACnetAssignedAccessRightsBuilder
	// WithEnableBuilder adds Enable (property field) which is build by the builder
	WithEnableBuilder(func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetAssignedAccessRightsBuilder
	// Build builds the BACnetAssignedAccessRights or returns an error if something is wrong
	Build() (BACnetAssignedAccessRights, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetAssignedAccessRights
}

// NewBACnetAssignedAccessRightsBuilder() creates a BACnetAssignedAccessRightsBuilder
func NewBACnetAssignedAccessRightsBuilder() BACnetAssignedAccessRightsBuilder {
	return &_BACnetAssignedAccessRightsBuilder{_BACnetAssignedAccessRights: new(_BACnetAssignedAccessRights)}
}

type _BACnetAssignedAccessRightsBuilder struct {
	*_BACnetAssignedAccessRights

	err *utils.MultiError
}

var _ (BACnetAssignedAccessRightsBuilder) = (*_BACnetAssignedAccessRightsBuilder)(nil)

func (b *_BACnetAssignedAccessRightsBuilder) WithMandatoryFields(assignedAccessRights BACnetDeviceObjectReferenceEnclosed, enable BACnetContextTagBoolean) BACnetAssignedAccessRightsBuilder {
	return b.WithAssignedAccessRights(assignedAccessRights).WithEnable(enable)
}

func (b *_BACnetAssignedAccessRightsBuilder) WithAssignedAccessRights(assignedAccessRights BACnetDeviceObjectReferenceEnclosed) BACnetAssignedAccessRightsBuilder {
	b.AssignedAccessRights = assignedAccessRights
	return b
}

func (b *_BACnetAssignedAccessRightsBuilder) WithAssignedAccessRightsBuilder(builderSupplier func(BACnetDeviceObjectReferenceEnclosedBuilder) BACnetDeviceObjectReferenceEnclosedBuilder) BACnetAssignedAccessRightsBuilder {
	builder := builderSupplier(b.AssignedAccessRights.CreateBACnetDeviceObjectReferenceEnclosedBuilder())
	var err error
	b.AssignedAccessRights, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetDeviceObjectReferenceEnclosedBuilder failed"))
	}
	return b
}

func (b *_BACnetAssignedAccessRightsBuilder) WithEnable(enable BACnetContextTagBoolean) BACnetAssignedAccessRightsBuilder {
	b.Enable = enable
	return b
}

func (b *_BACnetAssignedAccessRightsBuilder) WithEnableBuilder(builderSupplier func(BACnetContextTagBooleanBuilder) BACnetContextTagBooleanBuilder) BACnetAssignedAccessRightsBuilder {
	builder := builderSupplier(b.Enable.CreateBACnetContextTagBooleanBuilder())
	var err error
	b.Enable, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetContextTagBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetAssignedAccessRightsBuilder) Build() (BACnetAssignedAccessRights, error) {
	if b.AssignedAccessRights == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'assignedAccessRights' not set"))
	}
	if b.Enable == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'enable' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetAssignedAccessRights.deepCopy(), nil
}

func (b *_BACnetAssignedAccessRightsBuilder) MustBuild() BACnetAssignedAccessRights {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetAssignedAccessRightsBuilder) DeepCopy() any {
	_copy := b.CreateBACnetAssignedAccessRightsBuilder().(*_BACnetAssignedAccessRightsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetAssignedAccessRightsBuilder creates a BACnetAssignedAccessRightsBuilder
func (b *_BACnetAssignedAccessRights) CreateBACnetAssignedAccessRightsBuilder() BACnetAssignedAccessRightsBuilder {
	if b == nil {
		return NewBACnetAssignedAccessRightsBuilder()
	}
	return &_BACnetAssignedAccessRightsBuilder{_BACnetAssignedAccessRights: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetAssignedAccessRights) GetAssignedAccessRights() BACnetDeviceObjectReferenceEnclosed {
	return m.AssignedAccessRights
}

func (m *_BACnetAssignedAccessRights) GetEnable() BACnetContextTagBoolean {
	return m.Enable
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetAssignedAccessRights(structType any) BACnetAssignedAccessRights {
	if casted, ok := structType.(BACnetAssignedAccessRights); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetAssignedAccessRights); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetAssignedAccessRights) GetTypeName() string {
	return "BACnetAssignedAccessRights"
}

func (m *_BACnetAssignedAccessRights) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Simple field (assignedAccessRights)
	lengthInBits += m.AssignedAccessRights.GetLengthInBits(ctx)

	// Simple field (enable)
	lengthInBits += m.Enable.GetLengthInBits(ctx)

	return lengthInBits
}

func (m *_BACnetAssignedAccessRights) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetAssignedAccessRightsParse(ctx context.Context, theBytes []byte) (BACnetAssignedAccessRights, error) {
	return BACnetAssignedAccessRightsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetAssignedAccessRightsParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAssignedAccessRights, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAssignedAccessRights, error) {
		return BACnetAssignedAccessRightsParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetAssignedAccessRightsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetAssignedAccessRights, error) {
	v, err := (&_BACnetAssignedAccessRights{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetAssignedAccessRights) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetAssignedAccessRights BACnetAssignedAccessRights, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetAssignedAccessRights"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetAssignedAccessRights")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	assignedAccessRights, err := ReadSimpleField[BACnetDeviceObjectReferenceEnclosed](ctx, "assignedAccessRights", ReadComplex[BACnetDeviceObjectReferenceEnclosed](BACnetDeviceObjectReferenceEnclosedParseWithBufferProducer((uint8)(uint8(0))), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'assignedAccessRights' field"))
	}
	m.AssignedAccessRights = assignedAccessRights

	enable, err := ReadSimpleField[BACnetContextTagBoolean](ctx, "enable", ReadComplex[BACnetContextTagBoolean](BACnetContextTagParseWithBufferProducer[BACnetContextTagBoolean]((uint8)(uint8(1)), (BACnetDataType)(BACnetDataType_BOOLEAN)), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'enable' field"))
	}
	m.Enable = enable

	if closeErr := readBuffer.CloseContext("BACnetAssignedAccessRights"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetAssignedAccessRights")
	}

	return m, nil
}

func (m *_BACnetAssignedAccessRights) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetAssignedAccessRights) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetAssignedAccessRights"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetAssignedAccessRights")
	}

	if err := WriteSimpleField[BACnetDeviceObjectReferenceEnclosed](ctx, "assignedAccessRights", m.GetAssignedAccessRights(), WriteComplex[BACnetDeviceObjectReferenceEnclosed](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'assignedAccessRights' field")
	}

	if err := WriteSimpleField[BACnetContextTagBoolean](ctx, "enable", m.GetEnable(), WriteComplex[BACnetContextTagBoolean](writeBuffer)); err != nil {
		return errors.Wrap(err, "Error serializing 'enable' field")
	}

	if popErr := writeBuffer.PopContext("BACnetAssignedAccessRights"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetAssignedAccessRights")
	}
	return nil
}

func (m *_BACnetAssignedAccessRights) IsBACnetAssignedAccessRights() {}

func (m *_BACnetAssignedAccessRights) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetAssignedAccessRights) deepCopy() *_BACnetAssignedAccessRights {
	if m == nil {
		return nil
	}
	_BACnetAssignedAccessRightsCopy := &_BACnetAssignedAccessRights{
		utils.DeepCopy[BACnetDeviceObjectReferenceEnclosed](m.AssignedAccessRights),
		utils.DeepCopy[BACnetContextTagBoolean](m.Enable),
	}
	return _BACnetAssignedAccessRightsCopy
}

func (m *_BACnetAssignedAccessRights) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
