/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetApplicationTagBoolean is the corresponding interface of BACnetApplicationTagBoolean
type BACnetApplicationTagBoolean interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	BACnetApplicationTag
	// GetPayload returns Payload (property field)
	GetPayload() BACnetTagPayloadBoolean
	// GetActualValue returns ActualValue (virtual field)
	GetActualValue() bool
	// IsBACnetApplicationTagBoolean is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetApplicationTagBoolean()
	// CreateBuilder creates a BACnetApplicationTagBooleanBuilder
	CreateBACnetApplicationTagBooleanBuilder() BACnetApplicationTagBooleanBuilder
}

// _BACnetApplicationTagBoolean is the data-structure of this message
type _BACnetApplicationTagBoolean struct {
	BACnetApplicationTagContract
	Payload BACnetTagPayloadBoolean
}

var _ BACnetApplicationTagBoolean = (*_BACnetApplicationTagBoolean)(nil)
var _ BACnetApplicationTagRequirements = (*_BACnetApplicationTagBoolean)(nil)

// NewBACnetApplicationTagBoolean factory function for _BACnetApplicationTagBoolean
func NewBACnetApplicationTagBoolean(header BACnetTagHeader, payload BACnetTagPayloadBoolean) *_BACnetApplicationTagBoolean {
	if payload == nil {
		panic("payload of type BACnetTagPayloadBoolean for BACnetApplicationTagBoolean must not be nil")
	}
	_result := &_BACnetApplicationTagBoolean{
		BACnetApplicationTagContract: NewBACnetApplicationTag(header),
		Payload:                      payload,
	}
	_result.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetApplicationTagBooleanBuilder is a builder for BACnetApplicationTagBoolean
type BACnetApplicationTagBooleanBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields(payload BACnetTagPayloadBoolean) BACnetApplicationTagBooleanBuilder
	// WithPayload adds Payload (property field)
	WithPayload(BACnetTagPayloadBoolean) BACnetApplicationTagBooleanBuilder
	// WithPayloadBuilder adds Payload (property field) which is build by the builder
	WithPayloadBuilder(func(BACnetTagPayloadBooleanBuilder) BACnetTagPayloadBooleanBuilder) BACnetApplicationTagBooleanBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() BACnetApplicationTagBuilder
	// Build builds the BACnetApplicationTagBoolean or returns an error if something is wrong
	Build() (BACnetApplicationTagBoolean, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetApplicationTagBoolean
}

// NewBACnetApplicationTagBooleanBuilder() creates a BACnetApplicationTagBooleanBuilder
func NewBACnetApplicationTagBooleanBuilder() BACnetApplicationTagBooleanBuilder {
	return &_BACnetApplicationTagBooleanBuilder{_BACnetApplicationTagBoolean: new(_BACnetApplicationTagBoolean)}
}

type _BACnetApplicationTagBooleanBuilder struct {
	*_BACnetApplicationTagBoolean

	parentBuilder *_BACnetApplicationTagBuilder

	err *utils.MultiError
}

var _ (BACnetApplicationTagBooleanBuilder) = (*_BACnetApplicationTagBooleanBuilder)(nil)

func (b *_BACnetApplicationTagBooleanBuilder) setParent(contract BACnetApplicationTagContract) {
	b.BACnetApplicationTagContract = contract
	contract.(*_BACnetApplicationTag)._SubType = b._BACnetApplicationTagBoolean
}

func (b *_BACnetApplicationTagBooleanBuilder) WithMandatoryFields(payload BACnetTagPayloadBoolean) BACnetApplicationTagBooleanBuilder {
	return b.WithPayload(payload)
}

func (b *_BACnetApplicationTagBooleanBuilder) WithPayload(payload BACnetTagPayloadBoolean) BACnetApplicationTagBooleanBuilder {
	b.Payload = payload
	return b
}

func (b *_BACnetApplicationTagBooleanBuilder) WithPayloadBuilder(builderSupplier func(BACnetTagPayloadBooleanBuilder) BACnetTagPayloadBooleanBuilder) BACnetApplicationTagBooleanBuilder {
	builder := builderSupplier(b.Payload.CreateBACnetTagPayloadBooleanBuilder())
	var err error
	b.Payload, err = builder.Build()
	if err != nil {
		if b.err == nil {
			b.err = &utils.MultiError{MainError: errors.New("sub builder failed")}
		}
		b.err.Append(errors.Wrap(err, "BACnetTagPayloadBooleanBuilder failed"))
	}
	return b
}

func (b *_BACnetApplicationTagBooleanBuilder) Build() (BACnetApplicationTagBoolean, error) {
	if b.Payload == nil {
		if b.err == nil {
			b.err = new(utils.MultiError)
		}
		b.err.Append(errors.New("mandatory field 'payload' not set"))
	}
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._BACnetApplicationTagBoolean.deepCopy(), nil
}

func (b *_BACnetApplicationTagBooleanBuilder) MustBuild() BACnetApplicationTagBoolean {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetApplicationTagBooleanBuilder) Done() BACnetApplicationTagBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewBACnetApplicationTagBuilder().(*_BACnetApplicationTagBuilder)
	}
	return b.parentBuilder
}

func (b *_BACnetApplicationTagBooleanBuilder) buildForBACnetApplicationTag() (BACnetApplicationTag, error) {
	return b.Build()
}

func (b *_BACnetApplicationTagBooleanBuilder) DeepCopy() any {
	_copy := b.CreateBACnetApplicationTagBooleanBuilder().(*_BACnetApplicationTagBooleanBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateBACnetApplicationTagBooleanBuilder creates a BACnetApplicationTagBooleanBuilder
func (b *_BACnetApplicationTagBoolean) CreateBACnetApplicationTagBooleanBuilder() BACnetApplicationTagBooleanBuilder {
	if b == nil {
		return NewBACnetApplicationTagBooleanBuilder()
	}
	return &_BACnetApplicationTagBooleanBuilder{_BACnetApplicationTagBoolean: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_BACnetApplicationTagBoolean) GetParent() BACnetApplicationTagContract {
	return m.BACnetApplicationTagContract
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for property fields.
///////////////////////

func (m *_BACnetApplicationTagBoolean) GetPayload() BACnetTagPayloadBoolean {
	return m.Payload
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for virtual fields.
///////////////////////

func (m *_BACnetApplicationTagBoolean) GetActualValue() bool {
	ctx := context.Background()
	_ = ctx
	return bool(m.GetPayload().GetValue())
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetApplicationTagBoolean(structType any) BACnetApplicationTagBoolean {
	if casted, ok := structType.(BACnetApplicationTagBoolean); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetApplicationTagBoolean); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetApplicationTagBoolean) GetTypeName() string {
	return "BACnetApplicationTagBoolean"
}

func (m *_BACnetApplicationTagBoolean) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.BACnetApplicationTagContract.(*_BACnetApplicationTag).getLengthInBits(ctx))

	// Simple field (payload)
	lengthInBits += m.Payload.GetLengthInBits(ctx)

	// A virtual field doesn't have any in- or output.

	return lengthInBits
}

func (m *_BACnetApplicationTagBoolean) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_BACnetApplicationTagBoolean) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_BACnetApplicationTag, header BACnetTagHeader) (__bACnetApplicationTagBoolean BACnetApplicationTagBoolean, err error) {
	m.BACnetApplicationTagContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetApplicationTagBoolean"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetApplicationTagBoolean")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	payload, err := ReadSimpleField[BACnetTagPayloadBoolean](ctx, "payload", ReadComplex[BACnetTagPayloadBoolean](BACnetTagPayloadBooleanParseWithBufferProducer((uint32)(header.GetActualLength())), readBuffer))
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'payload' field"))
	}
	m.Payload = payload

	actualValue, err := ReadVirtualField[bool](ctx, "actualValue", (*bool)(nil), payload.GetValue())
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'actualValue' field"))
	}
	_ = actualValue

	if closeErr := readBuffer.CloseContext("BACnetApplicationTagBoolean"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetApplicationTagBoolean")
	}

	return m, nil
}

func (m *_BACnetApplicationTagBoolean) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetApplicationTagBoolean) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("BACnetApplicationTagBoolean"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for BACnetApplicationTagBoolean")
		}

		if err := WriteSimpleField[BACnetTagPayloadBoolean](ctx, "payload", m.GetPayload(), WriteComplex[BACnetTagPayloadBoolean](writeBuffer)); err != nil {
			return errors.Wrap(err, "Error serializing 'payload' field")
		}
		// Virtual field
		actualValue := m.GetActualValue()
		_ = actualValue
		if _actualValueErr := writeBuffer.WriteVirtual(ctx, "actualValue", m.GetActualValue()); _actualValueErr != nil {
			return errors.Wrap(_actualValueErr, "Error serializing 'actualValue' field")
		}

		if popErr := writeBuffer.PopContext("BACnetApplicationTagBoolean"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for BACnetApplicationTagBoolean")
		}
		return nil
	}
	return m.BACnetApplicationTagContract.(*_BACnetApplicationTag).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_BACnetApplicationTagBoolean) IsBACnetApplicationTagBoolean() {}

func (m *_BACnetApplicationTagBoolean) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetApplicationTagBoolean) deepCopy() *_BACnetApplicationTagBoolean {
	if m == nil {
		return nil
	}
	_BACnetApplicationTagBooleanCopy := &_BACnetApplicationTagBoolean{
		m.BACnetApplicationTagContract.(*_BACnetApplicationTag).deepCopy(),
		utils.DeepCopy[BACnetTagPayloadBoolean](m.Payload),
	}
	_BACnetApplicationTagBooleanCopy.BACnetApplicationTagContract.(*_BACnetApplicationTag)._SubType = m
	return _BACnetApplicationTagBooleanCopy
}

func (m *_BACnetApplicationTagBoolean) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
