/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// AdsReadDeviceInfoRequest is the corresponding interface of AdsReadDeviceInfoRequest
type AdsReadDeviceInfoRequest interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	AmsPacket
	// IsAdsReadDeviceInfoRequest is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAdsReadDeviceInfoRequest()
	// CreateBuilder creates a AdsReadDeviceInfoRequestBuilder
	CreateAdsReadDeviceInfoRequestBuilder() AdsReadDeviceInfoRequestBuilder
}

// _AdsReadDeviceInfoRequest is the data-structure of this message
type _AdsReadDeviceInfoRequest struct {
	AmsPacketContract
}

var _ AdsReadDeviceInfoRequest = (*_AdsReadDeviceInfoRequest)(nil)
var _ AmsPacketRequirements = (*_AdsReadDeviceInfoRequest)(nil)

// NewAdsReadDeviceInfoRequest factory function for _AdsReadDeviceInfoRequest
func NewAdsReadDeviceInfoRequest(targetAmsNetId AmsNetId, targetAmsPort uint16, sourceAmsNetId AmsNetId, sourceAmsPort uint16, errorCode uint32, invokeId uint32) *_AdsReadDeviceInfoRequest {
	_result := &_AdsReadDeviceInfoRequest{
		AmsPacketContract: NewAmsPacket(targetAmsNetId, targetAmsPort, sourceAmsNetId, sourceAmsPort, errorCode, invokeId),
	}
	_result.AmsPacketContract.(*_AmsPacket)._SubType = _result
	return _result
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AdsReadDeviceInfoRequestBuilder is a builder for AdsReadDeviceInfoRequest
type AdsReadDeviceInfoRequestBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() AdsReadDeviceInfoRequestBuilder
	// Done is used to finish work on this child and return (or create one if none) to the parent builder
	Done() AmsPacketBuilder
	// Build builds the AdsReadDeviceInfoRequest or returns an error if something is wrong
	Build() (AdsReadDeviceInfoRequest, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AdsReadDeviceInfoRequest
}

// NewAdsReadDeviceInfoRequestBuilder() creates a AdsReadDeviceInfoRequestBuilder
func NewAdsReadDeviceInfoRequestBuilder() AdsReadDeviceInfoRequestBuilder {
	return &_AdsReadDeviceInfoRequestBuilder{_AdsReadDeviceInfoRequest: new(_AdsReadDeviceInfoRequest)}
}

type _AdsReadDeviceInfoRequestBuilder struct {
	*_AdsReadDeviceInfoRequest

	parentBuilder *_AmsPacketBuilder

	err *utils.MultiError
}

var _ (AdsReadDeviceInfoRequestBuilder) = (*_AdsReadDeviceInfoRequestBuilder)(nil)

func (b *_AdsReadDeviceInfoRequestBuilder) setParent(contract AmsPacketContract) {
	b.AmsPacketContract = contract
	contract.(*_AmsPacket)._SubType = b._AdsReadDeviceInfoRequest
}

func (b *_AdsReadDeviceInfoRequestBuilder) WithMandatoryFields() AdsReadDeviceInfoRequestBuilder {
	return b
}

func (b *_AdsReadDeviceInfoRequestBuilder) Build() (AdsReadDeviceInfoRequest, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AdsReadDeviceInfoRequest.deepCopy(), nil
}

func (b *_AdsReadDeviceInfoRequestBuilder) MustBuild() AdsReadDeviceInfoRequest {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AdsReadDeviceInfoRequestBuilder) Done() AmsPacketBuilder {
	if b.parentBuilder == nil {
		b.parentBuilder = NewAmsPacketBuilder().(*_AmsPacketBuilder)
	}
	return b.parentBuilder
}

func (b *_AdsReadDeviceInfoRequestBuilder) buildForAmsPacket() (AmsPacket, error) {
	return b.Build()
}

func (b *_AdsReadDeviceInfoRequestBuilder) DeepCopy() any {
	_copy := b.CreateAdsReadDeviceInfoRequestBuilder().(*_AdsReadDeviceInfoRequestBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAdsReadDeviceInfoRequestBuilder creates a AdsReadDeviceInfoRequestBuilder
func (b *_AdsReadDeviceInfoRequest) CreateAdsReadDeviceInfoRequestBuilder() AdsReadDeviceInfoRequestBuilder {
	if b == nil {
		return NewAdsReadDeviceInfoRequestBuilder()
	}
	return &_AdsReadDeviceInfoRequestBuilder{_AdsReadDeviceInfoRequest: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for discriminator values.
///////////////////////

func (m *_AdsReadDeviceInfoRequest) GetCommandId() CommandId {
	return CommandId_ADS_READ_DEVICE_INFO
}

func (m *_AdsReadDeviceInfoRequest) GetResponse() bool {
	return bool(false)
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

func (m *_AdsReadDeviceInfoRequest) GetParent() AmsPacketContract {
	return m.AmsPacketContract
}

// Deprecated: use the interface for direct cast
func CastAdsReadDeviceInfoRequest(structType any) AdsReadDeviceInfoRequest {
	if casted, ok := structType.(AdsReadDeviceInfoRequest); ok {
		return casted
	}
	if casted, ok := structType.(*AdsReadDeviceInfoRequest); ok {
		return *casted
	}
	return nil
}

func (m *_AdsReadDeviceInfoRequest) GetTypeName() string {
	return "AdsReadDeviceInfoRequest"
}

func (m *_AdsReadDeviceInfoRequest) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(m.AmsPacketContract.(*_AmsPacket).getLengthInBits(ctx))

	return lengthInBits
}

func (m *_AdsReadDeviceInfoRequest) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func (m *_AdsReadDeviceInfoRequest) parse(ctx context.Context, readBuffer utils.ReadBuffer, parent *_AmsPacket) (__adsReadDeviceInfoRequest AdsReadDeviceInfoRequest, err error) {
	m.AmsPacketContract = parent
	parent._SubType = m
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AdsReadDeviceInfoRequest"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdsReadDeviceInfoRequest")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	if closeErr := readBuffer.CloseContext("AdsReadDeviceInfoRequest"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdsReadDeviceInfoRequest")
	}

	return m, nil
}

func (m *_AdsReadDeviceInfoRequest) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdsReadDeviceInfoRequest) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	ser := func() error {
		if pushErr := writeBuffer.PushContext("AdsReadDeviceInfoRequest"); pushErr != nil {
			return errors.Wrap(pushErr, "Error pushing for AdsReadDeviceInfoRequest")
		}

		if popErr := writeBuffer.PopContext("AdsReadDeviceInfoRequest"); popErr != nil {
			return errors.Wrap(popErr, "Error popping for AdsReadDeviceInfoRequest")
		}
		return nil
	}
	return m.AmsPacketContract.(*_AmsPacket).serializeParent(ctx, writeBuffer, m, ser)
}

func (m *_AdsReadDeviceInfoRequest) IsAdsReadDeviceInfoRequest() {}

func (m *_AdsReadDeviceInfoRequest) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AdsReadDeviceInfoRequest) deepCopy() *_AdsReadDeviceInfoRequest {
	if m == nil {
		return nil
	}
	_AdsReadDeviceInfoRequestCopy := &_AdsReadDeviceInfoRequest{
		m.AmsPacketContract.(*_AmsPacket).deepCopy(),
	}
	_AdsReadDeviceInfoRequestCopy.AmsPacketContract.(*_AmsPacket)._SubType = m
	return _AdsReadDeviceInfoRequestCopy
}

func (m *_AdsReadDeviceInfoRequest) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
