/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	. "github.com/apache/plc4x/plc4go/spi/codegen/fields"
	. "github.com/apache/plc4x/plc4go/spi/codegen/io"
	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// Constant values.
const AdsConstants_ADSTCPDEFAULTPORT uint16 = uint16(48898)

// AdsConstants is the corresponding interface of AdsConstants
type AdsConstants interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsAdsConstants is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsAdsConstants()
	// CreateBuilder creates a AdsConstantsBuilder
	CreateAdsConstantsBuilder() AdsConstantsBuilder
}

// _AdsConstants is the data-structure of this message
type _AdsConstants struct {
}

var _ AdsConstants = (*_AdsConstants)(nil)

// NewAdsConstants factory function for _AdsConstants
func NewAdsConstants() *_AdsConstants {
	return &_AdsConstants{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// AdsConstantsBuilder is a builder for AdsConstants
type AdsConstantsBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() AdsConstantsBuilder
	// Build builds the AdsConstants or returns an error if something is wrong
	Build() (AdsConstants, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() AdsConstants
}

// NewAdsConstantsBuilder() creates a AdsConstantsBuilder
func NewAdsConstantsBuilder() AdsConstantsBuilder {
	return &_AdsConstantsBuilder{_AdsConstants: new(_AdsConstants)}
}

type _AdsConstantsBuilder struct {
	*_AdsConstants

	err *utils.MultiError
}

var _ (AdsConstantsBuilder) = (*_AdsConstantsBuilder)(nil)

func (b *_AdsConstantsBuilder) WithMandatoryFields() AdsConstantsBuilder {
	return b
}

func (b *_AdsConstantsBuilder) Build() (AdsConstants, error) {
	if b.err != nil {
		return nil, errors.Wrap(b.err, "error occurred during build")
	}
	return b._AdsConstants.deepCopy(), nil
}

func (b *_AdsConstantsBuilder) MustBuild() AdsConstants {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_AdsConstantsBuilder) DeepCopy() any {
	_copy := b.CreateAdsConstantsBuilder().(*_AdsConstantsBuilder)
	if b.err != nil {
		_copy.err = b.err.DeepCopy().(*utils.MultiError)
	}
	return _copy
}

// CreateAdsConstantsBuilder creates a AdsConstantsBuilder
func (b *_AdsConstants) CreateAdsConstantsBuilder() AdsConstantsBuilder {
	if b == nil {
		return NewAdsConstantsBuilder()
	}
	return &_AdsConstantsBuilder{_AdsConstants: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Accessors for const fields.
///////////////////////

func (m *_AdsConstants) GetAdsTcpDefaultPort() uint16 {
	return AdsConstants_ADSTCPDEFAULTPORT
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastAdsConstants(structType any) AdsConstants {
	if casted, ok := structType.(AdsConstants); ok {
		return casted
	}
	if casted, ok := structType.(*AdsConstants); ok {
		return *casted
	}
	return nil
}

func (m *_AdsConstants) GetTypeName() string {
	return "AdsConstants"
}

func (m *_AdsConstants) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	// Const Field (adsTcpDefaultPort)
	lengthInBits += 16

	return lengthInBits
}

func (m *_AdsConstants) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func AdsConstantsParse(ctx context.Context, theBytes []byte) (AdsConstants, error) {
	return AdsConstantsParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func AdsConstantsParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (AdsConstants, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (AdsConstants, error) {
		return AdsConstantsParseWithBuffer(ctx, readBuffer)
	}
}

func AdsConstantsParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (AdsConstants, error) {
	v, err := (&_AdsConstants{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_AdsConstants) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__adsConstants AdsConstants, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("AdsConstants"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for AdsConstants")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	adsTcpDefaultPort, err := ReadConstField[uint16](ctx, "adsTcpDefaultPort", ReadUnsignedShort(readBuffer, uint8(16)), AdsConstants_ADSTCPDEFAULTPORT)
	if err != nil {
		return nil, errors.Wrap(err, fmt.Sprintf("Error parsing 'adsTcpDefaultPort' field"))
	}
	_ = adsTcpDefaultPort

	if closeErr := readBuffer.CloseContext("AdsConstants"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for AdsConstants")
	}

	return m, nil
}

func (m *_AdsConstants) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_AdsConstants) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("AdsConstants"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for AdsConstants")
	}

	if err := WriteConstField(ctx, "adsTcpDefaultPort", AdsConstants_ADSTCPDEFAULTPORT, WriteUnsignedShort(writeBuffer, 16)); err != nil {
		return errors.Wrap(err, "Error serializing 'adsTcpDefaultPort' field")
	}

	if popErr := writeBuffer.PopContext("AdsConstants"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for AdsConstants")
	}
	return nil
}

func (m *_AdsConstants) IsAdsConstants() {}

func (m *_AdsConstants) DeepCopy() any {
	return m.deepCopy()
}

func (m *_AdsConstants) deepCopy() *_AdsConstants {
	if m == nil {
		return nil
	}
	_AdsConstantsCopy := &_AdsConstants{}
	return _AdsConstantsCopy
}

func (m *_AdsConstants) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
