/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.df1.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class DF1UnprotectedReadResponse extends DF1Command implements Message {

  // Accessors for discriminator values.
  public Short getCommandCode() {
    return (short) 0x41;
  }

  // Properties.
  protected final byte[] data;

  public DF1UnprotectedReadResponse(short status, int transactionCounter, byte[] data) {
    super(status, transactionCounter);
    this.data = data;
  }

  public byte[] getData() {
    return data;
  }

  @Override
  protected void serializeDF1CommandChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("DF1UnprotectedReadResponse");

    // Manual Array Field (data)
    writeManualArrayField(
        "data",
        data,
        (Byte _value) ->
            org.apache.plc4x.java.df1.readwrite.utils.StaticHelper.writeData(writeBuffer, _value),
        writeBuffer);

    writeBuffer.popContext("DF1UnprotectedReadResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    DF1UnprotectedReadResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Manual Array Field (data)
    lengthInBits += org.apache.plc4x.java.df1.readwrite.utils.StaticHelper.dataLength(data) * 8;

    return lengthInBits;
  }

  public static DF1CommandBuilder staticParseDF1CommandBuilder(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("DF1UnprotectedReadResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    byte[] data =
        readManualByteArrayField(
            "data",
            readBuffer,
            (byte[] _values) ->
                (boolean)
                    (org.apache.plc4x.java.df1.readwrite.utils.StaticHelper.dataTerminate(
                        readBuffer)),
            () ->
                (byte)
                    (org.apache.plc4x.java.df1.readwrite.utils.StaticHelper.readData(readBuffer)));

    readBuffer.closeContext("DF1UnprotectedReadResponse");
    // Create the instance
    return new DF1UnprotectedReadResponseBuilderImpl(data);
  }

  public static class DF1UnprotectedReadResponseBuilderImpl
      implements DF1Command.DF1CommandBuilder {
    private final byte[] data;

    public DF1UnprotectedReadResponseBuilderImpl(byte[] data) {
      this.data = data;
    }

    public DF1UnprotectedReadResponse build(short status, int transactionCounter) {
      DF1UnprotectedReadResponse dF1UnprotectedReadResponse =
          new DF1UnprotectedReadResponse(status, transactionCounter, data);
      return dF1UnprotectedReadResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof DF1UnprotectedReadResponse)) {
      return false;
    }
    DF1UnprotectedReadResponse that = (DF1UnprotectedReadResponse) o;
    return (getData() == that.getData()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
