/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.socketcan.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SocketCANFrame implements Message {

  // Properties.
  protected final int rawId;
  protected final byte[] data;

  public SocketCANFrame(int rawId, byte[] data) {
    super();
    this.rawId = rawId;
    this.data = data;
  }

  public int getRawId() {
    return rawId;
  }

  public byte[] getData() {
    return data;
  }

  public int getIdentifier() {
    return (int)
        (org.apache.plc4x.java.socketcan.readwrite.utils.StaticHelper.readIdentifier(getRawId()));
  }

  public boolean getExtended() {
    return (boolean)
        (org.apache.plc4x.java.socketcan.readwrite.utils.StaticHelper.isExtended(getRawId()));
  }

  public boolean getRemote() {
    return (boolean)
        (org.apache.plc4x.java.socketcan.readwrite.utils.StaticHelper.isRemote(getRawId()));
  }

  public boolean getError() {
    return (boolean)
        (org.apache.plc4x.java.socketcan.readwrite.utils.StaticHelper.isError(getRawId()));
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SocketCANFrame");

    // Simple Field (rawId)
    writeSimpleField(
        "rawId",
        rawId,
        writeSignedInt(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    int identifier = getIdentifier();
    writeBuffer.writeVirtual("identifier", identifier);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean extended = getExtended();
    writeBuffer.writeVirtual("extended", extended);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean remote = getRemote();
    writeBuffer.writeVirtual("remote", remote);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean error = getError();
    writeBuffer.writeVirtual("error", error);

    // Implicit Field (size) (Used for parsing, but its value is not stored as it's implicitly given
    // by the objects content)
    short size = (short) (COUNT(getData()));
    writeImplicitField(
        "size",
        size,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        (short) 0x0,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        (short) 0x0,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        (short) 0x0,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Array Field (data)
    writeByteArrayField(
        "data",
        data,
        writeByteArray(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Padding Field (padding)
    writePaddingField(
        "padding",
        (int) ((8) - ((COUNT(data)))),
        (short) 0x00,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("SocketCANFrame");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    SocketCANFrame _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (rawId)
    lengthInBits += 32;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // Implicit Field (size)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Reserved Field (reserved)
    lengthInBits += 8;

    // Array field
    if (data != null) {
      lengthInBits += 8 * data.length;
    }

    // Padding Field (padding)
    int _timesPadding = (int) ((8) - ((COUNT(data))));
    while (_timesPadding-- > 0) {
      lengthInBits += 8;
    }

    return lengthInBits;
  }

  public static SocketCANFrame staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static SocketCANFrame staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("SocketCANFrame");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int rawId =
        readSimpleField(
            "rawId",
            readSignedInt(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
    int identifier =
        readVirtualField(
            "identifier",
            int.class,
            org.apache.plc4x.java.socketcan.readwrite.utils.StaticHelper.readIdentifier(rawId),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
    boolean extended =
        readVirtualField(
            "extended",
            boolean.class,
            org.apache.plc4x.java.socketcan.readwrite.utils.StaticHelper.isExtended(rawId),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
    boolean remote =
        readVirtualField(
            "remote",
            boolean.class,
            org.apache.plc4x.java.socketcan.readwrite.utils.StaticHelper.isRemote(rawId),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));
    boolean error =
        readVirtualField(
            "error",
            boolean.class,
            org.apache.plc4x.java.socketcan.readwrite.utils.StaticHelper.isError(rawId),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    short size =
        readImplicitField(
            "size",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    Short reservedField0 =
        readReservedField(
            "reserved",
            readUnsignedShort(readBuffer, 8),
            (short) 0x0,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    Short reservedField1 =
        readReservedField(
            "reserved",
            readUnsignedShort(readBuffer, 8),
            (short) 0x0,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    Short reservedField2 =
        readReservedField(
            "reserved",
            readUnsignedShort(readBuffer, 8),
            (short) 0x0,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    byte[] data =
        readBuffer.readByteArray(
            "data", Math.toIntExact(size), WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readPaddingField(
        readUnsignedShort(readBuffer, 8),
        (int) ((8) - ((COUNT(data)))),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("SocketCANFrame");
    // Create the instance
    SocketCANFrame _socketCANFrame;
    _socketCANFrame = new SocketCANFrame(rawId, data);
    return _socketCANFrame;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SocketCANFrame)) {
      return false;
    }
    SocketCANFrame that = (SocketCANFrame) o;
    return (getRawId() == that.getRawId()) && (getData() == that.getData()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getRawId(), getData());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
