/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class PnIoCm_Packet implements Message {

  // Abstract accessors for discriminator values.
  public abstract DceRpc_PacketType getPacketType();

  public PnIoCm_Packet() {
    super();
  }

  protected abstract void serializePnIoCm_PacketChild(WriteBuffer writeBuffer)
      throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_Packet");

    // Switch field (Serialize the sub-type)
    serializePnIoCm_PacketChild(writeBuffer);

    writeBuffer.popContext("PnIoCm_Packet");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnIoCm_Packet _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static PnIoCm_Packet staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    DceRpc_PacketType packetType;
    if (args[0] instanceof DceRpc_PacketType) {
      packetType = (DceRpc_PacketType) args[0];
    } else if (args[0] instanceof String) {
      packetType = DceRpc_PacketType.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type DceRpc_PacketType or a string which is parseable but"
              + " was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, packetType);
  }

  public static PnIoCm_Packet staticParse(ReadBuffer readBuffer, DceRpc_PacketType packetType)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_Packet");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    PnIoCm_PacketBuilder builder = null;
    if (EvaluationHelper.equals(packetType, DceRpc_PacketType.REQUEST)) {
      builder = PnIoCm_Packet_Req.staticParsePnIoCm_PacketBuilder(readBuffer, packetType);
    } else if (EvaluationHelper.equals(packetType, DceRpc_PacketType.PING)) {
      builder = PnIoCm_Packet_Ping.staticParsePnIoCm_PacketBuilder(readBuffer, packetType);
    } else if (EvaluationHelper.equals(packetType, DceRpc_PacketType.RESPONSE)) {
      builder = PnIoCm_Packet_Res.staticParsePnIoCm_PacketBuilder(readBuffer, packetType);
    } else if (EvaluationHelper.equals(packetType, DceRpc_PacketType.FAULT)) {
      builder = PnIoCm_Packet_Fault.staticParsePnIoCm_PacketBuilder(readBuffer, packetType);
    } else if (EvaluationHelper.equals(packetType, DceRpc_PacketType.NO_CALL)) {
      builder = PnIoCm_Packet_NoCall.staticParsePnIoCm_PacketBuilder(readBuffer, packetType);
    } else if (EvaluationHelper.equals(packetType, DceRpc_PacketType.REJECT)) {
      builder = PnIoCm_Packet_Rej.staticParsePnIoCm_PacketBuilder(readBuffer, packetType);
    } else if (EvaluationHelper.equals(packetType, DceRpc_PacketType.WORKING)) {
      builder = PnIoCm_Packet_Working.staticParsePnIoCm_PacketBuilder(readBuffer, packetType);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "packetType="
              + packetType
              + "]");
    }

    readBuffer.closeContext("PnIoCm_Packet");
    // Create the instance
    PnIoCm_Packet _pnIoCm_Packet = builder.build();
    return _pnIoCm_Packet;
  }

  public interface PnIoCm_PacketBuilder {
    PnIoCm_Packet build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_Packet)) {
      return false;
    }
    PnIoCm_Packet that = (PnIoCm_Packet) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
