/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.profinet.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class PnIoCm_ModuleDiffBlockApi_Submodule implements Message {

  // Properties.
  protected final int subslotNumber;
  protected final long submoduleIdentNumber;
  protected final boolean codingUsesIdentInfo;
  protected final PnIoCm_IdentInfo identInfo;
  protected final PnIoCm_ArInfo arInfo;
  protected final boolean diagInfoAvailable;
  protected final boolean maintenanceDemanded;
  protected final boolean maintenanceRequired;
  protected final boolean qualifiedInfo;
  protected final PnIoCm_AddInfo addInfo;

  public PnIoCm_ModuleDiffBlockApi_Submodule(
      int subslotNumber,
      long submoduleIdentNumber,
      boolean codingUsesIdentInfo,
      PnIoCm_IdentInfo identInfo,
      PnIoCm_ArInfo arInfo,
      boolean diagInfoAvailable,
      boolean maintenanceDemanded,
      boolean maintenanceRequired,
      boolean qualifiedInfo,
      PnIoCm_AddInfo addInfo) {
    super();
    this.subslotNumber = subslotNumber;
    this.submoduleIdentNumber = submoduleIdentNumber;
    this.codingUsesIdentInfo = codingUsesIdentInfo;
    this.identInfo = identInfo;
    this.arInfo = arInfo;
    this.diagInfoAvailable = diagInfoAvailable;
    this.maintenanceDemanded = maintenanceDemanded;
    this.maintenanceRequired = maintenanceRequired;
    this.qualifiedInfo = qualifiedInfo;
    this.addInfo = addInfo;
  }

  public int getSubslotNumber() {
    return subslotNumber;
  }

  public long getSubmoduleIdentNumber() {
    return submoduleIdentNumber;
  }

  public boolean getCodingUsesIdentInfo() {
    return codingUsesIdentInfo;
  }

  public PnIoCm_IdentInfo getIdentInfo() {
    return identInfo;
  }

  public PnIoCm_ArInfo getArInfo() {
    return arInfo;
  }

  public boolean getDiagInfoAvailable() {
    return diagInfoAvailable;
  }

  public boolean getMaintenanceDemanded() {
    return maintenanceDemanded;
  }

  public boolean getMaintenanceRequired() {
    return maintenanceRequired;
  }

  public boolean getQualifiedInfo() {
    return qualifiedInfo;
  }

  public PnIoCm_AddInfo getAddInfo() {
    return addInfo;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("PnIoCm_ModuleDiffBlockApi_Submodule");

    // Simple Field (subslotNumber)
    writeSimpleField(
        "subslotNumber",
        subslotNumber,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (submoduleIdentNumber)
    writeSimpleField(
        "submoduleIdentNumber",
        submoduleIdentNumber,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (codingUsesIdentInfo)
    writeSimpleField(
        "codingUsesIdentInfo",
        codingUsesIdentInfo,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (identInfo)
    writeSimpleEnumField(
        "identInfo",
        "PnIoCm_IdentInfo",
        identInfo,
        new DataWriterEnumDefault<>(
            PnIoCm_IdentInfo::getValue, PnIoCm_IdentInfo::name, writeUnsignedByte(writeBuffer, 4)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (arInfo)
    writeSimpleEnumField(
        "arInfo",
        "PnIoCm_ArInfo",
        arInfo,
        new DataWriterEnumDefault<>(
            PnIoCm_ArInfo::getValue, PnIoCm_ArInfo::name, writeUnsignedByte(writeBuffer, 4)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (diagInfoAvailable)
    writeSimpleField(
        "diagInfoAvailable",
        diagInfoAvailable,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (maintenanceDemanded)
    writeSimpleField(
        "maintenanceDemanded",
        maintenanceDemanded,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (maintenanceRequired)
    writeSimpleField(
        "maintenanceRequired",
        maintenanceRequired,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (qualifiedInfo)
    writeSimpleField(
        "qualifiedInfo",
        qualifiedInfo,
        writeBoolean(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    // Simple Field (addInfo)
    writeSimpleEnumField(
        "addInfo",
        "PnIoCm_AddInfo",
        addInfo,
        new DataWriterEnumDefault<>(
            PnIoCm_AddInfo::getValue, PnIoCm_AddInfo::name, writeUnsignedByte(writeBuffer, 3)),
        WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    writeBuffer.popContext("PnIoCm_ModuleDiffBlockApi_Submodule");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    PnIoCm_ModuleDiffBlockApi_Submodule _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (subslotNumber)
    lengthInBits += 16;

    // Simple field (submoduleIdentNumber)
    lengthInBits += 32;

    // Simple field (codingUsesIdentInfo)
    lengthInBits += 1;

    // Simple field (identInfo)
    lengthInBits += 4;

    // Simple field (arInfo)
    lengthInBits += 4;

    // Simple field (diagInfoAvailable)
    lengthInBits += 1;

    // Simple field (maintenanceDemanded)
    lengthInBits += 1;

    // Simple field (maintenanceRequired)
    lengthInBits += 1;

    // Simple field (qualifiedInfo)
    lengthInBits += 1;

    // Simple field (addInfo)
    lengthInBits += 3;

    return lengthInBits;
  }

  public static PnIoCm_ModuleDiffBlockApi_Submodule staticParse(
      ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static PnIoCm_ModuleDiffBlockApi_Submodule staticParse(ReadBuffer readBuffer)
      throws ParseException {
    readBuffer.pullContext("PnIoCm_ModuleDiffBlockApi_Submodule");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    int subslotNumber =
        readSimpleField(
            "subslotNumber",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    long submoduleIdentNumber =
        readSimpleField(
            "submoduleIdentNumber",
            readUnsignedLong(readBuffer, 32),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean codingUsesIdentInfo =
        readSimpleField(
            "codingUsesIdentInfo",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    PnIoCm_IdentInfo identInfo =
        readEnumField(
            "identInfo",
            "PnIoCm_IdentInfo",
            new DataReaderEnumDefault<>(
                PnIoCm_IdentInfo::enumForValue, readUnsignedByte(readBuffer, 4)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    PnIoCm_ArInfo arInfo =
        readEnumField(
            "arInfo",
            "PnIoCm_ArInfo",
            new DataReaderEnumDefault<>(
                PnIoCm_ArInfo::enumForValue, readUnsignedByte(readBuffer, 4)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean diagInfoAvailable =
        readSimpleField(
            "diagInfoAvailable",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean maintenanceDemanded =
        readSimpleField(
            "maintenanceDemanded",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean maintenanceRequired =
        readSimpleField(
            "maintenanceRequired",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    boolean qualifiedInfo =
        readSimpleField(
            "qualifiedInfo",
            readBoolean(readBuffer),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    PnIoCm_AddInfo addInfo =
        readEnumField(
            "addInfo",
            "PnIoCm_AddInfo",
            new DataReaderEnumDefault<>(
                PnIoCm_AddInfo::enumForValue, readUnsignedByte(readBuffer, 3)),
            WithOption.WithByteOrder(ByteOrder.BIG_ENDIAN));

    readBuffer.closeContext("PnIoCm_ModuleDiffBlockApi_Submodule");
    // Create the instance
    PnIoCm_ModuleDiffBlockApi_Submodule _pnIoCm_ModuleDiffBlockApi_Submodule;
    _pnIoCm_ModuleDiffBlockApi_Submodule =
        new PnIoCm_ModuleDiffBlockApi_Submodule(
            subslotNumber,
            submoduleIdentNumber,
            codingUsesIdentInfo,
            identInfo,
            arInfo,
            diagInfoAvailable,
            maintenanceDemanded,
            maintenanceRequired,
            qualifiedInfo,
            addInfo);
    return _pnIoCm_ModuleDiffBlockApi_Submodule;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof PnIoCm_ModuleDiffBlockApi_Submodule)) {
      return false;
    }
    PnIoCm_ModuleDiffBlockApi_Submodule that = (PnIoCm_ModuleDiffBlockApi_Submodule) o;
    return (getSubslotNumber() == that.getSubslotNumber())
        && (getSubmoduleIdentNumber() == that.getSubmoduleIdentNumber())
        && (getCodingUsesIdentInfo() == that.getCodingUsesIdentInfo())
        && (getIdentInfo() == that.getIdentInfo())
        && (getArInfo() == that.getArInfo())
        && (getDiagInfoAvailable() == that.getDiagInfoAvailable())
        && (getMaintenanceDemanded() == that.getMaintenanceDemanded())
        && (getMaintenanceRequired() == that.getMaintenanceRequired())
        && (getQualifiedInfo() == that.getQualifiedInfo())
        && (getAddInfo() == that.getAddInfo())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getSubslotNumber(),
        getSubmoduleIdentNumber(),
        getCodingUsesIdentInfo(),
        getIdentInfo(),
        getArInfo(),
        getDiagInfoAvailable(),
        getMaintenanceDemanded(),
        getMaintenanceRequired(),
        getQualifiedInfo(),
        getAddInfo());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
