/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1
    extends OpenProtocolMessageLinkLevelNegativeAcknowledge implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 1;
  }

  // Properties.
  protected final Mid midNumber;
  protected final LinkLevelNegativeAcknowledgeError error;

  public OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      Mid midNumber,
      LinkLevelNegativeAcknowledgeError error) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.midNumber = midNumber;
    this.error = error;
  }

  public Mid getMidNumber() {
    return midNumber;
  }

  public LinkLevelNegativeAcknowledgeError getError() {
    return error;
  }

  @Override
  protected void serializeOpenProtocolMessageLinkLevelNegativeAcknowledgeChild(
      WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1");

    // Simple Field (midNumber)
    writeSimpleEnumField(
        "midNumber",
        "Mid",
        midNumber,
        new DataWriterEnumDefault<>(Mid::getValue, Mid::name, writeUnsignedLong(writeBuffer, 32)),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (error)
    writeSimpleEnumField(
        "error",
        "LinkLevelNegativeAcknowledgeError",
        error,
        new DataWriterEnumDefault<>(
            LinkLevelNegativeAcknowledgeError::getValue,
            LinkLevelNegativeAcknowledgeError::name,
            writeUnsignedLong(writeBuffer, 32)),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (midNumber)
    lengthInBits += 32;

    // Simple field (error)
    lengthInBits += 32;

    return lengthInBits;
  }

  public static OpenProtocolMessageLinkLevelNegativeAcknowledgeBuilder
      staticParseOpenProtocolMessageLinkLevelNegativeAcknowledgeBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Mid midNumber =
        readEnumField(
            "midNumber",
            "Mid",
            new DataReaderEnumDefault<>(Mid::enumForValue, readUnsignedLong(readBuffer, 32)),
            WithOption.WithEncoding("ASCII"));

    LinkLevelNegativeAcknowledgeError error =
        readEnumField(
            "error",
            "LinkLevelNegativeAcknowledgeError",
            new DataReaderEnumDefault<>(
                LinkLevelNegativeAcknowledgeError::enumForValue, readUnsignedLong(readBuffer, 32)),
            WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1");
    // Create the instance
    return new OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1BuilderImpl(midNumber, error);
  }

  public static class OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1BuilderImpl
      implements OpenProtocolMessageLinkLevelNegativeAcknowledge
          .OpenProtocolMessageLinkLevelNegativeAcknowledgeBuilder {
    private final Mid midNumber;
    private final LinkLevelNegativeAcknowledgeError error;

    public OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1BuilderImpl(
        Mid midNumber, LinkLevelNegativeAcknowledgeError error) {
      this.midNumber = midNumber;
      this.error = error;
    }

    public OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1 build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1
          openProtocolMessageLinkLevelNegativeAcknowledgeRev1 =
              new OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  midNumber,
                  error);
      return openProtocolMessageLinkLevelNegativeAcknowledgeRev1;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1)) {
      return false;
    }
    OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1 that =
        (OpenProtocolMessageLinkLevelNegativeAcknowledgeRev1) o;
    return (getMidNumber() == that.getMidNumber())
        && (getError() == that.getError())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getMidNumber(), getError());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
