/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.openprotocol.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class OpenProtocolMessageLastTighteningResultDataRev999Light
    extends OpenProtocolMessageLastTighteningResultData implements Message {

  // Accessors for discriminator values.
  public Integer getRevision() {
    return (int) 999;
  }

  // Properties.
  protected final String vinNumber;
  protected final int jobId;
  protected final int parameterSetId;
  protected final long batchSize;
  protected final long batchCounter;
  protected final BatchStatus batchStatus;
  protected final NokOk tighteningStatus;
  protected final Status torqueStatus;
  protected final Status angleStatus;
  protected final long torque;
  protected final long angle;
  protected final String timeStamp;
  protected final String dateTimeOfLastChangeIndParameterSetSettings;
  protected final String tighteningId;

  public OpenProtocolMessageLastTighteningResultDataRev999Light(
      Integer midRevision,
      Short noAckFlag,
      Integer targetStationId,
      Integer targetSpindleId,
      Integer sequenceNumber,
      Short numberOfMessageParts,
      Short messagePartNumber,
      String vinNumber,
      int jobId,
      int parameterSetId,
      long batchSize,
      long batchCounter,
      BatchStatus batchStatus,
      NokOk tighteningStatus,
      Status torqueStatus,
      Status angleStatus,
      long torque,
      long angle,
      String timeStamp,
      String dateTimeOfLastChangeIndParameterSetSettings,
      String tighteningId) {
    super(
        midRevision,
        noAckFlag,
        targetStationId,
        targetSpindleId,
        sequenceNumber,
        numberOfMessageParts,
        messagePartNumber);
    this.vinNumber = vinNumber;
    this.jobId = jobId;
    this.parameterSetId = parameterSetId;
    this.batchSize = batchSize;
    this.batchCounter = batchCounter;
    this.batchStatus = batchStatus;
    this.tighteningStatus = tighteningStatus;
    this.torqueStatus = torqueStatus;
    this.angleStatus = angleStatus;
    this.torque = torque;
    this.angle = angle;
    this.timeStamp = timeStamp;
    this.dateTimeOfLastChangeIndParameterSetSettings = dateTimeOfLastChangeIndParameterSetSettings;
    this.tighteningId = tighteningId;
  }

  public String getVinNumber() {
    return vinNumber;
  }

  public int getJobId() {
    return jobId;
  }

  public int getParameterSetId() {
    return parameterSetId;
  }

  public long getBatchSize() {
    return batchSize;
  }

  public long getBatchCounter() {
    return batchCounter;
  }

  public BatchStatus getBatchStatus() {
    return batchStatus;
  }

  public NokOk getTighteningStatus() {
    return tighteningStatus;
  }

  public Status getTorqueStatus() {
    return torqueStatus;
  }

  public Status getAngleStatus() {
    return angleStatus;
  }

  public long getTorque() {
    return torque;
  }

  public long getAngle() {
    return angle;
  }

  public String getTimeStamp() {
    return timeStamp;
  }

  public String getDateTimeOfLastChangeIndParameterSetSettings() {
    return dateTimeOfLastChangeIndParameterSetSettings;
  }

  public String getTighteningId() {
    return tighteningId;
  }

  @Override
  protected void serializeOpenProtocolMessageLastTighteningResultDataChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("OpenProtocolMessageLastTighteningResultDataRev999Light");

    // Simple Field (vinNumber)
    writeSimpleField(
        "vinNumber", vinNumber, writeString(writeBuffer, 200), WithOption.WithEncoding("ASCII"));

    // Simple Field (jobId)
    writeSimpleField(
        "jobId", jobId, writeUnsignedInt(writeBuffer, 16), WithOption.WithEncoding("ASCII"));

    // Simple Field (parameterSetId)
    writeSimpleField(
        "parameterSetId",
        parameterSetId,
        writeUnsignedInt(writeBuffer, 24),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchSize)
    writeSimpleField(
        "batchSize",
        batchSize,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchCounter)
    writeSimpleField(
        "batchCounter",
        batchCounter,
        writeUnsignedLong(writeBuffer, 32),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (batchStatus)
    writeSimpleEnumField(
        "batchStatus",
        "BatchStatus",
        batchStatus,
        new DataWriterEnumDefault<>(
            BatchStatus::getValue, BatchStatus::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningStatus)
    writeSimpleEnumField(
        "tighteningStatus",
        "NokOk",
        tighteningStatus,
        new DataWriterEnumDefault<>(
            NokOk::getValue, NokOk::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torqueStatus)
    writeSimpleEnumField(
        "torqueStatus",
        "Status",
        torqueStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (angleStatus)
    writeSimpleEnumField(
        "angleStatus",
        "Status",
        angleStatus,
        new DataWriterEnumDefault<>(
            Status::getValue, Status::name, writeUnsignedShort(writeBuffer, 8)),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (torque)
    writeSimpleField(
        "torque", torque, writeUnsignedLong(writeBuffer, 48), WithOption.WithEncoding("ASCII"));

    // Simple Field (angle)
    writeSimpleField(
        "angle", angle, writeUnsignedLong(writeBuffer, 40), WithOption.WithEncoding("ASCII"));

    // Simple Field (timeStamp)
    writeSimpleField(
        "timeStamp", timeStamp, writeString(writeBuffer, 152), WithOption.WithEncoding("ASCII"));

    // Simple Field (dateTimeOfLastChangeIndParameterSetSettings)
    writeSimpleField(
        "dateTimeOfLastChangeIndParameterSetSettings",
        dateTimeOfLastChangeIndParameterSetSettings,
        writeString(writeBuffer, 152),
        WithOption.WithEncoding("ASCII"));

    // Simple Field (tighteningId)
    writeSimpleField(
        "tighteningId",
        tighteningId,
        writeString(writeBuffer, 80),
        WithOption.WithEncoding("ASCII"));

    writeBuffer.popContext("OpenProtocolMessageLastTighteningResultDataRev999Light");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    OpenProtocolMessageLastTighteningResultDataRev999Light _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (vinNumber)
    lengthInBits += 200;

    // Simple field (jobId)
    lengthInBits += 16;

    // Simple field (parameterSetId)
    lengthInBits += 24;

    // Simple field (batchSize)
    lengthInBits += 32;

    // Simple field (batchCounter)
    lengthInBits += 32;

    // Simple field (batchStatus)
    lengthInBits += 8;

    // Simple field (tighteningStatus)
    lengthInBits += 8;

    // Simple field (torqueStatus)
    lengthInBits += 8;

    // Simple field (angleStatus)
    lengthInBits += 8;

    // Simple field (torque)
    lengthInBits += 48;

    // Simple field (angle)
    lengthInBits += 40;

    // Simple field (timeStamp)
    lengthInBits += 152;

    // Simple field (dateTimeOfLastChangeIndParameterSetSettings)
    lengthInBits += 152;

    // Simple field (tighteningId)
    lengthInBits += 80;

    return lengthInBits;
  }

  public static OpenProtocolMessageLastTighteningResultDataBuilder
      staticParseOpenProtocolMessageLastTighteningResultDataBuilder(
          ReadBuffer readBuffer, Integer revision) throws ParseException {
    readBuffer.pullContext("OpenProtocolMessageLastTighteningResultDataRev999Light");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    String vinNumber =
        readSimpleField("vinNumber", readString(readBuffer, 200), WithOption.WithEncoding("ASCII"));

    int jobId =
        readSimpleField("jobId", readUnsignedInt(readBuffer, 16), WithOption.WithEncoding("ASCII"));

    int parameterSetId =
        readSimpleField(
            "parameterSetId", readUnsignedInt(readBuffer, 24), WithOption.WithEncoding("ASCII"));

    long batchSize =
        readSimpleField(
            "batchSize", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    long batchCounter =
        readSimpleField(
            "batchCounter", readUnsignedLong(readBuffer, 32), WithOption.WithEncoding("ASCII"));

    BatchStatus batchStatus =
        readEnumField(
            "batchStatus",
            "BatchStatus",
            new DataReaderEnumDefault<>(
                BatchStatus::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    NokOk tighteningStatus =
        readEnumField(
            "tighteningStatus",
            "NokOk",
            new DataReaderEnumDefault<>(NokOk::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    Status torqueStatus =
        readEnumField(
            "torqueStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    Status angleStatus =
        readEnumField(
            "angleStatus",
            "Status",
            new DataReaderEnumDefault<>(Status::enumForValue, readUnsignedShort(readBuffer, 8)),
            WithOption.WithEncoding("ASCII"));

    long torque =
        readSimpleField(
            "torque", readUnsignedLong(readBuffer, 48), WithOption.WithEncoding("ASCII"));

    long angle =
        readSimpleField(
            "angle", readUnsignedLong(readBuffer, 40), WithOption.WithEncoding("ASCII"));

    String timeStamp =
        readSimpleField("timeStamp", readString(readBuffer, 152), WithOption.WithEncoding("ASCII"));

    String dateTimeOfLastChangeIndParameterSetSettings =
        readSimpleField(
            "dateTimeOfLastChangeIndParameterSetSettings",
            readString(readBuffer, 152),
            WithOption.WithEncoding("ASCII"));

    String tighteningId =
        readSimpleField(
            "tighteningId", readString(readBuffer, 80), WithOption.WithEncoding("ASCII"));

    readBuffer.closeContext("OpenProtocolMessageLastTighteningResultDataRev999Light");
    // Create the instance
    return new OpenProtocolMessageLastTighteningResultDataRev999LightBuilderImpl(
        vinNumber,
        jobId,
        parameterSetId,
        batchSize,
        batchCounter,
        batchStatus,
        tighteningStatus,
        torqueStatus,
        angleStatus,
        torque,
        angle,
        timeStamp,
        dateTimeOfLastChangeIndParameterSetSettings,
        tighteningId);
  }

  public static class OpenProtocolMessageLastTighteningResultDataRev999LightBuilderImpl
      implements OpenProtocolMessageLastTighteningResultData
          .OpenProtocolMessageLastTighteningResultDataBuilder {
    private final String vinNumber;
    private final int jobId;
    private final int parameterSetId;
    private final long batchSize;
    private final long batchCounter;
    private final BatchStatus batchStatus;
    private final NokOk tighteningStatus;
    private final Status torqueStatus;
    private final Status angleStatus;
    private final long torque;
    private final long angle;
    private final String timeStamp;
    private final String dateTimeOfLastChangeIndParameterSetSettings;
    private final String tighteningId;

    public OpenProtocolMessageLastTighteningResultDataRev999LightBuilderImpl(
        String vinNumber,
        int jobId,
        int parameterSetId,
        long batchSize,
        long batchCounter,
        BatchStatus batchStatus,
        NokOk tighteningStatus,
        Status torqueStatus,
        Status angleStatus,
        long torque,
        long angle,
        String timeStamp,
        String dateTimeOfLastChangeIndParameterSetSettings,
        String tighteningId) {
      this.vinNumber = vinNumber;
      this.jobId = jobId;
      this.parameterSetId = parameterSetId;
      this.batchSize = batchSize;
      this.batchCounter = batchCounter;
      this.batchStatus = batchStatus;
      this.tighteningStatus = tighteningStatus;
      this.torqueStatus = torqueStatus;
      this.angleStatus = angleStatus;
      this.torque = torque;
      this.angle = angle;
      this.timeStamp = timeStamp;
      this.dateTimeOfLastChangeIndParameterSetSettings =
          dateTimeOfLastChangeIndParameterSetSettings;
      this.tighteningId = tighteningId;
    }

    public OpenProtocolMessageLastTighteningResultDataRev999Light build(
        Integer midRevision,
        Short noAckFlag,
        Integer targetStationId,
        Integer targetSpindleId,
        Integer sequenceNumber,
        Short numberOfMessageParts,
        Short messagePartNumber) {
      OpenProtocolMessageLastTighteningResultDataRev999Light
          openProtocolMessageLastTighteningResultDataRev999Light =
              new OpenProtocolMessageLastTighteningResultDataRev999Light(
                  midRevision,
                  noAckFlag,
                  targetStationId,
                  targetSpindleId,
                  sequenceNumber,
                  numberOfMessageParts,
                  messagePartNumber,
                  vinNumber,
                  jobId,
                  parameterSetId,
                  batchSize,
                  batchCounter,
                  batchStatus,
                  tighteningStatus,
                  torqueStatus,
                  angleStatus,
                  torque,
                  angle,
                  timeStamp,
                  dateTimeOfLastChangeIndParameterSetSettings,
                  tighteningId);
      return openProtocolMessageLastTighteningResultDataRev999Light;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof OpenProtocolMessageLastTighteningResultDataRev999Light)) {
      return false;
    }
    OpenProtocolMessageLastTighteningResultDataRev999Light that =
        (OpenProtocolMessageLastTighteningResultDataRev999Light) o;
    return (getVinNumber() == that.getVinNumber())
        && (getJobId() == that.getJobId())
        && (getParameterSetId() == that.getParameterSetId())
        && (getBatchSize() == that.getBatchSize())
        && (getBatchCounter() == that.getBatchCounter())
        && (getBatchStatus() == that.getBatchStatus())
        && (getTighteningStatus() == that.getTighteningStatus())
        && (getTorqueStatus() == that.getTorqueStatus())
        && (getAngleStatus() == that.getAngleStatus())
        && (getTorque() == that.getTorque())
        && (getAngle() == that.getAngle())
        && (getTimeStamp() == that.getTimeStamp())
        && (getDateTimeOfLastChangeIndParameterSetSettings()
            == that.getDateTimeOfLastChangeIndParameterSetSettings())
        && (getTighteningId() == that.getTighteningId())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getVinNumber(),
        getJobId(),
        getParameterSetId(),
        getBatchSize(),
        getBatchCounter(),
        getBatchStatus(),
        getTighteningStatus(),
        getTorqueStatus(),
        getAngleStatus(),
        getTorque(),
        getAngle(),
        getTimeStamp(),
        getDateTimeOfLastChangeIndParameterSetSettings(),
        getTighteningId());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
