/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class QueryFirstResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "618";
  }

  // Properties.
  protected final ExtensionObjectDefinition responseHeader;
  protected final int noOfQueryDataSets;
  protected final List<ExtensionObjectDefinition> queryDataSets;
  protected final PascalByteString continuationPoint;
  protected final int noOfParsingResults;
  protected final List<ExtensionObjectDefinition> parsingResults;
  protected final int noOfDiagnosticInfos;
  protected final List<DiagnosticInfo> diagnosticInfos;
  protected final ExtensionObjectDefinition filterResult;

  public QueryFirstResponse(
      ExtensionObjectDefinition responseHeader,
      int noOfQueryDataSets,
      List<ExtensionObjectDefinition> queryDataSets,
      PascalByteString continuationPoint,
      int noOfParsingResults,
      List<ExtensionObjectDefinition> parsingResults,
      int noOfDiagnosticInfos,
      List<DiagnosticInfo> diagnosticInfos,
      ExtensionObjectDefinition filterResult) {
    super();
    this.responseHeader = responseHeader;
    this.noOfQueryDataSets = noOfQueryDataSets;
    this.queryDataSets = queryDataSets;
    this.continuationPoint = continuationPoint;
    this.noOfParsingResults = noOfParsingResults;
    this.parsingResults = parsingResults;
    this.noOfDiagnosticInfos = noOfDiagnosticInfos;
    this.diagnosticInfos = diagnosticInfos;
    this.filterResult = filterResult;
  }

  public ExtensionObjectDefinition getResponseHeader() {
    return responseHeader;
  }

  public int getNoOfQueryDataSets() {
    return noOfQueryDataSets;
  }

  public List<ExtensionObjectDefinition> getQueryDataSets() {
    return queryDataSets;
  }

  public PascalByteString getContinuationPoint() {
    return continuationPoint;
  }

  public int getNoOfParsingResults() {
    return noOfParsingResults;
  }

  public List<ExtensionObjectDefinition> getParsingResults() {
    return parsingResults;
  }

  public int getNoOfDiagnosticInfos() {
    return noOfDiagnosticInfos;
  }

  public List<DiagnosticInfo> getDiagnosticInfos() {
    return diagnosticInfos;
  }

  public ExtensionObjectDefinition getFilterResult() {
    return filterResult;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("QueryFirstResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfQueryDataSets)
    writeSimpleField("noOfQueryDataSets", noOfQueryDataSets, writeSignedInt(writeBuffer, 32));

    // Array Field (queryDataSets)
    writeComplexTypeArrayField("queryDataSets", queryDataSets, writeBuffer);

    // Simple Field (continuationPoint)
    writeSimpleField(
        "continuationPoint", continuationPoint, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfParsingResults)
    writeSimpleField("noOfParsingResults", noOfParsingResults, writeSignedInt(writeBuffer, 32));

    // Array Field (parsingResults)
    writeComplexTypeArrayField("parsingResults", parsingResults, writeBuffer);

    // Simple Field (noOfDiagnosticInfos)
    writeSimpleField("noOfDiagnosticInfos", noOfDiagnosticInfos, writeSignedInt(writeBuffer, 32));

    // Array Field (diagnosticInfos)
    writeComplexTypeArrayField("diagnosticInfos", diagnosticInfos, writeBuffer);

    // Simple Field (filterResult)
    writeSimpleField("filterResult", filterResult, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("QueryFirstResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    QueryFirstResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Simple field (noOfQueryDataSets)
    lengthInBits += 32;

    // Array field
    if (queryDataSets != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : queryDataSets) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= queryDataSets.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (continuationPoint)
    lengthInBits += continuationPoint.getLengthInBits();

    // Simple field (noOfParsingResults)
    lengthInBits += 32;

    // Array field
    if (parsingResults != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : parsingResults) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= parsingResults.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (noOfDiagnosticInfos)
    lengthInBits += 32;

    // Array field
    if (diagnosticInfos != null) {
      int i = 0;
      for (DiagnosticInfo element : diagnosticInfos) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= diagnosticInfos.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (filterResult)
    lengthInBits += filterResult.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("QueryFirstResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObjectDefinition responseHeader =
        readSimpleField(
            "responseHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("394")),
                readBuffer));

    int noOfQueryDataSets = readSimpleField("noOfQueryDataSets", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> queryDataSets =
        readCountArrayField(
            "queryDataSets",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("579")),
                readBuffer),
            noOfQueryDataSets);

    PascalByteString continuationPoint =
        readSimpleField(
            "continuationPoint",
            new DataReaderComplexDefault<>(
                () -> PascalByteString.staticParse(readBuffer), readBuffer));

    int noOfParsingResults = readSimpleField("noOfParsingResults", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> parsingResults =
        readCountArrayField(
            "parsingResults",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("612")),
                readBuffer),
            noOfParsingResults);

    int noOfDiagnosticInfos = readSimpleField("noOfDiagnosticInfos", readSignedInt(readBuffer, 32));

    List<DiagnosticInfo> diagnosticInfos =
        readCountArrayField(
            "diagnosticInfos",
            new DataReaderComplexDefault<>(
                () -> DiagnosticInfo.staticParse(readBuffer), readBuffer),
            noOfDiagnosticInfos);

    ExtensionObjectDefinition filterResult =
        readSimpleField(
            "filterResult",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("609")),
                readBuffer));

    readBuffer.closeContext("QueryFirstResponse");
    // Create the instance
    return new QueryFirstResponseBuilderImpl(
        responseHeader,
        noOfQueryDataSets,
        queryDataSets,
        continuationPoint,
        noOfParsingResults,
        parsingResults,
        noOfDiagnosticInfos,
        diagnosticInfos,
        filterResult);
  }

  public static class QueryFirstResponseBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition responseHeader;
    private final int noOfQueryDataSets;
    private final List<ExtensionObjectDefinition> queryDataSets;
    private final PascalByteString continuationPoint;
    private final int noOfParsingResults;
    private final List<ExtensionObjectDefinition> parsingResults;
    private final int noOfDiagnosticInfos;
    private final List<DiagnosticInfo> diagnosticInfos;
    private final ExtensionObjectDefinition filterResult;

    public QueryFirstResponseBuilderImpl(
        ExtensionObjectDefinition responseHeader,
        int noOfQueryDataSets,
        List<ExtensionObjectDefinition> queryDataSets,
        PascalByteString continuationPoint,
        int noOfParsingResults,
        List<ExtensionObjectDefinition> parsingResults,
        int noOfDiagnosticInfos,
        List<DiagnosticInfo> diagnosticInfos,
        ExtensionObjectDefinition filterResult) {
      this.responseHeader = responseHeader;
      this.noOfQueryDataSets = noOfQueryDataSets;
      this.queryDataSets = queryDataSets;
      this.continuationPoint = continuationPoint;
      this.noOfParsingResults = noOfParsingResults;
      this.parsingResults = parsingResults;
      this.noOfDiagnosticInfos = noOfDiagnosticInfos;
      this.diagnosticInfos = diagnosticInfos;
      this.filterResult = filterResult;
    }

    public QueryFirstResponse build() {
      QueryFirstResponse queryFirstResponse =
          new QueryFirstResponse(
              responseHeader,
              noOfQueryDataSets,
              queryDataSets,
              continuationPoint,
              noOfParsingResults,
              parsingResults,
              noOfDiagnosticInfos,
              diagnosticInfos,
              filterResult);
      return queryFirstResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof QueryFirstResponse)) {
      return false;
    }
    QueryFirstResponse that = (QueryFirstResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getNoOfQueryDataSets() == that.getNoOfQueryDataSets())
        && (getQueryDataSets() == that.getQueryDataSets())
        && (getContinuationPoint() == that.getContinuationPoint())
        && (getNoOfParsingResults() == that.getNoOfParsingResults())
        && (getParsingResults() == that.getParsingResults())
        && (getNoOfDiagnosticInfos() == that.getNoOfDiagnosticInfos())
        && (getDiagnosticInfos() == that.getDiagnosticInfos())
        && (getFilterResult() == that.getFilterResult())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getResponseHeader(),
        getNoOfQueryDataSets(),
        getQueryDataSets(),
        getContinuationPoint(),
        getNoOfParsingResults(),
        getParsingResults(),
        getNoOfDiagnosticInfos(),
        getDiagnosticInfos(),
        getFilterResult());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
