/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesVariableAlarm {
  AlarmConditionType_EventId((int) 5540L),
  AlarmConditionType_EventType((int) 5541L),
  AlarmConditionType_SourceNode((int) 5542L),
  AlarmConditionType_SourceName((int) 5543L),
  AlarmConditionType_Time((int) 5544L),
  AlarmConditionType_ReceiveTime((int) 5545L),
  AlarmConditionType_LocalTime((int) 5546L),
  AlarmConditionType_Message((int) 5547L),
  AlarmConditionType_Severity((int) 5548L),
  AlarmConditionType_Retain((int) 5549L),
  AlarmConditionType_ConditionRefresh_InputArguments((int) 5551L),
  AlarmConditionType_ConditionName((int) 9116L),
  AlarmConditionType_BranchId((int) 9117L),
  AlarmConditionType_EnabledState((int) 9118L),
  AlarmConditionType_EnabledState_Id((int) 9119L),
  AlarmConditionType_EnabledState_Name((int) 9120L),
  AlarmConditionType_EnabledState_Number((int) 9121L),
  AlarmConditionType_EnabledState_EffectiveDisplayName((int) 9122L),
  AlarmConditionType_EnabledState_TransitionTime((int) 9123L),
  AlarmConditionType_EnabledState_EffectiveTransitionTime((int) 9124L),
  AlarmConditionType_EnabledState_TrueState((int) 9125L),
  AlarmConditionType_EnabledState_FalseState((int) 9126L),
  AlarmConditionType_Quality((int) 9127L),
  AlarmConditionType_Quality_SourceTimestamp((int) 9128L),
  AlarmConditionType_LastSeverity((int) 9129L),
  AlarmConditionType_LastSeverity_SourceTimestamp((int) 9130L),
  AlarmConditionType_Comment((int) 9131L),
  AlarmConditionType_Comment_SourceTimestamp((int) 9132L),
  AlarmConditionType_ClientUserId((int) 9133L),
  AlarmConditionType_AddComment_InputArguments((int) 9137L),
  AlarmConditionType_AckedState((int) 9138L),
  AlarmConditionType_AckedState_Id((int) 9139L),
  AlarmConditionType_AckedState_Name((int) 9140L),
  AlarmConditionType_AckedState_Number((int) 9141L),
  AlarmConditionType_AckedState_EffectiveDisplayName((int) 9142L),
  AlarmConditionType_AckedState_TransitionTime((int) 9143L),
  AlarmConditionType_AckedState_EffectiveTransitionTime((int) 9144L),
  AlarmConditionType_AckedState_TrueState((int) 9145L),
  AlarmConditionType_AckedState_FalseState((int) 9146L),
  AlarmConditionType_ConfirmedState((int) 9147L),
  AlarmConditionType_ConfirmedState_Id((int) 9148L),
  AlarmConditionType_ConfirmedState_Name((int) 9149L),
  AlarmConditionType_ConfirmedState_Number((int) 9150L),
  AlarmConditionType_ConfirmedState_EffectiveDisplayName((int) 9151L),
  AlarmConditionType_ConfirmedState_TransitionTime((int) 9152L),
  AlarmConditionType_ConfirmedState_EffectiveTransitionTime((int) 9153L),
  AlarmConditionType_ConfirmedState_TrueState((int) 9154L),
  AlarmConditionType_ConfirmedState_FalseState((int) 9155L),
  AlarmConditionType_Acknowledge_InputArguments((int) 9157L),
  AlarmConditionType_Confirm_InputArguments((int) 9159L),
  AlarmConditionType_ActiveState((int) 9160L),
  AlarmConditionType_ActiveState_Id((int) 9161L),
  AlarmConditionType_ActiveState_Name((int) 9162L),
  AlarmConditionType_ActiveState_Number((int) 9163L),
  AlarmConditionType_ActiveState_EffectiveDisplayName((int) 9164L),
  AlarmConditionType_ActiveState_TransitionTime((int) 9165L),
  AlarmConditionType_ActiveState_EffectiveTransitionTime((int) 9166L),
  AlarmConditionType_ActiveState_TrueState((int) 9167L),
  AlarmConditionType_ActiveState_FalseState((int) 9168L),
  AlarmConditionType_SuppressedState((int) 9169L),
  AlarmConditionType_SuppressedState_Id((int) 9170L),
  AlarmConditionType_SuppressedState_Name((int) 9171L),
  AlarmConditionType_SuppressedState_Number((int) 9172L),
  AlarmConditionType_SuppressedState_EffectiveDisplayName((int) 9173L),
  AlarmConditionType_SuppressedState_TransitionTime((int) 9174L),
  AlarmConditionType_SuppressedState_EffectiveTransitionTime((int) 9175L),
  AlarmConditionType_SuppressedState_TrueState((int) 9176L),
  AlarmConditionType_SuppressedState_FalseState((int) 9177L),
  AlarmConditionType_ShelvingState_CurrentState((int) 9179L),
  AlarmConditionType_ShelvingState_CurrentState_Id((int) 9180L),
  AlarmConditionType_ShelvingState_CurrentState_Name((int) 9181L),
  AlarmConditionType_ShelvingState_CurrentState_Number((int) 9182L),
  AlarmConditionType_ShelvingState_CurrentState_EffectiveDisplayName((int) 9183L),
  AlarmConditionType_ShelvingState_LastTransition((int) 9184L),
  AlarmConditionType_ShelvingState_LastTransition_Id((int) 9185L),
  AlarmConditionType_ShelvingState_LastTransition_Name((int) 9186L),
  AlarmConditionType_ShelvingState_LastTransition_Number((int) 9187L),
  AlarmConditionType_ShelvingState_LastTransition_TransitionTime((int) 9188L),
  AlarmConditionType_ShelvingState_UnshelveTime((int) 9189L),
  AlarmConditionType_ShelvingState_TimedShelve_InputArguments((int) 9214L),
  AlarmConditionType_SuppressedOrShelved((int) 9215L),
  AlarmConditionType_MaxTimeShelved((int) 9216L),
  AlarmConditionType_ConditionClassId((int) 11118L),
  AlarmConditionType_ConditionClassName((int) 11119L),
  AlarmConditionType_InputNode((int) 11120L),
  AlarmConditionType_ShelvingState_LastTransition_EffectiveTransitionTime((int) 11466L),
  AlarmConditionType_ConditionRefresh2_InputArguments((int) 12985L),
  AlarmConditionType_ConditionSubClassId((int) 16369L),
  AlarmConditionType_ConditionSubClassName((int) 16370L),
  AlarmConditionType_OutOfServiceState((int) 16371L),
  AlarmConditionType_OutOfServiceState_Id((int) 16372L),
  AlarmConditionType_OutOfServiceState_Name((int) 16373L),
  AlarmConditionType_OutOfServiceState_Number((int) 16374L),
  AlarmConditionType_OutOfServiceState_EffectiveDisplayName((int) 16375L),
  AlarmConditionType_OutOfServiceState_TransitionTime((int) 16376L),
  AlarmConditionType_OutOfServiceState_EffectiveTransitionTime((int) 16377L),
  AlarmConditionType_OutOfServiceState_TrueState((int) 16378L),
  AlarmConditionType_OutOfServiceState_FalseState((int) 16379L),
  AlarmConditionType_SilenceState((int) 16380L),
  AlarmConditionType_SilenceState_Id((int) 16381L),
  AlarmConditionType_SilenceState_Name((int) 16382L),
  AlarmConditionType_SilenceState_Number((int) 16383L),
  AlarmConditionType_SilenceState_EffectiveDisplayName((int) 16384L),
  AlarmConditionType_SilenceState_TransitionTime((int) 16385L),
  AlarmConditionType_SilenceState_EffectiveTransitionTime((int) 16386L),
  AlarmConditionType_SilenceState_TrueState((int) 16387L),
  AlarmConditionType_SilenceState_FalseState((int) 16388L),
  AlarmConditionType_AudibleEnabled((int) 16389L),
  AlarmConditionType_AudibleSound((int) 16390L),
  AlarmConditionType_OnDelay((int) 16395L),
  AlarmConditionType_OffDelay((int) 16396L),
  AlarmConditionType_FirstInGroupFlag((int) 16397L),
  AlarmConditionType_ReAlarmTime((int) 16400L),
  AlarmConditionType_ReAlarmRepeatCount((int) 16401L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EventId((int) 16407L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EventType((int) 16408L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SourceNode((int) 16409L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SourceName((int) 16410L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Time((int) 16411L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ReceiveTime((int) 16412L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LocalTime((int) 16413L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Message((int) 16414L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Severity((int) 16415L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassId((int) 16416L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionClassName((int) 16417L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionSubClassId((int) 16418L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionSubClassName((int) 16419L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConditionName((int) 16420L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_BranchId((int) 16421L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Retain((int) 16422L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState((int) 16423L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id((int) 16424L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Name((int) 16425L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_Number((int) 16426L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_EffectiveDisplayName((int) 16427L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_TransitionTime((int) 16428L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_EffectiveTransitionTime(
      (int) 16429L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_TrueState((int) 16430L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_EnabledState_FalseState((int) 16431L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Quality((int) 16432L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp((int) 16433L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity((int) 16434L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp((int) 16435L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Comment((int) 16436L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp((int) 16437L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ClientUserId((int) 16438L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments((int) 16442L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState((int) 16443L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Id((int) 16444L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Name((int) 16445L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_Number((int) 16446L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_EffectiveDisplayName((int) 16447L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_TransitionTime((int) 16448L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_EffectiveTransitionTime(
      (int) 16449L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_TrueState((int) 16450L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AckedState_FalseState((int) 16451L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState((int) 16452L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id((int) 16453L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Name((int) 16454L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Number((int) 16455L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_EffectiveDisplayName(
      (int) 16456L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_TransitionTime((int) 16457L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_EffectiveTransitionTime(
      (int) 16458L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_TrueState((int) 16459L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_FalseState((int) 16460L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments((int) 16462L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments((int) 16464L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState((int) 16465L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id((int) 16466L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Name((int) 16467L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_Number((int) 16468L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_EffectiveDisplayName((int) 16469L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_TransitionTime((int) 16470L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_EffectiveTransitionTime(
      (int) 16471L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_TrueState((int) 16472L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ActiveState_FalseState((int) 16473L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_InputNode((int) 16474L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState((int) 16475L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id((int) 16476L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Name((int) 16477L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Number((int) 16478L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_EffectiveDisplayName(
      (int) 16479L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_TransitionTime((int) 16480L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_EffectiveTransitionTime(
      (int) 16481L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_TrueState((int) 16482L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedState_FalseState((int) 16483L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState((int) 16484L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id((int) 16485L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Name((int) 16486L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Number((int) 16487L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_EffectiveDisplayName(
      (int) 16488L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_TransitionTime((int) 16489L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_EffectiveTransitionTime(
      (int) 16490L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_TrueState((int) 16491L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_FalseState((int) 16492L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState((int) 16493L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id((int) 16494L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Name((int) 16495L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_Number((int) 16496L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_EffectiveDisplayName((int) 16497L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_TransitionTime((int) 16498L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_EffectiveTransitionTime(
      (int) 16499L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_TrueState((int) 16500L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SilenceState_FalseState((int) 16501L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState((int) 16503L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id((int) 16504L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Name((int) 16505L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Number((int) 16506L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_EffectiveDisplayName(
      (int) 16507L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition((int) 16508L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id((int) 16509L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Name((int) 16510L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Number(
      (int) 16511L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_TransitionTime(
      (int) 16512L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_EffectiveTransitionTime(
      (int) 16513L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime((int) 16514L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments(
      (int) 16518L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved((int) 16519L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_MaxTimeShelved((int) 16520L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleEnabled((int) 16521L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound((int) 16522L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OnDelay((int) 16527L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_OffDelay((int) 16528L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_FirstInGroupFlag((int) 16529L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ReAlarmTime((int) 16531L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ReAlarmRepeatCount((int) 16532L),
  AlarmRateVariableType_Rate((int) 17278L),
  AlarmMetricsType_AlarmCount((int) 17280L),
  AlarmMetricsType_MaximumActiveState((int) 17281L),
  AlarmMetricsType_MaximumUnAck((int) 17282L),
  AlarmMetricsType_MaximumReAlarmCount((int) 17283L),
  AlarmMetricsType_CurrentAlarmRate((int) 17284L),
  AlarmMetricsType_CurrentAlarmRate_Rate((int) 17285L),
  AlarmMetricsType_MaximumAlarmRate((int) 17286L),
  AlarmMetricsType_MaximumAlarmRate_Rate((int) 17287L),
  AlarmMetricsType_AverageAlarmRate((int) 17288L),
  AlarmMetricsType_AverageAlarmRate_Rate((int) 17289L),
  AlarmConditionType_ShelvingState_AvailableStates((int) 17658L),
  AlarmConditionType_ShelvingState_AvailableTransitions((int) 17659L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_AvailableStates((int) 17660L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_AvailableTransitions(
      (int) 17661L),
  AlarmConditionType_AudibleSound_ListId((int) 17865L),
  AlarmConditionType_AudibleSound_AgencyId((int) 17866L),
  AlarmConditionType_AudibleSound_VersionId((int) 17867L),
  AlarmMetricsType_StartTime((int) 17991L),
  AlarmConditionType_LatchedState((int) 18190L),
  AlarmConditionType_LatchedState_Id((int) 18191L),
  AlarmConditionType_LatchedState_Name((int) 18192L),
  AlarmConditionType_LatchedState_Number((int) 18193L),
  AlarmConditionType_LatchedState_EffectiveDisplayName((int) 18194L),
  AlarmConditionType_LatchedState_TransitionTime((int) 18195L),
  AlarmConditionType_LatchedState_EffectiveTransitionTime((int) 18196L),
  AlarmConditionType_LatchedState_TrueState((int) 18197L),
  AlarmConditionType_LatchedState_FalseState((int) 18198L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound_ListId((int) 18200L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound_AgencyId((int) 18201L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_AudibleSound_VersionId((int) 18202L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState((int) 18203L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id((int) 18204L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Name((int) 18205L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_Number((int) 18206L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_EffectiveDisplayName((int) 18207L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_TransitionTime((int) 18208L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_EffectiveTransitionTime(
      (int) 18209L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_TrueState((int) 18210L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_LatchedState_FalseState((int) 18211L),
  AlarmConditionType_Suppress2_InputArguments((int) 24317L),
  AlarmConditionType_Unsuppress2_InputArguments((int) 24319L),
  AlarmConditionType_RemoveFromService2_InputArguments((int) 24321L),
  AlarmConditionType_PlaceInService2_InputArguments((int) 24323L),
  AlarmConditionType_Reset2_InputArguments((int) 24325L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Suppress2_InputArguments((int) 24329L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Unsuppress2_InputArguments((int) 24331L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2_InputArguments((int) 24333L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_PlaceInService2_InputArguments((int) 24335L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_Reset2_InputArguments((int) 24337L),
  AlarmConditionType_ShelvingState_TimedShelve2_InputArguments((int) 24739L),
  AlarmConditionType_ShelvingState_Unshelve2_InputArguments((int) 24741L),
  AlarmConditionType_ShelvingState_OneShotShelve2_InputArguments((int) 24743L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2_InputArguments(
      (int) 24749L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2_InputArguments(
      (int) 24751L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2_InputArguments(
      (int) 24753L),
  AlarmConditionType_GetGroupMemberships_OutputArguments((int) 25154L),
  AlarmGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships_OutputArguments(
      (int) 25156L),
  AlarmConditionType_SupportsFilteredRetain((int) 32063L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EventId((int) 32066L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EventType((int) 32067L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SourceNode((int) 32068L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SourceName((int) 32069L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Time((int) 32070L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ReceiveTime((int) 32071L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LocalTime((int) 32072L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Message((int) 32073L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Severity((int) 32074L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionClassId((int) 32075L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionClassName((int) 32076L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionSubClassId((int) 32077L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionSubClassName((int) 32078L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConditionName((int) 32079L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_BranchId((int) 32080L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Retain((int) 32081L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState((int) 32082L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_Id((int) 32083L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_Name((int) 32084L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_Number((int) 32085L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_EffectiveDisplayName(
      (int) 32086L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_TransitionTime(
      (int) 32087L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_EffectiveTransitionTime(
      (int) 32088L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_TrueState((int) 32089L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_EnabledState_FalseState(
      (int) 32090L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Quality((int) 32091L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Quality_SourceTimestamp(
      (int) 32092L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LastSeverity((int) 32093L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LastSeverity_SourceTimestamp(
      (int) 32094L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Comment((int) 32095L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Comment_SourceTimestamp(
      (int) 32096L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ClientUserId((int) 32097L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AddComment_InputArguments(
      (int) 32101L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState((int) 32102L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_Id((int) 32103L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_Name((int) 32104L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_Number((int) 32105L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_EffectiveDisplayName(
      (int) 32106L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_TransitionTime(
      (int) 32107L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_EffectiveTransitionTime(
      (int) 32108L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_TrueState((int) 32109L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AckedState_FalseState((int) 32110L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState((int) 32111L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Id((int) 32112L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Name((int) 32113L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_Number((int) 32114L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_EffectiveDisplayName(
      (int) 32115L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_TransitionTime(
      (int) 32116L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_EffectiveTransitionTime(
      (int) 32117L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_TrueState(
      (int) 32118L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ConfirmedState_FalseState(
      (int) 32119L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Acknowledge_InputArguments(
      (int) 32121L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Confirm_InputArguments((int) 32123L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState((int) 32124L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_Id((int) 32125L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_Name((int) 32126L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_Number((int) 32127L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_EffectiveDisplayName(
      (int) 32128L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_TransitionTime(
      (int) 32129L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_EffectiveTransitionTime(
      (int) 32130L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_TrueState((int) 32131L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ActiveState_FalseState((int) 32132L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_InputNode((int) 32133L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState((int) 32134L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Id((int) 32135L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Name((int) 32136L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_Number((int) 32137L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_EffectiveDisplayName(
      (int) 32138L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_TransitionTime(
      (int) 32139L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_EffectiveTransitionTime(
      (int) 32140L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_TrueState(
      (int) 32141L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedState_FalseState(
      (int) 32142L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState((int) 32143L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Id((int) 32144L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Name((int) 32145L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_Number(
      (int) 32146L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_EffectiveDisplayName(
      (int) 32147L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_TransitionTime(
      (int) 32148L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_EffectiveTransitionTime(
      (int) 32149L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_TrueState(
      (int) 32150L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OutOfServiceState_FalseState(
      (int) 32151L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState(
      (int) 32153L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Id(
      (int) 32154L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Name(
      (int) 32155L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_Number(
      (int) 32156L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_CurrentState_EffectiveDisplayName(
      (int) 32157L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition(
      (int) 32158L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Id(
      (int) 32159L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Name(
      (int) 32160L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_Number(
      (int) 32161L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_TransitionTime(
      (int) 32162L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_LastTransition_EffectiveTransitionTime(
      (int) 32163L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_AvailableStates(
      (int) 32164L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_AvailableTransitions(
      (int) 32165L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_UnshelveTime(
      (int) 32166L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve_InputArguments(
      (int) 32168L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_TimedShelve2_InputArguments(
      (int) 32170L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_Unshelve2_InputArguments(
      (int) 32173L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ShelvingState_OneShotShelve2_InputArguments(
      (int) 32176L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SuppressedOrShelved((int) 32177L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_MaxTimeShelved((int) 32178L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AudibleEnabled((int) 32179L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AudibleSound((int) 32180L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AudibleSound_ListId((int) 32181L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AudibleSound_AgencyId((int) 32182L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_AudibleSound_VersionId((int) 32183L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState((int) 32184L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_Id((int) 32185L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_Name((int) 32186L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_Number((int) 32187L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_EffectiveDisplayName(
      (int) 32188L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_TransitionTime(
      (int) 32189L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_EffectiveTransitionTime(
      (int) 32190L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_TrueState((int) 32191L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_SilenceState_FalseState(
      (int) 32192L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OnDelay((int) 32193L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_OffDelay((int) 32194L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_FirstInGroupFlag((int) 32195L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState((int) 32197L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_Id((int) 32198L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_Name((int) 32199L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_Number((int) 32200L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_EffectiveDisplayName(
      (int) 32201L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_TransitionTime(
      (int) 32202L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_EffectiveTransitionTime(
      (int) 32203L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_TrueState((int) 32204L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_LatchedState_FalseState(
      (int) 32205L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ReAlarmTime((int) 32206L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_ReAlarmRepeatCount((int) 32207L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Suppress2_InputArguments(
      (int) 32211L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Unsuppress2_InputArguments(
      (int) 32214L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_RemoveFromService2_InputArguments(
      (int) 32217L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_PlaceInService2_InputArguments(
      (int) 32220L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_Reset2_InputArguments((int) 32223L),
  AlarmSuppressionGroupType_AlarmConditionInstance_Placeholder_GetGroupMemberships_OutputArguments(
      (int) 32225L),
  AlarmSuppressionGroupType_DigitalVariable_Placeholder((int) 32226L),
  AlarmStateVariableType_HighestActiveSeverity((int) 32245L),
  AlarmStateVariableType_HighestUnackSeverity((int) 32246L),
  AlarmStateVariableType_ActiveCount((int) 32247L),
  AlarmStateVariableType_UnacknowledgedCount((int) 32248L),
  AlarmStateVariableType_UnconfirmedCount((int) 32249L),
  AlarmStateVariableType_Filter((int) 32250L),
  AlarmMask_OptionSetValues((int) 32252L);
  private static final Map<Integer, OpcuaNodeIdServicesVariableAlarm> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesVariableAlarm value : OpcuaNodeIdServicesVariableAlarm.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesVariableAlarm(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesVariableAlarm enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
