/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import java.util.HashMap;
import java.util.Map;

// Code generated by code-generation. DO NOT EDIT.

public enum OpcuaNodeIdServicesDataType {
  Boolean((int) 1L),
  SByte((int) 2L),
  Byte((int) 3L),
  Int16((int) 4L),
  UInt16((int) 5L),
  Int32((int) 6L),
  UInt32((int) 7L),
  Int64((int) 8L),
  UInt64((int) 9L),
  Float((int) 10L),
  Double((int) 11L),
  String((int) 12L),
  DateTime((int) 13L),
  Guid((int) 14L),
  ByteString((int) 15L),
  XmlElement((int) 16L),
  NodeId((int) 17L),
  ExpandedNodeId((int) 18L),
  StatusCode((int) 19L),
  QualifiedName((int) 20L),
  LocalizedText((int) 21L),
  Structure((int) 22L),
  DataValue((int) 23L),
  BaseDataType((int) 24L),
  DiagnosticInfo((int) 25L),
  Number((int) 26L),
  Integer((int) 27L),
  UInteger((int) 28L),
  Enumeration((int) 29L),
  Image((int) 30L),
  Decimal((int) 50L),
  PermissionType((int) 94L),
  AccessRestrictionType((int) 95L),
  RolePermissionType((int) 96L),
  DataTypeDefinition((int) 97L),
  StructureType((int) 98L),
  StructureDefinition((int) 99L),
  EnumDefinition((int) 100L),
  StructureField((int) 101L),
  EnumField((int) 102L),
  NamingRuleType((int) 120L),
  IdType((int) 256L),
  NodeClass((int) 257L),
  Node((int) 258L),
  ObjectNode((int) 261L),
  ObjectTypeNode((int) 264L),
  VariableNode((int) 267L),
  VariableTypeNode((int) 270L),
  ReferenceTypeNode((int) 273L),
  MethodNode((int) 276L),
  ViewNode((int) 279L),
  DataTypeNode((int) 282L),
  ReferenceNode((int) 285L),
  IntegerId((int) 288L),
  Counter((int) 289L),
  Duration((int) 290L),
  NumericRange((int) 291L),
  UtcTime((int) 294L),
  LocaleId((int) 295L),
  Argument((int) 296L),
  StatusResult((int) 299L),
  MessageSecurityMode((int) 302L),
  UserTokenType((int) 303L),
  UserTokenPolicy((int) 304L),
  ApplicationType((int) 307L),
  ApplicationDescription((int) 308L),
  ApplicationInstanceCertificate((int) 311L),
  EndpointDescription((int) 312L),
  SecurityTokenRequestType((int) 315L),
  UserIdentityToken((int) 316L),
  AnonymousIdentityToken((int) 319L),
  UserNameIdentityToken((int) 322L),
  X509IdentityToken((int) 325L),
  EndpointConfiguration((int) 331L),
  BuildInfo((int) 338L),
  SignedSoftwareCertificate((int) 344L),
  AttributeWriteMask((int) 347L),
  NodeAttributesMask((int) 348L),
  NodeAttributes((int) 349L),
  ObjectAttributes((int) 352L),
  VariableAttributes((int) 355L),
  MethodAttributes((int) 358L),
  ObjectTypeAttributes((int) 361L),
  VariableTypeAttributes((int) 364L),
  ReferenceTypeAttributes((int) 367L),
  DataTypeAttributes((int) 370L),
  ViewAttributes((int) 373L),
  AddNodesItem((int) 376L),
  AddReferencesItem((int) 379L),
  DeleteNodesItem((int) 382L),
  DeleteReferencesItem((int) 385L),
  SessionAuthenticationToken((int) 388L),
  RequestHeader((int) 389L),
  ResponseHeader((int) 392L),
  ServiceFault((int) 395L),
  FindServersRequest((int) 420L),
  FindServersResponse((int) 423L),
  GetEndpointsRequest((int) 426L),
  GetEndpointsResponse((int) 429L),
  RegisteredServer((int) 432L),
  RegisterServerRequest((int) 435L),
  RegisterServerResponse((int) 438L),
  ChannelSecurityToken((int) 441L),
  OpenSecureChannelRequest((int) 444L),
  OpenSecureChannelResponse((int) 447L),
  CloseSecureChannelRequest((int) 450L),
  CloseSecureChannelResponse((int) 453L),
  SignatureData((int) 456L),
  CreateSessionRequest((int) 459L),
  CreateSessionResponse((int) 462L),
  ActivateSessionRequest((int) 465L),
  ActivateSessionResponse((int) 468L),
  CloseSessionRequest((int) 471L),
  CloseSessionResponse((int) 474L),
  CancelRequest((int) 477L),
  CancelResponse((int) 480L),
  AddNodesResult((int) 483L),
  AddNodesRequest((int) 486L),
  AddNodesResponse((int) 489L),
  AddReferencesRequest((int) 492L),
  AddReferencesResponse((int) 495L),
  DeleteNodesRequest((int) 498L),
  DeleteNodesResponse((int) 501L),
  DeleteReferencesRequest((int) 504L),
  DeleteReferencesResponse((int) 507L),
  BrowseDirection((int) 510L),
  ViewDescription((int) 511L),
  BrowseDescription((int) 514L),
  BrowseResultMask((int) 517L),
  ReferenceDescription((int) 518L),
  ContinuationPoint((int) 521L),
  BrowseResult((int) 522L),
  BrowseRequest((int) 525L),
  BrowseResponse((int) 528L),
  BrowseNextRequest((int) 531L),
  BrowseNextResponse((int) 534L),
  RelativePathElement((int) 537L),
  RelativePath((int) 540L),
  BrowsePath((int) 543L),
  BrowsePathTarget((int) 546L),
  BrowsePathResult((int) 549L),
  TranslateBrowsePathsToNodeIdsRequest((int) 552L),
  TranslateBrowsePathsToNodeIdsResponse((int) 555L),
  RegisterNodesRequest((int) 558L),
  RegisterNodesResponse((int) 561L),
  UnregisterNodesRequest((int) 564L),
  UnregisterNodesResponse((int) 567L),
  QueryDataDescription((int) 570L),
  NodeTypeDescription((int) 573L),
  FilterOperator((int) 576L),
  QueryDataSet((int) 577L),
  NodeReference((int) 580L),
  ContentFilterElement((int) 583L),
  ContentFilter((int) 586L),
  FilterOperand((int) 589L),
  ElementOperand((int) 592L),
  LiteralOperand((int) 595L),
  AttributeOperand((int) 598L),
  SimpleAttributeOperand((int) 601L),
  ContentFilterElementResult((int) 604L),
  ContentFilterResult((int) 607L),
  ParsingResult((int) 610L),
  QueryFirstRequest((int) 613L),
  QueryFirstResponse((int) 616L),
  QueryNextRequest((int) 619L),
  QueryNextResponse((int) 622L),
  TimestampsToReturn((int) 625L),
  ReadValueId((int) 626L),
  ReadRequest((int) 629L),
  ReadResponse((int) 632L),
  HistoryReadValueId((int) 635L),
  HistoryReadResult((int) 638L),
  HistoryReadDetails((int) 641L),
  ReadEventDetails((int) 644L),
  ReadRawModifiedDetails((int) 647L),
  ReadProcessedDetails((int) 650L),
  ReadAtTimeDetails((int) 653L),
  HistoryData((int) 656L),
  HistoryEvent((int) 659L),
  HistoryReadRequest((int) 662L),
  HistoryReadResponse((int) 665L),
  WriteValue((int) 668L),
  WriteRequest((int) 671L),
  WriteResponse((int) 674L),
  HistoryUpdateDetails((int) 677L),
  UpdateDataDetails((int) 680L),
  UpdateEventDetails((int) 683L),
  DeleteRawModifiedDetails((int) 686L),
  DeleteAtTimeDetails((int) 689L),
  DeleteEventDetails((int) 692L),
  HistoryUpdateResult((int) 695L),
  HistoryUpdateRequest((int) 698L),
  HistoryUpdateResponse((int) 701L),
  CallMethodRequest((int) 704L),
  CallMethodResult((int) 707L),
  CallRequest((int) 710L),
  CallResponse((int) 713L),
  MonitoringMode((int) 716L),
  DataChangeTrigger((int) 717L),
  DeadbandType((int) 718L),
  MonitoringFilter((int) 719L),
  DataChangeFilter((int) 722L),
  EventFilter((int) 725L),
  AggregateFilter((int) 728L),
  MonitoringFilterResult((int) 731L),
  EventFilterResult((int) 734L),
  AggregateFilterResult((int) 737L),
  MonitoringParameters((int) 740L),
  MonitoredItemCreateRequest((int) 743L),
  MonitoredItemCreateResult((int) 746L),
  CreateMonitoredItemsRequest((int) 749L),
  CreateMonitoredItemsResponse((int) 752L),
  MonitoredItemModifyRequest((int) 755L),
  MonitoredItemModifyResult((int) 758L),
  ModifyMonitoredItemsRequest((int) 761L),
  ModifyMonitoredItemsResponse((int) 764L),
  SetMonitoringModeRequest((int) 767L),
  SetMonitoringModeResponse((int) 770L),
  SetTriggeringRequest((int) 773L),
  SetTriggeringResponse((int) 776L),
  DeleteMonitoredItemsRequest((int) 779L),
  DeleteMonitoredItemsResponse((int) 782L),
  CreateSubscriptionRequest((int) 785L),
  CreateSubscriptionResponse((int) 788L),
  ModifySubscriptionRequest((int) 791L),
  ModifySubscriptionResponse((int) 794L),
  SetPublishingModeRequest((int) 797L),
  SetPublishingModeResponse((int) 800L),
  NotificationMessage((int) 803L),
  MonitoredItemNotification((int) 806L),
  DataChangeNotification((int) 809L),
  StatusChangeNotification((int) 818L),
  SubscriptionAcknowledgement((int) 821L),
  PublishRequest((int) 824L),
  PublishResponse((int) 827L),
  RepublishRequest((int) 830L),
  RepublishResponse((int) 833L),
  TransferResult((int) 836L),
  TransferSubscriptionsRequest((int) 839L),
  TransferSubscriptionsResponse((int) 842L),
  DeleteSubscriptionsRequest((int) 845L),
  DeleteSubscriptionsResponse((int) 848L),
  RedundancySupport((int) 851L),
  ServerState((int) 852L),
  RedundantServerDataType((int) 853L),
  SamplingIntervalDiagnosticsDataType((int) 856L),
  ServerDiagnosticsSummaryDataType((int) 859L),
  ServerStatusDataType((int) 862L),
  SessionDiagnosticsDataType((int) 865L),
  SessionSecurityDiagnosticsDataType((int) 868L),
  ServiceCounterDataType((int) 871L),
  SubscriptionDiagnosticsDataType((int) 874L),
  ModelChangeStructureDataType((int) 877L),
  Range((int) 884L),
  EUInformation((int) 887L),
  ExceptionDeviationFormat((int) 890L),
  Annotation((int) 891L),
  ProgramDiagnosticDataType((int) 894L),
  SemanticChangeStructureDataType((int) 897L),
  EventNotificationList((int) 914L),
  EventFieldList((int) 917L),
  HistoryEventFieldList((int) 920L),
  IssuedIdentityToken((int) 938L),
  NotificationData((int) 945L),
  AggregateConfiguration((int) 948L),
  ImageBMP((int) 2000L),
  ImageGIF((int) 2001L),
  ImageJPG((int) 2002L),
  ImagePNG((int) 2003L),
  EnumValueType((int) 7594L),
  TimeZoneDataType((int) 8912L),
  ModificationInfo((int) 11216L),
  HistoryModifiedData((int) 11217L),
  HistoryUpdateType((int) 11234L),
  PerformUpdateType((int) 11293L),
  UpdateStructureDataDetails((int) 11295L),
  BitFieldMaskDataType((int) 11737L),
  InstanceNode((int) 11879L),
  TypeNode((int) 11880L),
  OpenFileMode((int) 11939L),
  ModelChangeStructureVerbMask((int) 11941L),
  EndpointUrlListDataType((int) 11943L),
  NetworkGroupDataType((int) 11944L),
  AxisScaleEnumeration((int) 12077L),
  AxisInformation((int) 12079L),
  XVType((int) 12080L),
  ComplexNumberType((int) 12171L),
  DoubleComplexNumberType((int) 12172L),
  ServerOnNetwork((int) 12189L),
  FindServersOnNetworkRequest((int) 12190L),
  FindServersOnNetworkResponse((int) 12191L),
  RegisterServer2Request((int) 12193L),
  RegisterServer2Response((int) 12194L),
  TrustListMasks((int) 12552L),
  TrustListDataType((int) 12554L),
  OptionSet((int) 12755L),
  Union((int) 12756L),
  NormalizedString((int) 12877L),
  DecimalString((int) 12878L),
  DurationString((int) 12879L),
  TimeString((int) 12880L),
  DateString((int) 12881L),
  DiscoveryConfiguration((int) 12890L),
  MdnsDiscoveryConfiguration((int) 12891L),
  PublishedVariableDataType((int) 14273L),
  DataSetMetaDataType((int) 14523L),
  FieldMetaData((int) 14524L),
  DataTypeDescription((int) 14525L),
  KeyValuePair((int) 14533L),
  ConfigurationVersionDataType((int) 14593L),
  PubSubState((int) 14647L),
  FieldTargetDataType((int) 14744L),
  SimpleTypeDescription((int) 15005L),
  UABinaryFileDataType((int) 15006L),
  BrokerConnectionTransportDataType((int) 15007L),
  BrokerTransportQualityOfService((int) 15008L),
  AccessLevelType((int) 15031L),
  EventNotifierType((int) 15033L),
  AccessLevelExType((int) 15406L),
  WriterGroupDataType((int) 15480L),
  StructureDescription((int) 15487L),
  EnumDescription((int) 15488L),
  NetworkAddressDataType((int) 15502L),
  NetworkAddressUrlDataType((int) 15510L),
  ReaderGroupDataType((int) 15520L),
  EndpointType((int) 15528L),
  PubSubConfigurationDataType((int) 15530L),
  DatagramWriterGroupTransportDataType((int) 15532L),
  DataTypeSchemaHeader((int) 15534L),
  PublishedDataSetDataType((int) 15578L),
  PublishedDataSetSourceDataType((int) 15580L),
  PublishedDataItemsDataType((int) 15581L),
  PublishedEventsDataType((int) 15582L),
  DataSetFieldContentMask((int) 15583L),
  DataSetWriterDataType((int) 15597L),
  DataSetWriterTransportDataType((int) 15598L),
  DataSetWriterMessageDataType((int) 15605L),
  PubSubGroupDataType((int) 15609L),
  WriterGroupTransportDataType((int) 15611L),
  WriterGroupMessageDataType((int) 15616L),
  PubSubConnectionDataType((int) 15617L),
  ConnectionTransportDataType((int) 15618L),
  ReaderGroupTransportDataType((int) 15621L),
  ReaderGroupMessageDataType((int) 15622L),
  DataSetReaderDataType((int) 15623L),
  DataSetReaderTransportDataType((int) 15628L),
  DataSetReaderMessageDataType((int) 15629L),
  SubscribedDataSetDataType((int) 15630L),
  TargetVariablesDataType((int) 15631L),
  IdentityCriteriaType((int) 15632L),
  IdentityMappingRuleType((int) 15634L),
  SubscribedDataSetMirrorDataType((int) 15635L),
  UadpNetworkMessageContentMask((int) 15642L),
  UadpWriterGroupMessageDataType((int) 15645L),
  UadpDataSetMessageContentMask((int) 15646L),
  UadpDataSetWriterMessageDataType((int) 15652L),
  UadpDataSetReaderMessageDataType((int) 15653L),
  JsonNetworkMessageContentMask((int) 15654L),
  JsonWriterGroupMessageDataType((int) 15657L),
  JsonDataSetMessageContentMask((int) 15658L),
  JsonDataSetWriterMessageDataType((int) 15664L),
  JsonDataSetReaderMessageDataType((int) 15665L),
  BrokerWriterGroupTransportDataType((int) 15667L),
  BrokerDataSetWriterTransportDataType((int) 15669L),
  BrokerDataSetReaderTransportDataType((int) 15670L),
  OverrideValueHandling((int) 15874L),
  SessionlessInvokeRequestType((int) 15901L),
  DataSetFieldFlags((int) 15904L),
  AudioDataType((int) 16307L),
  AdditionalParametersType((int) 16313L),
  DatagramConnectionTransportDataType((int) 17467L),
  RsaEncryptedSecret((int) 17545L),
  EccEncryptedSecret((int) 17546L),
  EphemeralKeyType((int) 17548L),
  Index((int) 17588L),
  GenericAttributeValue((int) 17606L),
  GenericAttributes((int) 17607L),
  DecimalDataType((int) 17861L),
  RationalNumber((int) 18806L),
  Vector((int) 18807L),
  ThreeDVector((int) 18808L),
  CartesianCoordinates((int) 18809L),
  ThreeDCartesianCoordinates((int) 18810L),
  Orientation((int) 18811L),
  ThreeDOrientation((int) 18812L),
  Frame((int) 18813L),
  ThreeDFrame((int) 18814L),
  DiagnosticsLevel((int) 19723L),
  PubSubDiagnosticsCounterClassification((int) 19730L),
  DataSetOrderingType((int) 20408L),
  VersionTime((int) 20998L),
  SessionlessInvokeResponseType((int) 20999L),
  AliasNameDataType((int) 23468L),
  ReadAnnotationDataDetails((int) 23497L),
  CurrencyUnitType((int) 23498L),
  TrustListValidationOptions((int) 23564L),
  StandaloneSubscribedDataSetRefDataType((int) 23599L),
  StandaloneSubscribedDataSetDataType((int) 23600L),
  SecurityGroupDataType((int) 23601L),
  PubSubConfiguration2DataType((int) 23602L),
  QosDataType((int) 23603L),
  TransmitQosDataType((int) 23604L),
  TransmitQosPriorityDataType((int) 23605L),
  ReceiveQosDataType((int) 23608L),
  ReceiveQosPriorityDataType((int) 23609L),
  DatagramConnectionTransport2DataType((int) 23612L),
  DatagramWriterGroupTransport2DataType((int) 23613L),
  DatagramDataSetReaderTransportDataType((int) 23614L),
  UriString((int) 23751L),
  ProgramDiagnostic2DataType((int) 24033L),
  PortableQualifiedName((int) 24105L),
  PortableNodeId((int) 24106L),
  UnsignedRationalNumber((int) 24107L),
  Duplex((int) 24210L),
  InterfaceAdminStatus((int) 24212L),
  InterfaceOperStatus((int) 24214L),
  NegotiationStatus((int) 24216L),
  TsnFailureCode((int) 24218L),
  TsnStreamState((int) 24220L),
  TsnTalkerStatus((int) 24222L),
  TsnListenerStatus((int) 24224L),
  SemanticVersionString((int) 24263L),
  PasswordOptionsMask((int) 24277L),
  UserConfigurationMask((int) 24279L),
  UserManagementDataType((int) 24281L),
  PriorityMappingEntryType((int) 25220L),
  PublishedDataSetCustomSourceDataType((int) 25269L),
  PubSubKeyPushTargetDataType((int) 25270L),
  PubSubConfigurationRefMask((int) 25517L),
  PubSubConfigurationRefDataType((int) 25519L),
  PubSubConfigurationValueDataType((int) 25520L),
  EncodedTicket((int) 25726L),
  Handle((int) 31917L),
  TrimmedString((int) 31918L),
  AlarmMask((int) 32251L),
  TransactionErrorType((int) 32285L),
  ReferenceDescriptionDataType((int) 32659L),
  ReferenceListEntryDataType((int) 32660L);
  private static final Map<Integer, OpcuaNodeIdServicesDataType> map;

  static {
    map = new HashMap<>();
    for (OpcuaNodeIdServicesDataType value : OpcuaNodeIdServicesDataType.values()) {
      map.put((int) value.getValue(), value);
    }
  }

  private final int value;

  OpcuaNodeIdServicesDataType(int value) {
    this.value = value;
  }

  public int getValue() {
    return value;
  }

  public static OpcuaNodeIdServicesDataType enumForValue(int value) {
    return map.get(value);
  }

  public static Boolean isDefined(int value) {
    return map.containsKey(value);
  }
}
