/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class GetEndpointsResponse extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "431";
  }

  // Properties.
  protected final ExtensionObjectDefinition responseHeader;
  protected final int noOfEndpoints;
  protected final List<ExtensionObjectDefinition> endpoints;

  public GetEndpointsResponse(
      ExtensionObjectDefinition responseHeader,
      int noOfEndpoints,
      List<ExtensionObjectDefinition> endpoints) {
    super();
    this.responseHeader = responseHeader;
    this.noOfEndpoints = noOfEndpoints;
    this.endpoints = endpoints;
  }

  public ExtensionObjectDefinition getResponseHeader() {
    return responseHeader;
  }

  public int getNoOfEndpoints() {
    return noOfEndpoints;
  }

  public List<ExtensionObjectDefinition> getEndpoints() {
    return endpoints;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("GetEndpointsResponse");

    // Simple Field (responseHeader)
    writeSimpleField("responseHeader", responseHeader, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfEndpoints)
    writeSimpleField("noOfEndpoints", noOfEndpoints, writeSignedInt(writeBuffer, 32));

    // Array Field (endpoints)
    writeComplexTypeArrayField("endpoints", endpoints, writeBuffer);

    writeBuffer.popContext("GetEndpointsResponse");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    GetEndpointsResponse _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (responseHeader)
    lengthInBits += responseHeader.getLengthInBits();

    // Simple field (noOfEndpoints)
    lengthInBits += 32;

    // Array field
    if (endpoints != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : endpoints) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= endpoints.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("GetEndpointsResponse");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExtensionObjectDefinition responseHeader =
        readSimpleField(
            "responseHeader",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("394")),
                readBuffer));

    int noOfEndpoints = readSimpleField("noOfEndpoints", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> endpoints =
        readCountArrayField(
            "endpoints",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("314")),
                readBuffer),
            noOfEndpoints);

    readBuffer.closeContext("GetEndpointsResponse");
    // Create the instance
    return new GetEndpointsResponseBuilderImpl(responseHeader, noOfEndpoints, endpoints);
  }

  public static class GetEndpointsResponseBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExtensionObjectDefinition responseHeader;
    private final int noOfEndpoints;
    private final List<ExtensionObjectDefinition> endpoints;

    public GetEndpointsResponseBuilderImpl(
        ExtensionObjectDefinition responseHeader,
        int noOfEndpoints,
        List<ExtensionObjectDefinition> endpoints) {
      this.responseHeader = responseHeader;
      this.noOfEndpoints = noOfEndpoints;
      this.endpoints = endpoints;
    }

    public GetEndpointsResponse build() {
      GetEndpointsResponse getEndpointsResponse =
          new GetEndpointsResponse(responseHeader, noOfEndpoints, endpoints);
      return getEndpointsResponse;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof GetEndpointsResponse)) {
      return false;
    }
    GetEndpointsResponse that = (GetEndpointsResponse) o;
    return (getResponseHeader() == that.getResponseHeader())
        && (getNoOfEndpoints() == that.getNoOfEndpoints())
        && (getEndpoints() == that.getEndpoints())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getResponseHeader(), getNoOfEndpoints(), getEndpoints());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
