/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class FieldMetaData extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "14526";
  }

  // Properties.
  protected final PascalString name;
  protected final LocalizedText description;
  protected final DataSetFieldFlags fieldFlags;
  protected final short builtInType;
  protected final NodeId dataType;
  protected final int valueRank;
  protected final int noOfArrayDimensions;
  protected final List<Long> arrayDimensions;
  protected final long maxStringLength;
  protected final GuidValue dataSetFieldId;
  protected final int noOfProperties;
  protected final List<ExtensionObjectDefinition> properties;

  public FieldMetaData(
      PascalString name,
      LocalizedText description,
      DataSetFieldFlags fieldFlags,
      short builtInType,
      NodeId dataType,
      int valueRank,
      int noOfArrayDimensions,
      List<Long> arrayDimensions,
      long maxStringLength,
      GuidValue dataSetFieldId,
      int noOfProperties,
      List<ExtensionObjectDefinition> properties) {
    super();
    this.name = name;
    this.description = description;
    this.fieldFlags = fieldFlags;
    this.builtInType = builtInType;
    this.dataType = dataType;
    this.valueRank = valueRank;
    this.noOfArrayDimensions = noOfArrayDimensions;
    this.arrayDimensions = arrayDimensions;
    this.maxStringLength = maxStringLength;
    this.dataSetFieldId = dataSetFieldId;
    this.noOfProperties = noOfProperties;
    this.properties = properties;
  }

  public PascalString getName() {
    return name;
  }

  public LocalizedText getDescription() {
    return description;
  }

  public DataSetFieldFlags getFieldFlags() {
    return fieldFlags;
  }

  public short getBuiltInType() {
    return builtInType;
  }

  public NodeId getDataType() {
    return dataType;
  }

  public int getValueRank() {
    return valueRank;
  }

  public int getNoOfArrayDimensions() {
    return noOfArrayDimensions;
  }

  public List<Long> getArrayDimensions() {
    return arrayDimensions;
  }

  public long getMaxStringLength() {
    return maxStringLength;
  }

  public GuidValue getDataSetFieldId() {
    return dataSetFieldId;
  }

  public int getNoOfProperties() {
    return noOfProperties;
  }

  public List<ExtensionObjectDefinition> getProperties() {
    return properties;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("FieldMetaData");

    // Simple Field (name)
    writeSimpleField("name", name, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (description)
    writeSimpleField("description", description, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (fieldFlags)
    writeSimpleEnumField(
        "fieldFlags",
        "DataSetFieldFlags",
        fieldFlags,
        new DataWriterEnumDefault<>(
            DataSetFieldFlags::getValue,
            DataSetFieldFlags::name,
            writeUnsignedInt(writeBuffer, 16)));

    // Simple Field (builtInType)
    writeSimpleField("builtInType", builtInType, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (dataType)
    writeSimpleField("dataType", dataType, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (valueRank)
    writeSimpleField("valueRank", valueRank, writeSignedInt(writeBuffer, 32));

    // Simple Field (noOfArrayDimensions)
    writeSimpleField("noOfArrayDimensions", noOfArrayDimensions, writeSignedInt(writeBuffer, 32));

    // Array Field (arrayDimensions)
    writeSimpleTypeArrayField(
        "arrayDimensions", arrayDimensions, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (maxStringLength)
    writeSimpleField("maxStringLength", maxStringLength, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (dataSetFieldId)
    writeSimpleField("dataSetFieldId", dataSetFieldId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (noOfProperties)
    writeSimpleField("noOfProperties", noOfProperties, writeSignedInt(writeBuffer, 32));

    // Array Field (properties)
    writeComplexTypeArrayField("properties", properties, writeBuffer);

    writeBuffer.popContext("FieldMetaData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    FieldMetaData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (name)
    lengthInBits += name.getLengthInBits();

    // Simple field (description)
    lengthInBits += description.getLengthInBits();

    // Simple field (fieldFlags)
    lengthInBits += 16;

    // Simple field (builtInType)
    lengthInBits += 8;

    // Simple field (dataType)
    lengthInBits += dataType.getLengthInBits();

    // Simple field (valueRank)
    lengthInBits += 32;

    // Simple field (noOfArrayDimensions)
    lengthInBits += 32;

    // Array field
    if (arrayDimensions != null) {
      lengthInBits += 32 * arrayDimensions.size();
    }

    // Simple field (maxStringLength)
    lengthInBits += 32;

    // Simple field (dataSetFieldId)
    lengthInBits += dataSetFieldId.getLengthInBits();

    // Simple field (noOfProperties)
    lengthInBits += 32;

    // Array field
    if (properties != null) {
      int i = 0;
      for (ExtensionObjectDefinition element : properties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= properties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("FieldMetaData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PascalString name =
        readSimpleField(
            "name",
            new DataReaderComplexDefault<>(() -> PascalString.staticParse(readBuffer), readBuffer));

    LocalizedText description =
        readSimpleField(
            "description",
            new DataReaderComplexDefault<>(
                () -> LocalizedText.staticParse(readBuffer), readBuffer));

    DataSetFieldFlags fieldFlags =
        readEnumField(
            "fieldFlags",
            "DataSetFieldFlags",
            new DataReaderEnumDefault<>(
                DataSetFieldFlags::enumForValue, readUnsignedInt(readBuffer, 16)));

    short builtInType = readSimpleField("builtInType", readUnsignedShort(readBuffer, 8));

    NodeId dataType =
        readSimpleField(
            "dataType",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    int valueRank = readSimpleField("valueRank", readSignedInt(readBuffer, 32));

    int noOfArrayDimensions = readSimpleField("noOfArrayDimensions", readSignedInt(readBuffer, 32));

    List<Long> arrayDimensions =
        readCountArrayField(
            "arrayDimensions", readUnsignedLong(readBuffer, 32), noOfArrayDimensions);

    long maxStringLength = readSimpleField("maxStringLength", readUnsignedLong(readBuffer, 32));

    GuidValue dataSetFieldId =
        readSimpleField(
            "dataSetFieldId",
            new DataReaderComplexDefault<>(() -> GuidValue.staticParse(readBuffer), readBuffer));

    int noOfProperties = readSimpleField("noOfProperties", readSignedInt(readBuffer, 32));

    List<ExtensionObjectDefinition> properties =
        readCountArrayField(
            "properties",
            new DataReaderComplexDefault<>(
                () -> ExtensionObjectDefinition.staticParse(readBuffer, (String) ("14535")),
                readBuffer),
            noOfProperties);

    readBuffer.closeContext("FieldMetaData");
    // Create the instance
    return new FieldMetaDataBuilderImpl(
        name,
        description,
        fieldFlags,
        builtInType,
        dataType,
        valueRank,
        noOfArrayDimensions,
        arrayDimensions,
        maxStringLength,
        dataSetFieldId,
        noOfProperties,
        properties);
  }

  public static class FieldMetaDataBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final PascalString name;
    private final LocalizedText description;
    private final DataSetFieldFlags fieldFlags;
    private final short builtInType;
    private final NodeId dataType;
    private final int valueRank;
    private final int noOfArrayDimensions;
    private final List<Long> arrayDimensions;
    private final long maxStringLength;
    private final GuidValue dataSetFieldId;
    private final int noOfProperties;
    private final List<ExtensionObjectDefinition> properties;

    public FieldMetaDataBuilderImpl(
        PascalString name,
        LocalizedText description,
        DataSetFieldFlags fieldFlags,
        short builtInType,
        NodeId dataType,
        int valueRank,
        int noOfArrayDimensions,
        List<Long> arrayDimensions,
        long maxStringLength,
        GuidValue dataSetFieldId,
        int noOfProperties,
        List<ExtensionObjectDefinition> properties) {
      this.name = name;
      this.description = description;
      this.fieldFlags = fieldFlags;
      this.builtInType = builtInType;
      this.dataType = dataType;
      this.valueRank = valueRank;
      this.noOfArrayDimensions = noOfArrayDimensions;
      this.arrayDimensions = arrayDimensions;
      this.maxStringLength = maxStringLength;
      this.dataSetFieldId = dataSetFieldId;
      this.noOfProperties = noOfProperties;
      this.properties = properties;
    }

    public FieldMetaData build() {
      FieldMetaData fieldMetaData =
          new FieldMetaData(
              name,
              description,
              fieldFlags,
              builtInType,
              dataType,
              valueRank,
              noOfArrayDimensions,
              arrayDimensions,
              maxStringLength,
              dataSetFieldId,
              noOfProperties,
              properties);
      return fieldMetaData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof FieldMetaData)) {
      return false;
    }
    FieldMetaData that = (FieldMetaData) o;
    return (getName() == that.getName())
        && (getDescription() == that.getDescription())
        && (getFieldFlags() == that.getFieldFlags())
        && (getBuiltInType() == that.getBuiltInType())
        && (getDataType() == that.getDataType())
        && (getValueRank() == that.getValueRank())
        && (getNoOfArrayDimensions() == that.getNoOfArrayDimensions())
        && (getArrayDimensions() == that.getArrayDimensions())
        && (getMaxStringLength() == that.getMaxStringLength())
        && (getDataSetFieldId() == that.getDataSetFieldId())
        && (getNoOfProperties() == that.getNoOfProperties())
        && (getProperties() == that.getProperties())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getName(),
        getDescription(),
        getFieldFlags(),
        getBuiltInType(),
        getDataType(),
        getValueRank(),
        getNoOfArrayDimensions(),
        getArrayDimensions(),
        getMaxStringLength(),
        getDataSetFieldId(),
        getNoOfProperties(),
        getProperties());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
