/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class AddNodesItem extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public String getIdentifier() {
    return (String) "378";
  }

  // Properties.
  protected final ExpandedNodeId parentNodeId;
  protected final NodeId referenceTypeId;
  protected final ExpandedNodeId requestedNewNodeId;
  protected final QualifiedName browseName;
  protected final NodeClass nodeClass;
  protected final ExtensionObject nodeAttributes;
  protected final ExpandedNodeId typeDefinition;

  public AddNodesItem(
      ExpandedNodeId parentNodeId,
      NodeId referenceTypeId,
      ExpandedNodeId requestedNewNodeId,
      QualifiedName browseName,
      NodeClass nodeClass,
      ExtensionObject nodeAttributes,
      ExpandedNodeId typeDefinition) {
    super();
    this.parentNodeId = parentNodeId;
    this.referenceTypeId = referenceTypeId;
    this.requestedNewNodeId = requestedNewNodeId;
    this.browseName = browseName;
    this.nodeClass = nodeClass;
    this.nodeAttributes = nodeAttributes;
    this.typeDefinition = typeDefinition;
  }

  public ExpandedNodeId getParentNodeId() {
    return parentNodeId;
  }

  public NodeId getReferenceTypeId() {
    return referenceTypeId;
  }

  public ExpandedNodeId getRequestedNewNodeId() {
    return requestedNewNodeId;
  }

  public QualifiedName getBrowseName() {
    return browseName;
  }

  public NodeClass getNodeClass() {
    return nodeClass;
  }

  public ExtensionObject getNodeAttributes() {
    return nodeAttributes;
  }

  public ExpandedNodeId getTypeDefinition() {
    return typeDefinition;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("AddNodesItem");

    // Simple Field (parentNodeId)
    writeSimpleField("parentNodeId", parentNodeId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (referenceTypeId)
    writeSimpleField(
        "referenceTypeId", referenceTypeId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (requestedNewNodeId)
    writeSimpleField(
        "requestedNewNodeId", requestedNewNodeId, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (browseName)
    writeSimpleField("browseName", browseName, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (nodeClass)
    writeSimpleEnumField(
        "nodeClass",
        "NodeClass",
        nodeClass,
        new DataWriterEnumDefault<>(
            NodeClass::getValue, NodeClass::name, writeUnsignedLong(writeBuffer, 32)));

    // Simple Field (nodeAttributes)
    writeSimpleField("nodeAttributes", nodeAttributes, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (typeDefinition)
    writeSimpleField("typeDefinition", typeDefinition, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("AddNodesItem");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    AddNodesItem _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (parentNodeId)
    lengthInBits += parentNodeId.getLengthInBits();

    // Simple field (referenceTypeId)
    lengthInBits += referenceTypeId.getLengthInBits();

    // Simple field (requestedNewNodeId)
    lengthInBits += requestedNewNodeId.getLengthInBits();

    // Simple field (browseName)
    lengthInBits += browseName.getLengthInBits();

    // Simple field (nodeClass)
    lengthInBits += 32;

    // Simple field (nodeAttributes)
    lengthInBits += nodeAttributes.getLengthInBits();

    // Simple field (typeDefinition)
    lengthInBits += typeDefinition.getLengthInBits();

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, String identifier) throws ParseException {
    readBuffer.pullContext("AddNodesItem");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    ExpandedNodeId parentNodeId =
        readSimpleField(
            "parentNodeId",
            new DataReaderComplexDefault<>(
                () -> ExpandedNodeId.staticParse(readBuffer), readBuffer));

    NodeId referenceTypeId =
        readSimpleField(
            "referenceTypeId",
            new DataReaderComplexDefault<>(() -> NodeId.staticParse(readBuffer), readBuffer));

    ExpandedNodeId requestedNewNodeId =
        readSimpleField(
            "requestedNewNodeId",
            new DataReaderComplexDefault<>(
                () -> ExpandedNodeId.staticParse(readBuffer), readBuffer));

    QualifiedName browseName =
        readSimpleField(
            "browseName",
            new DataReaderComplexDefault<>(
                () -> QualifiedName.staticParse(readBuffer), readBuffer));

    NodeClass nodeClass =
        readEnumField(
            "nodeClass",
            "NodeClass",
            new DataReaderEnumDefault<>(NodeClass::enumForValue, readUnsignedLong(readBuffer, 32)));

    ExtensionObject nodeAttributes =
        readSimpleField(
            "nodeAttributes",
            new DataReaderComplexDefault<>(
                () -> ExtensionObject.staticParse(readBuffer, (boolean) (true)), readBuffer));

    ExpandedNodeId typeDefinition =
        readSimpleField(
            "typeDefinition",
            new DataReaderComplexDefault<>(
                () -> ExpandedNodeId.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("AddNodesItem");
    // Create the instance
    return new AddNodesItemBuilderImpl(
        parentNodeId,
        referenceTypeId,
        requestedNewNodeId,
        browseName,
        nodeClass,
        nodeAttributes,
        typeDefinition);
  }

  public static class AddNodesItemBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final ExpandedNodeId parentNodeId;
    private final NodeId referenceTypeId;
    private final ExpandedNodeId requestedNewNodeId;
    private final QualifiedName browseName;
    private final NodeClass nodeClass;
    private final ExtensionObject nodeAttributes;
    private final ExpandedNodeId typeDefinition;

    public AddNodesItemBuilderImpl(
        ExpandedNodeId parentNodeId,
        NodeId referenceTypeId,
        ExpandedNodeId requestedNewNodeId,
        QualifiedName browseName,
        NodeClass nodeClass,
        ExtensionObject nodeAttributes,
        ExpandedNodeId typeDefinition) {
      this.parentNodeId = parentNodeId;
      this.referenceTypeId = referenceTypeId;
      this.requestedNewNodeId = requestedNewNodeId;
      this.browseName = browseName;
      this.nodeClass = nodeClass;
      this.nodeAttributes = nodeAttributes;
      this.typeDefinition = typeDefinition;
    }

    public AddNodesItem build() {
      AddNodesItem addNodesItem =
          new AddNodesItem(
              parentNodeId,
              referenceTypeId,
              requestedNewNodeId,
              browseName,
              nodeClass,
              nodeAttributes,
              typeDefinition);
      return addNodesItem;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof AddNodesItem)) {
      return false;
    }
    AddNodesItem that = (AddNodesItem) o;
    return (getParentNodeId() == that.getParentNodeId())
        && (getReferenceTypeId() == that.getReferenceTypeId())
        && (getRequestedNewNodeId() == that.getRequestedNewNodeId())
        && (getBrowseName() == that.getBrowseName())
        && (getNodeClass() == that.getNodeClass())
        && (getNodeAttributes() == that.getNodeAttributes())
        && (getTypeDefinition() == that.getTypeDefinition())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getParentNodeId(),
        getReferenceTypeId(),
        getRequestedNewNodeId(),
        getBrowseName(),
        getNodeClass(),
        getNodeAttributes(),
        getTypeDefinition());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
