/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CEMIAdditionalInformationRelativeTimestamp extends CEMIAdditionalInformation
    implements Message {

  // Accessors for discriminator values.
  public Short getAdditionalInformationType() {
    return (short) 0x04;
  }

  // Constant values.
  public static final Short LEN = 2;

  // Properties.
  protected final RelativeTimestamp relativeTimestamp;

  public CEMIAdditionalInformationRelativeTimestamp(RelativeTimestamp relativeTimestamp) {
    super();
    this.relativeTimestamp = relativeTimestamp;
  }

  public RelativeTimestamp getRelativeTimestamp() {
    return relativeTimestamp;
  }

  public short getLen() {
    return LEN;
  }

  @Override
  protected void serializeCEMIAdditionalInformationChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CEMIAdditionalInformationRelativeTimestamp");

    // Const Field (len)
    writeConstField("len", LEN, writeUnsignedShort(writeBuffer, 8));

    // Simple Field (relativeTimestamp)
    writeSimpleField(
        "relativeTimestamp", relativeTimestamp, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("CEMIAdditionalInformationRelativeTimestamp");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CEMIAdditionalInformationRelativeTimestamp _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (len)
    lengthInBits += 8;

    // Simple field (relativeTimestamp)
    lengthInBits += relativeTimestamp.getLengthInBits();

    return lengthInBits;
  }

  public static CEMIAdditionalInformationBuilder staticParseCEMIAdditionalInformationBuilder(
      ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("CEMIAdditionalInformationRelativeTimestamp");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short len =
        readConstField(
            "len",
            readUnsignedShort(readBuffer, 8),
            CEMIAdditionalInformationRelativeTimestamp.LEN);

    RelativeTimestamp relativeTimestamp =
        readSimpleField(
            "relativeTimestamp",
            new DataReaderComplexDefault<>(
                () -> RelativeTimestamp.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("CEMIAdditionalInformationRelativeTimestamp");
    // Create the instance
    return new CEMIAdditionalInformationRelativeTimestampBuilderImpl(relativeTimestamp);
  }

  public static class CEMIAdditionalInformationRelativeTimestampBuilderImpl
      implements CEMIAdditionalInformation.CEMIAdditionalInformationBuilder {
    private final RelativeTimestamp relativeTimestamp;

    public CEMIAdditionalInformationRelativeTimestampBuilderImpl(
        RelativeTimestamp relativeTimestamp) {
      this.relativeTimestamp = relativeTimestamp;
    }

    public CEMIAdditionalInformationRelativeTimestamp build() {
      CEMIAdditionalInformationRelativeTimestamp cEMIAdditionalInformationRelativeTimestamp =
          new CEMIAdditionalInformationRelativeTimestamp(relativeTimestamp);
      return cEMIAdditionalInformationRelativeTimestamp;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CEMIAdditionalInformationRelativeTimestamp)) {
      return false;
    }
    CEMIAdditionalInformationRelativeTimestamp that =
        (CEMIAdditionalInformationRelativeTimestamp) o;
    return (getRelativeTimestamp() == that.getRelativeTimestamp()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getRelativeTimestamp());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
