/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.knxnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class CEMI implements Message {

  // Abstract accessors for discriminator values.
  public abstract Short getMessageCode();

  public CEMI() {
    super();
  }

  protected abstract void serializeCEMIChild(WriteBuffer writeBuffer) throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CEMI");

    // Discriminator Field (messageCode) (Used as input to a switch field)
    writeDiscriminatorField("messageCode", getMessageCode(), writeUnsignedShort(writeBuffer, 8));

    // Switch field (Serialize the sub-type)
    serializeCEMIChild(writeBuffer);

    writeBuffer.popContext("CEMI");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CEMI _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Discriminator Field (messageCode)
    lengthInBits += 8;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static CEMI staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 1)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 1, but got " + args.length);
    }
    Integer size;
    if (args[0] instanceof Integer) {
      size = (Integer) args[0];
    } else if (args[0] instanceof String) {
      size = Integer.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type Integer or a string which is parseable but was "
              + args[0].getClass().getName());
    }
    return staticParse(readBuffer, size);
  }

  public static CEMI staticParse(ReadBuffer readBuffer, Integer size) throws ParseException {
    readBuffer.pullContext("CEMI");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short messageCode = readDiscriminatorField("messageCode", readUnsignedShort(readBuffer, 8));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    CEMIBuilder builder = null;
    if (EvaluationHelper.equals(messageCode, (short) 0x2B)) {
      builder = LBusmonInd.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x11)) {
      builder = LDataReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x29)) {
      builder = LDataInd.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x2E)) {
      builder = LDataCon.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x10)) {
      builder = LRawReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x2D)) {
      builder = LRawInd.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x2F)) {
      builder = LRawCon.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x13)) {
      builder = LPollDataReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x25)) {
      builder = LPollDataCon.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x41)) {
      builder = TDataConnectedReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x89)) {
      builder = TDataConnectedInd.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x4A)) {
      builder = TDataIndividualReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0x94)) {
      builder = TDataIndividualInd.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xFC)) {
      builder = MPropReadReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xFB)) {
      builder = MPropReadCon.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xF6)) {
      builder = MPropWriteReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xF5)) {
      builder = MPropWriteCon.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xF7)) {
      builder = MPropInfoInd.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xF8)) {
      builder = MFuncPropCommandReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xF9)) {
      builder = MFuncPropStateReadReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xFA)) {
      builder = MFuncPropCon.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xF1)) {
      builder = MResetReq.staticParseCEMIBuilder(readBuffer, size);
    } else if (EvaluationHelper.equals(messageCode, (short) 0xF0)) {
      builder = MResetInd.staticParseCEMIBuilder(readBuffer, size);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "messageCode="
              + messageCode
              + "]");
    }

    readBuffer.closeContext("CEMI");
    // Create the instance
    CEMI _cEMI = builder.build();
    return _cEMI;
  }

  public interface CEMIBuilder {
    CEMI build();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CEMI)) {
      return false;
    }
    CEMI that = (CEMI) o;
    return true;
  }

  @Override
  public int hashCode() {
    return Objects.hash();
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
