/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InformationObjectWithoutTime_FILE_READY extends InformationObjectWithoutTime
    implements Message {

  // Accessors for discriminator values.
  public TypeIdentification getTypeIdentification() {
    return TypeIdentification.FILE_READY;
  }

  // Properties.
  protected final NameOfFile nof;
  protected final LengthOfFile lof;
  protected final FileReadyQualifier frq;

  public InformationObjectWithoutTime_FILE_READY(
      int address, NameOfFile nof, LengthOfFile lof, FileReadyQualifier frq) {
    super(address);
    this.nof = nof;
    this.lof = lof;
    this.frq = frq;
  }

  public NameOfFile getNof() {
    return nof;
  }

  public LengthOfFile getLof() {
    return lof;
  }

  public FileReadyQualifier getFrq() {
    return frq;
  }

  @Override
  protected void serializeInformationObjectWithoutTimeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithoutTime_FILE_READY");

    // Simple Field (nof)
    writeSimpleField(
        "nof",
        nof,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (lof)
    writeSimpleField(
        "lof",
        lof,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (frq)
    writeSimpleField(
        "frq",
        frq,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("InformationObjectWithoutTime_FILE_READY");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithoutTime_FILE_READY _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (nof)
    lengthInBits += nof.getLengthInBits();

    // Simple field (lof)
    lengthInBits += lof.getLengthInBits();

    // Simple field (frq)
    lengthInBits += frq.getLengthInBits();

    return lengthInBits;
  }

  public static InformationObjectWithoutTimeBuilder staticParseInformationObjectWithoutTimeBuilder(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObjectWithoutTime_FILE_READY");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    NameOfFile nof =
        readSimpleField(
            "nof",
            new DataReaderComplexDefault<>(() -> NameOfFile.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    LengthOfFile lof =
        readSimpleField(
            "lof",
            new DataReaderComplexDefault<>(() -> LengthOfFile.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    FileReadyQualifier frq =
        readSimpleField(
            "frq",
            new DataReaderComplexDefault<>(
                () -> FileReadyQualifier.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("InformationObjectWithoutTime_FILE_READY");
    // Create the instance
    return new InformationObjectWithoutTime_FILE_READYBuilderImpl(nof, lof, frq);
  }

  public static class InformationObjectWithoutTime_FILE_READYBuilderImpl
      implements InformationObjectWithoutTime.InformationObjectWithoutTimeBuilder {
    private final NameOfFile nof;
    private final LengthOfFile lof;
    private final FileReadyQualifier frq;

    public InformationObjectWithoutTime_FILE_READYBuilderImpl(
        NameOfFile nof, LengthOfFile lof, FileReadyQualifier frq) {
      this.nof = nof;
      this.lof = lof;
      this.frq = frq;
    }

    public InformationObjectWithoutTime_FILE_READY build(int address) {
      InformationObjectWithoutTime_FILE_READY informationObjectWithoutTime_FILE_READY =
          new InformationObjectWithoutTime_FILE_READY(address, nof, lof, frq);
      return informationObjectWithoutTime_FILE_READY;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithoutTime_FILE_READY)) {
      return false;
    }
    InformationObjectWithoutTime_FILE_READY that = (InformationObjectWithoutTime_FILE_READY) o;
    return (getNof() == that.getNof())
        && (getLof() == that.getLof())
        && (getFrq() == that.getFrq())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getNof(), getLof(), getFrq());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
