/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND
    extends InformationObjectWithoutTime implements Message {

  // Accessors for discriminator values.
  public TypeIdentification getTypeIdentification() {
    return TypeIdentification.CLOCK_SYNCHRONISATION_COMMAND;
  }

  // Properties.
  protected final SevenOctetBinaryTime cp56Time2a;

  public InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND(
      int address, SevenOctetBinaryTime cp56Time2a) {
    super(address);
    this.cp56Time2a = cp56Time2a;
  }

  public SevenOctetBinaryTime getCp56Time2a() {
    return cp56Time2a;
  }

  @Override
  protected void serializeInformationObjectWithoutTimeChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND");

    // Simple Field (cp56Time2a)
    writeSimpleField(
        "cp56Time2a",
        cp56Time2a,
        new DataWriterComplexDefault<>(writeBuffer),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    writeBuffer.popContext("InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (cp56Time2a)
    lengthInBits += cp56Time2a.getLengthInBits();

    return lengthInBits;
  }

  public static InformationObjectWithoutTimeBuilder staticParseInformationObjectWithoutTimeBuilder(
      ReadBuffer readBuffer, TypeIdentification typeIdentification, Byte numTimeByte)
      throws ParseException {
    readBuffer.pullContext("InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    SevenOctetBinaryTime cp56Time2a =
        readSimpleField(
            "cp56Time2a",
            new DataReaderComplexDefault<>(
                () -> SevenOctetBinaryTime.staticParse(readBuffer), readBuffer),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    readBuffer.closeContext("InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND");
    // Create the instance
    return new InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMANDBuilderImpl(cp56Time2a);
  }

  public static class InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMANDBuilderImpl
      implements InformationObjectWithoutTime.InformationObjectWithoutTimeBuilder {
    private final SevenOctetBinaryTime cp56Time2a;

    public InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMANDBuilderImpl(
        SevenOctetBinaryTime cp56Time2a) {
      this.cp56Time2a = cp56Time2a;
    }

    public InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND build(int address) {
      InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND
          informationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND =
              new InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND(address, cp56Time2a);
      return informationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND)) {
      return false;
    }
    InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND that =
        (InformationObjectWithoutTime_CLOCK_SYNCHRONISATION_COMMAND) o;
    return (getCp56Time2a() == that.getCp56Time2a()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getCp56Time2a());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
