/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.iec608705104.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class APDU implements Message {

  // Abstract accessors for discriminator values.

  // Constant values.
  public static final Short STARTBYTE = 0x68;

  // Properties.
  protected final int command;

  public APDU(int command) {
    super();
    this.command = command;
  }

  public int getCommand() {
    return command;
  }

  public short getStartByte() {
    return STARTBYTE;
  }

  protected abstract void serializeAPDUChild(WriteBuffer writeBuffer) throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("APDU");

    // Const Field (startByte)
    writeConstField(
        "startByte",
        STARTBYTE,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Implicit Field (apciLength) (Used for parsing, but its value is not stored as it's implicitly
    // given by the objects content)
    short apciLength = (short) ((getLengthInBytes()) - (2));
    writeImplicitField(
        "apciLength",
        apciLength,
        writeUnsignedShort(writeBuffer, 8),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Simple Field (command)
    writeSimpleField(
        "command",
        command,
        writeUnsignedInt(writeBuffer, 16),
        WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Switch field (Serialize the sub-type)
    serializeAPDUChild(writeBuffer);

    writeBuffer.popContext("APDU");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    APDU _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (startByte)
    lengthInBits += 8;

    // Implicit Field (apciLength)
    lengthInBits += 8;

    // Simple field (command)
    lengthInBits += 16;

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static APDU staticParse(ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static APDU staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("APDU");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    short startByte =
        readConstField(
            "startByte",
            readUnsignedShort(readBuffer, 8),
            APDU.STARTBYTE,
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    short apciLength =
        readImplicitField(
            "apciLength",
            readUnsignedShort(readBuffer, 8),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    int command =
        readSimpleField(
            "command",
            readUnsignedInt(readBuffer, 16),
            WithOption.WithByteOrder(ByteOrder.LITTLE_ENDIAN));

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    APDUBuilder builder = null;
    if (EvaluationHelper.equals(command, (int) 0x43)) {
      builder = APDUUFormatTestFrameActivation.staticParseAPDUBuilder(readBuffer);
    } else if (EvaluationHelper.equals(command, (int) 0x83)) {
      builder = APDUUFormatTestFrameConfirmation.staticParseAPDUBuilder(readBuffer);
    } else if (EvaluationHelper.equals(command, (int) 0x13)) {
      builder = APDUUFormatStopDataTransferActivation.staticParseAPDUBuilder(readBuffer);
    } else if (EvaluationHelper.equals(command, (int) 0x23)) {
      builder = APDUUFormatStopDataTransferConfirmation.staticParseAPDUBuilder(readBuffer);
    } else if (EvaluationHelper.equals(command, (int) 0x07)) {
      builder = APDUUFormatStartDataTransferActivation.staticParseAPDUBuilder(readBuffer);
    } else if (EvaluationHelper.equals(command, (int) 0x0B)) {
      builder = APDUUFormatStartDataTransferConfirmation.staticParseAPDUBuilder(readBuffer);
    } else if (EvaluationHelper.equals(command, (int) 0x01)) {
      builder = APDUSFormat.staticParseAPDUBuilder(readBuffer);
    } else if (true) {
      builder = APDUIFormat.staticParseAPDUBuilder(readBuffer);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type" + " parameters [" + "command=" + command + "]");
    }

    readBuffer.closeContext("APDU");
    // Create the instance
    APDU _aPDU = builder.build(command);
    return _aPDU;
  }

  public interface APDUBuilder {
    APDU build(int command);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof APDU)) {
      return false;
    }
    APDU that = (APDU) o;
    return (getCommand() == that.getCommand()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getCommand());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
