/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class SendUnitData extends EipPacket implements Message {

  // Accessors for discriminator values.
  public Integer getCommand() {
    return (int) 0x0070;
  }

  public Boolean getResponse() {
    return false;
  }

  public Integer getPacketLength() {
    return 0;
  }

  // Constant values.
  public static final Long INTERFACEHANDLE = 0x00000000L;

  // Properties.
  protected final int timeout;
  protected final List<TypeId> typeIds;

  public SendUnitData(
      long sessionHandle,
      long status,
      byte[] senderContext,
      long options,
      int timeout,
      List<TypeId> typeIds) {
    super(sessionHandle, status, senderContext, options);
    this.timeout = timeout;
    this.typeIds = typeIds;
  }

  public int getTimeout() {
    return timeout;
  }

  public List<TypeId> getTypeIds() {
    return typeIds;
  }

  public long getInterfaceHandle() {
    return INTERFACEHANDLE;
  }

  @Override
  protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("SendUnitData");

    // Const Field (interfaceHandle)
    writeConstField("interfaceHandle", INTERFACEHANDLE, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (timeout)
    writeSimpleField("timeout", timeout, writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (typeIdCount) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int typeIdCount = (int) (COUNT(getTypeIds()));
    writeImplicitField("typeIdCount", typeIdCount, writeUnsignedInt(writeBuffer, 16));

    // Array Field (typeIds)
    writeComplexTypeArrayField("typeIds", typeIds, writeBuffer);

    writeBuffer.popContext("SendUnitData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    SendUnitData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Const Field (interfaceHandle)
    lengthInBits += 32;

    // Simple field (timeout)
    lengthInBits += 16;

    // Implicit Field (typeIdCount)
    lengthInBits += 16;

    // Array field
    if (typeIds != null) {
      int i = 0;
      for (TypeId element : typeIds) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= typeIds.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static EipPacketBuilder staticParseEipPacketBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("SendUnitData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long interfaceHandle =
        readConstField(
            "interfaceHandle", readUnsignedLong(readBuffer, 32), SendUnitData.INTERFACEHANDLE);

    int timeout = readSimpleField("timeout", readUnsignedInt(readBuffer, 16));

    int typeIdCount = readImplicitField("typeIdCount", readUnsignedInt(readBuffer, 16));

    List<TypeId> typeIds =
        readCountArrayField(
            "typeIds",
            new DataReaderComplexDefault<>(() -> TypeId.staticParse(readBuffer), readBuffer),
            typeIdCount);

    readBuffer.closeContext("SendUnitData");
    // Create the instance
    return new SendUnitDataBuilderImpl(timeout, typeIds);
  }

  public static class SendUnitDataBuilderImpl implements EipPacket.EipPacketBuilder {
    private final int timeout;
    private final List<TypeId> typeIds;

    public SendUnitDataBuilderImpl(int timeout, List<TypeId> typeIds) {
      this.timeout = timeout;
      this.typeIds = typeIds;
    }

    public SendUnitData build(long sessionHandle, long status, byte[] senderContext, long options) {
      SendUnitData sendUnitData =
          new SendUnitData(sessionHandle, status, senderContext, options, timeout, typeIds);
      return sendUnitData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof SendUnitData)) {
      return false;
    }
    SendUnitData that = (SendUnitData) o;
    return (getTimeout() == that.getTimeout())
        && (getTypeIds() == that.getTypeIds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTimeout(), getTypeIds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
