/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.eip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CipRRData extends EipPacket implements Message {

  // Accessors for discriminator values.
  public Integer getCommand() {
    return (int) 0x006F;
  }

  public Boolean getResponse() {
    return false;
  }

  public Integer getPacketLength() {
    return 0;
  }

  // Properties.
  protected final long interfaceHandle;
  protected final int timeout;
  protected final List<TypeId> typeIds;

  public CipRRData(
      long sessionHandle,
      long status,
      byte[] senderContext,
      long options,
      long interfaceHandle,
      int timeout,
      List<TypeId> typeIds) {
    super(sessionHandle, status, senderContext, options);
    this.interfaceHandle = interfaceHandle;
    this.timeout = timeout;
    this.typeIds = typeIds;
  }

  public long getInterfaceHandle() {
    return interfaceHandle;
  }

  public int getTimeout() {
    return timeout;
  }

  public List<TypeId> getTypeIds() {
    return typeIds;
  }

  @Override
  protected void serializeEipPacketChild(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CipRRData");

    // Simple Field (interfaceHandle)
    writeSimpleField("interfaceHandle", interfaceHandle, writeUnsignedLong(writeBuffer, 32));

    // Simple Field (timeout)
    writeSimpleField("timeout", timeout, writeUnsignedInt(writeBuffer, 16));

    // Implicit Field (typeIdCount) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int typeIdCount = (int) (COUNT(getTypeIds()));
    writeImplicitField("typeIdCount", typeIdCount, writeUnsignedInt(writeBuffer, 16));

    // Array Field (typeIds)
    writeComplexTypeArrayField("typeIds", typeIds, writeBuffer);

    writeBuffer.popContext("CipRRData");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CipRRData _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (interfaceHandle)
    lengthInBits += 32;

    // Simple field (timeout)
    lengthInBits += 16;

    // Implicit Field (typeIdCount)
    lengthInBits += 16;

    // Array field
    if (typeIds != null) {
      int i = 0;
      for (TypeId element : typeIds) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= typeIds.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static EipPacketBuilder staticParseEipPacketBuilder(
      ReadBuffer readBuffer, Boolean response) throws ParseException {
    readBuffer.pullContext("CipRRData");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long interfaceHandle = readSimpleField("interfaceHandle", readUnsignedLong(readBuffer, 32));

    int timeout = readSimpleField("timeout", readUnsignedInt(readBuffer, 16));

    int typeIdCount = readImplicitField("typeIdCount", readUnsignedInt(readBuffer, 16));

    List<TypeId> typeIds =
        readCountArrayField(
            "typeIds",
            new DataReaderComplexDefault<>(() -> TypeId.staticParse(readBuffer), readBuffer),
            typeIdCount);

    readBuffer.closeContext("CipRRData");
    // Create the instance
    return new CipRRDataBuilderImpl(interfaceHandle, timeout, typeIds);
  }

  public static class CipRRDataBuilderImpl implements EipPacket.EipPacketBuilder {
    private final long interfaceHandle;
    private final int timeout;
    private final List<TypeId> typeIds;

    public CipRRDataBuilderImpl(long interfaceHandle, int timeout, List<TypeId> typeIds) {
      this.interfaceHandle = interfaceHandle;
      this.timeout = timeout;
      this.typeIds = typeIds;
    }

    public CipRRData build(long sessionHandle, long status, byte[] senderContext, long options) {
      CipRRData cipRRData =
          new CipRRData(
              sessionHandle, status, senderContext, options, interfaceHandle, timeout, typeIds);
      return cipRRData;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CipRRData)) {
      return false;
    }
    CipRRData that = (CipRRData) o;
    return (getInterfaceHandle() == that.getInterfaceHandle())
        && (getTimeout() == that.getTimeout())
        && (getTypeIds() == that.getTypeIds())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getInterfaceHandle(), getTimeout(), getTypeIds());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
