/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.canopen.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CANOpenTimeSynchronization extends CANOpenPayload implements Message {

  // Accessors for discriminator values.
  public CANOpenService getService() {
    return CANOpenService.TIME;
  }

  // Properties.
  protected final CANOpenTime timeOfDay;

  public CANOpenTimeSynchronization(CANOpenTime timeOfDay) {
    super();
    this.timeOfDay = timeOfDay;
  }

  public CANOpenTime getTimeOfDay() {
    return timeOfDay;
  }

  @Override
  protected void serializeCANOpenPayloadChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CANOpenTimeSynchronization");

    // Simple Field (timeOfDay)
    writeSimpleField("timeOfDay", timeOfDay, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("CANOpenTimeSynchronization");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    CANOpenTimeSynchronization _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (timeOfDay)
    lengthInBits += timeOfDay.getLengthInBits();

    return lengthInBits;
  }

  public static CANOpenPayloadBuilder staticParseCANOpenPayloadBuilder(
      ReadBuffer readBuffer, CANOpenService service) throws ParseException {
    readBuffer.pullContext("CANOpenTimeSynchronization");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    CANOpenTime timeOfDay =
        readSimpleField(
            "timeOfDay",
            new DataReaderComplexDefault<>(() -> CANOpenTime.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("CANOpenTimeSynchronization");
    // Create the instance
    return new CANOpenTimeSynchronizationBuilderImpl(timeOfDay);
  }

  public static class CANOpenTimeSynchronizationBuilderImpl
      implements CANOpenPayload.CANOpenPayloadBuilder {
    private final CANOpenTime timeOfDay;

    public CANOpenTimeSynchronizationBuilderImpl(CANOpenTime timeOfDay) {
      this.timeOfDay = timeOfDay;
    }

    public CANOpenTimeSynchronization build() {
      CANOpenTimeSynchronization cANOpenTimeSynchronization =
          new CANOpenTimeSynchronization(timeOfDay);
      return cANOpenTimeSynchronization;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CANOpenTimeSynchronization)) {
      return false;
    }
    CANOpenTimeSynchronization that = (CANOpenTimeSynchronization) o;
    return (getTimeOfDay() == that.getTimeOfDay()) && super.equals(that) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getTimeOfDay());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
