/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ReplyOrConfirmationReply extends ReplyOrConfirmation implements Message {

  // Accessors for discriminator values.

  // Properties.
  protected final Reply reply;
  protected final ResponseTermination termination;

  // Arguments.
  protected final CBusOptions cBusOptions;
  protected final RequestContext requestContext;

  public ReplyOrConfirmationReply(
      byte peekedByte,
      Reply reply,
      ResponseTermination termination,
      CBusOptions cBusOptions,
      RequestContext requestContext) {
    super(peekedByte, cBusOptions, requestContext);
    this.reply = reply;
    this.termination = termination;
    this.cBusOptions = cBusOptions;
    this.requestContext = requestContext;
  }

  public Reply getReply() {
    return reply;
  }

  public ResponseTermination getTermination() {
    return termination;
  }

  @Override
  protected void serializeReplyOrConfirmationChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ReplyOrConfirmationReply");

    // Simple Field (reply)
    writeSimpleField("reply", reply, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (termination)
    writeSimpleField("termination", termination, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("ReplyOrConfirmationReply");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ReplyOrConfirmationReply _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (reply)
    lengthInBits += reply.getLengthInBits();

    // Simple field (termination)
    lengthInBits += termination.getLengthInBits();

    return lengthInBits;
  }

  public static ReplyOrConfirmationBuilder staticParseReplyOrConfirmationBuilder(
      ReadBuffer readBuffer, CBusOptions cBusOptions, RequestContext requestContext)
      throws ParseException {
    readBuffer.pullContext("ReplyOrConfirmationReply");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Reply reply =
        readSimpleField(
            "reply",
            new DataReaderComplexDefault<>(
                () ->
                    Reply.staticParse(
                        readBuffer, (CBusOptions) (cBusOptions), (RequestContext) (requestContext)),
                readBuffer));

    ResponseTermination termination =
        readSimpleField(
            "termination",
            new DataReaderComplexDefault<>(
                () -> ResponseTermination.staticParse(readBuffer), readBuffer));

    readBuffer.closeContext("ReplyOrConfirmationReply");
    // Create the instance
    return new ReplyOrConfirmationReplyBuilderImpl(reply, termination, cBusOptions, requestContext);
  }

  public static class ReplyOrConfirmationReplyBuilderImpl
      implements ReplyOrConfirmation.ReplyOrConfirmationBuilder {
    private final Reply reply;
    private final ResponseTermination termination;
    private final CBusOptions cBusOptions;
    private final RequestContext requestContext;

    public ReplyOrConfirmationReplyBuilderImpl(
        Reply reply,
        ResponseTermination termination,
        CBusOptions cBusOptions,
        RequestContext requestContext) {
      this.reply = reply;
      this.termination = termination;
      this.cBusOptions = cBusOptions;
      this.requestContext = requestContext;
    }

    public ReplyOrConfirmationReply build(
        byte peekedByte, CBusOptions cBusOptions, RequestContext requestContext) {
      ReplyOrConfirmationReply replyOrConfirmationReply =
          new ReplyOrConfirmationReply(peekedByte, reply, termination, cBusOptions, requestContext);
      return replyOrConfirmationReply;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ReplyOrConfirmationReply)) {
      return false;
    }
    ReplyOrConfirmationReply that = (ReplyOrConfirmationReply) o;
    return (getReply() == that.getReply())
        && (getTermination() == that.getTermination())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(super.hashCode(), getReply(), getTermination());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
