/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class InterfaceOptions3 implements Message {

  // Properties.
  protected final boolean exstat;
  protected final boolean pun;
  protected final boolean localSal;
  protected final boolean pcn;

  // Reserved Fields
  private Boolean reservedField0;
  private Boolean reservedField1;
  private Boolean reservedField2;
  private Boolean reservedField3;

  public InterfaceOptions3(boolean exstat, boolean pun, boolean localSal, boolean pcn) {
    super();
    this.exstat = exstat;
    this.pun = pun;
    this.localSal = localSal;
    this.pcn = pcn;
  }

  public boolean getExstat() {
    return exstat;
  }

  public boolean getPun() {
    return pun;
  }

  public boolean getLocalSal() {
    return localSal;
  }

  public boolean getPcn() {
    return pcn;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("InterfaceOptions3");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (boolean) false,
        writeBoolean(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField1 != null ? reservedField1 : (boolean) false,
        writeBoolean(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField2 != null ? reservedField2 : (boolean) false,
        writeBoolean(writeBuffer));

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField3 != null ? reservedField3 : (boolean) false,
        writeBoolean(writeBuffer));

    // Simple Field (exstat)
    writeSimpleField("exstat", exstat, writeBoolean(writeBuffer));

    // Simple Field (pun)
    writeSimpleField("pun", pun, writeBoolean(writeBuffer));

    // Simple Field (localSal)
    writeSimpleField("localSal", localSal, writeBoolean(writeBuffer));

    // Simple Field (pcn)
    writeSimpleField("pcn", pcn, writeBoolean(writeBuffer));

    writeBuffer.popContext("InterfaceOptions3");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    InterfaceOptions3 _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (exstat)
    lengthInBits += 1;

    // Simple field (pun)
    lengthInBits += 1;

    // Simple field (localSal)
    lengthInBits += 1;

    // Simple field (pcn)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static InterfaceOptions3 staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static InterfaceOptions3 staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("InterfaceOptions3");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Boolean reservedField0 =
        readReservedField("reserved", readBoolean(readBuffer), (boolean) false);

    Boolean reservedField1 =
        readReservedField("reserved", readBoolean(readBuffer), (boolean) false);

    Boolean reservedField2 =
        readReservedField("reserved", readBoolean(readBuffer), (boolean) false);

    Boolean reservedField3 =
        readReservedField("reserved", readBoolean(readBuffer), (boolean) false);

    boolean exstat = readSimpleField("exstat", readBoolean(readBuffer));

    boolean pun = readSimpleField("pun", readBoolean(readBuffer));

    boolean localSal = readSimpleField("localSal", readBoolean(readBuffer));

    boolean pcn = readSimpleField("pcn", readBoolean(readBuffer));

    readBuffer.closeContext("InterfaceOptions3");
    // Create the instance
    InterfaceOptions3 _interfaceOptions3;
    _interfaceOptions3 = new InterfaceOptions3(exstat, pun, localSal, pcn);
    _interfaceOptions3.reservedField0 = reservedField0;
    _interfaceOptions3.reservedField1 = reservedField1;
    _interfaceOptions3.reservedField2 = reservedField2;
    _interfaceOptions3.reservedField3 = reservedField3;
    return _interfaceOptions3;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof InterfaceOptions3)) {
      return false;
    }
    InterfaceOptions3 that = (InterfaceOptions3) o;
    return (getExstat() == that.getExstat())
        && (getPun() == that.getPun())
        && (getLocalSal() == that.getLocalSal())
        && (getPcn() == that.getPcn())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getExstat(), getPun(), getLocalSal(), getPcn());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
