/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class HVACAuxiliaryLevel implements Message {

  // Properties.
  protected final boolean fanMode;
  protected final byte mode;

  // Reserved Fields
  private Boolean reservedField0;

  public HVACAuxiliaryLevel(boolean fanMode, byte mode) {
    super();
    this.fanMode = fanMode;
    this.mode = mode;
  }

  public boolean getFanMode() {
    return fanMode;
  }

  public byte getMode() {
    return mode;
  }

  public boolean getIsFanModeAutomatic() {
    return (boolean) (!(getFanMode()));
  }

  public boolean getIsFanModeContinuous() {
    return (boolean) (getFanMode());
  }

  public boolean getIsFanSpeedAtDefaultSpeed() {
    return (boolean) ((getMode()) == (0x00));
  }

  public byte getSpeedSettings() {
    return (byte) (getMode());
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("HVACAuxiliaryLevel");

    // Reserved Field (reserved)
    writeReservedField(
        "reserved",
        reservedField0 != null ? reservedField0 : (boolean) false,
        writeBoolean(writeBuffer));

    // Simple Field (fanMode)
    writeSimpleField("fanMode", fanMode, writeBoolean(writeBuffer));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isFanModeAutomatic = getIsFanModeAutomatic();
    writeBuffer.writeVirtual("isFanModeAutomatic", isFanModeAutomatic);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isFanModeContinuous = getIsFanModeContinuous();
    writeBuffer.writeVirtual("isFanModeContinuous", isFanModeContinuous);

    // Simple Field (mode)
    writeSimpleField("mode", mode, writeUnsignedByte(writeBuffer, 6));

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    boolean isFanSpeedAtDefaultSpeed = getIsFanSpeedAtDefaultSpeed();
    writeBuffer.writeVirtual("isFanSpeedAtDefaultSpeed", isFanSpeedAtDefaultSpeed);

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    byte speedSettings = getSpeedSettings();
    writeBuffer.writeVirtual("speedSettings", speedSettings);

    writeBuffer.popContext("HVACAuxiliaryLevel");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    HVACAuxiliaryLevel _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Reserved Field (reserved)
    lengthInBits += 1;

    // Simple field (fanMode)
    lengthInBits += 1;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    // Simple field (mode)
    lengthInBits += 6;

    // A virtual field doesn't have any in- or output.

    // A virtual field doesn't have any in- or output.

    return lengthInBits;
  }

  public static HVACAuxiliaryLevel staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static HVACAuxiliaryLevel staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("HVACAuxiliaryLevel");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    Boolean reservedField0 =
        readReservedField("reserved", readBoolean(readBuffer), (boolean) false);

    boolean fanMode = readSimpleField("fanMode", readBoolean(readBuffer));
    boolean isFanModeAutomatic = readVirtualField("isFanModeAutomatic", boolean.class, !(fanMode));
    boolean isFanModeContinuous = readVirtualField("isFanModeContinuous", boolean.class, fanMode);

    byte mode = readSimpleField("mode", readUnsignedByte(readBuffer, 6));
    boolean isFanSpeedAtDefaultSpeed =
        readVirtualField("isFanSpeedAtDefaultSpeed", boolean.class, (mode) == (0x00));
    byte speedSettings = readVirtualField("speedSettings", byte.class, mode);

    readBuffer.closeContext("HVACAuxiliaryLevel");
    // Create the instance
    HVACAuxiliaryLevel _hVACAuxiliaryLevel;
    _hVACAuxiliaryLevel = new HVACAuxiliaryLevel(fanMode, mode);
    _hVACAuxiliaryLevel.reservedField0 = reservedField0;
    return _hVACAuxiliaryLevel;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof HVACAuxiliaryLevel)) {
      return false;
    }
    HVACAuxiliaryLevel that = (HVACAuxiliaryLevel) o;
    return (getFanMode() == that.getFanMode()) && (getMode() == that.getMode()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getFanMode(), getMode());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
