/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CBusOptions implements Message {

  // Properties.
  protected final boolean connect;
  protected final boolean smart;
  protected final boolean idmon;
  protected final boolean exstat;
  protected final boolean monitor;
  protected final boolean monall;
  protected final boolean pun;
  protected final boolean pcn;
  protected final boolean srchk;

  public CBusOptions(
      boolean connect,
      boolean smart,
      boolean idmon,
      boolean exstat,
      boolean monitor,
      boolean monall,
      boolean pun,
      boolean pcn,
      boolean srchk) {
    super();
    this.connect = connect;
    this.smart = smart;
    this.idmon = idmon;
    this.exstat = exstat;
    this.monitor = monitor;
    this.monall = monall;
    this.pun = pun;
    this.pcn = pcn;
    this.srchk = srchk;
  }

  public boolean getConnect() {
    return connect;
  }

  public boolean getSmart() {
    return smart;
  }

  public boolean getIdmon() {
    return idmon;
  }

  public boolean getExstat() {
    return exstat;
  }

  public boolean getMonitor() {
    return monitor;
  }

  public boolean getMonall() {
    return monall;
  }

  public boolean getPun() {
    return pun;
  }

  public boolean getPcn() {
    return pcn;
  }

  public boolean getSrchk() {
    return srchk;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CBusOptions");

    // Simple Field (connect)
    writeSimpleField("connect", connect, writeBoolean(writeBuffer));

    // Simple Field (smart)
    writeSimpleField("smart", smart, writeBoolean(writeBuffer));

    // Simple Field (idmon)
    writeSimpleField("idmon", idmon, writeBoolean(writeBuffer));

    // Simple Field (exstat)
    writeSimpleField("exstat", exstat, writeBoolean(writeBuffer));

    // Simple Field (monitor)
    writeSimpleField("monitor", monitor, writeBoolean(writeBuffer));

    // Simple Field (monall)
    writeSimpleField("monall", monall, writeBoolean(writeBuffer));

    // Simple Field (pun)
    writeSimpleField("pun", pun, writeBoolean(writeBuffer));

    // Simple Field (pcn)
    writeSimpleField("pcn", pcn, writeBoolean(writeBuffer));

    // Simple Field (srchk)
    writeSimpleField("srchk", srchk, writeBoolean(writeBuffer));

    writeBuffer.popContext("CBusOptions");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CBusOptions _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (connect)
    lengthInBits += 1;

    // Simple field (smart)
    lengthInBits += 1;

    // Simple field (idmon)
    lengthInBits += 1;

    // Simple field (exstat)
    lengthInBits += 1;

    // Simple field (monitor)
    lengthInBits += 1;

    // Simple field (monall)
    lengthInBits += 1;

    // Simple field (pun)
    lengthInBits += 1;

    // Simple field (pcn)
    lengthInBits += 1;

    // Simple field (srchk)
    lengthInBits += 1;

    return lengthInBits;
  }

  public static CBusOptions staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static CBusOptions staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("CBusOptions");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    boolean connect = readSimpleField("connect", readBoolean(readBuffer));

    boolean smart = readSimpleField("smart", readBoolean(readBuffer));

    boolean idmon = readSimpleField("idmon", readBoolean(readBuffer));

    boolean exstat = readSimpleField("exstat", readBoolean(readBuffer));

    boolean monitor = readSimpleField("monitor", readBoolean(readBuffer));

    boolean monall = readSimpleField("monall", readBoolean(readBuffer));

    boolean pun = readSimpleField("pun", readBoolean(readBuffer));

    boolean pcn = readSimpleField("pcn", readBoolean(readBuffer));

    boolean srchk = readSimpleField("srchk", readBoolean(readBuffer));

    readBuffer.closeContext("CBusOptions");
    // Create the instance
    CBusOptions _cBusOptions;
    _cBusOptions = new CBusOptions(connect, smart, idmon, exstat, monitor, monall, pun, pcn, srchk);
    return _cBusOptions;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CBusOptions)) {
      return false;
    }
    CBusOptions that = (CBusOptions) o;
    return (getConnect() == that.getConnect())
        && (getSmart() == that.getSmart())
        && (getIdmon() == that.getIdmon())
        && (getExstat() == that.getExstat())
        && (getMonitor() == that.getMonitor())
        && (getMonall() == that.getMonall())
        && (getPun() == that.getPun())
        && (getPcn() == that.getPcn())
        && (getSrchk() == that.getSrchk())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        getConnect(),
        getSmart(),
        getIdmon(),
        getExstat(),
        getMonitor(),
        getMonall(),
        getPun(),
        getPcn(),
        getSrchk());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
