/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.cbus.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class CBusHeader implements Message {

  // Properties.
  protected final PriorityClass priorityClass;
  protected final boolean dp;
  protected final byte rc;
  protected final DestinationAddressType destinationAddressType;

  public CBusHeader(
      PriorityClass priorityClass,
      boolean dp,
      byte rc,
      DestinationAddressType destinationAddressType) {
    super();
    this.priorityClass = priorityClass;
    this.dp = dp;
    this.rc = rc;
    this.destinationAddressType = destinationAddressType;
  }

  public PriorityClass getPriorityClass() {
    return priorityClass;
  }

  public boolean getDp() {
    return dp;
  }

  public byte getRc() {
    return rc;
  }

  public DestinationAddressType getDestinationAddressType() {
    return destinationAddressType;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("CBusHeader");

    // Simple Field (priorityClass)
    writeSimpleEnumField(
        "priorityClass",
        "PriorityClass",
        priorityClass,
        new DataWriterEnumDefault<>(
            PriorityClass::getValue, PriorityClass::name, writeUnsignedByte(writeBuffer, 2)));

    // Simple Field (dp)
    writeSimpleField("dp", dp, writeBoolean(writeBuffer));

    // Simple Field (rc)
    writeSimpleField("rc", rc, writeUnsignedByte(writeBuffer, 2));

    // Simple Field (destinationAddressType)
    writeSimpleEnumField(
        "destinationAddressType",
        "DestinationAddressType",
        destinationAddressType,
        new DataWriterEnumDefault<>(
            DestinationAddressType::getValue,
            DestinationAddressType::name,
            writeUnsignedByte(writeBuffer, 3)));

    writeBuffer.popContext("CBusHeader");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    CBusHeader _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (priorityClass)
    lengthInBits += 2;

    // Simple field (dp)
    lengthInBits += 1;

    // Simple field (rc)
    lengthInBits += 2;

    // Simple field (destinationAddressType)
    lengthInBits += 3;

    return lengthInBits;
  }

  public static CBusHeader staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static CBusHeader staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("CBusHeader");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    PriorityClass priorityClass =
        readEnumField(
            "priorityClass",
            "PriorityClass",
            new DataReaderEnumDefault<>(
                PriorityClass::enumForValue, readUnsignedByte(readBuffer, 2)));

    boolean dp = readSimpleField("dp", readBoolean(readBuffer));

    byte rc = readSimpleField("rc", readUnsignedByte(readBuffer, 2));

    DestinationAddressType destinationAddressType =
        readEnumField(
            "destinationAddressType",
            "DestinationAddressType",
            new DataReaderEnumDefault<>(
                DestinationAddressType::enumForValue, readUnsignedByte(readBuffer, 3)));

    readBuffer.closeContext("CBusHeader");
    // Create the instance
    CBusHeader _cBusHeader;
    _cBusHeader = new CBusHeader(priorityClass, dp, rc, destinationAddressType);
    return _cBusHeader;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof CBusHeader)) {
      return false;
    }
    CBusHeader that = (CBusHeader) o;
    return (getPriorityClass() == that.getPriorityClass())
        && (getDp() == that.getDp())
        && (getRc() == that.getRc())
        && (getDestinationAddressType() == that.getDestinationAddressType())
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getPriorityClass(), getDp(), getRc(), getDestinationAddressType());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
