/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public abstract class BACnetPropertyAccessResultAccessResult implements Message {

  // Abstract accessors for discriminator values.

  // Properties.
  protected final BACnetTagHeader peekedTagHeader;

  // Arguments.
  protected final BACnetObjectType objectTypeArgument;
  protected final BACnetPropertyIdentifier propertyIdentifierArgument;
  protected final BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument;

  public BACnetPropertyAccessResultAccessResult(
      BACnetTagHeader peekedTagHeader,
      BACnetObjectType objectTypeArgument,
      BACnetPropertyIdentifier propertyIdentifierArgument,
      BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument) {
    super();
    this.peekedTagHeader = peekedTagHeader;
    this.objectTypeArgument = objectTypeArgument;
    this.propertyIdentifierArgument = propertyIdentifierArgument;
    this.propertyArrayIndexArgument = propertyArrayIndexArgument;
  }

  public BACnetTagHeader getPeekedTagHeader() {
    return peekedTagHeader;
  }

  public short getPeekedTagNumber() {
    return (short) (getPeekedTagHeader().getActualTagNumber());
  }

  protected abstract void serializeBACnetPropertyAccessResultAccessResultChild(
      WriteBuffer writeBuffer) throws SerializationException;

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetPropertyAccessResultAccessResult");

    // Virtual field (doesn't actually serialize anything, just makes the value available)
    short peekedTagNumber = getPeekedTagNumber();
    writeBuffer.writeVirtual("peekedTagNumber", peekedTagNumber);

    // Switch field (Serialize the sub-type)
    serializeBACnetPropertyAccessResultAccessResultChild(writeBuffer);

    writeBuffer.popContext("BACnetPropertyAccessResultAccessResult");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetPropertyAccessResultAccessResult _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // A virtual field doesn't have any in- or output.

    // Length of sub-type elements will be added by sub-type...

    return lengthInBits;
  }

  public static BACnetPropertyAccessResultAccessResult staticParse(
      ReadBuffer readBuffer, Object... args) throws ParseException {
    PositionAware positionAware = readBuffer;
    if ((args == null) || (args.length != 3)) {
      throw new PlcRuntimeException(
          "Wrong number of arguments, expected 3, but got " + args.length);
    }
    BACnetObjectType objectTypeArgument;
    if (args[0] instanceof BACnetObjectType) {
      objectTypeArgument = (BACnetObjectType) args[0];
    } else if (args[0] instanceof String) {
      objectTypeArgument = BACnetObjectType.valueOf((String) args[0]);
    } else {
      throw new PlcRuntimeException(
          "Argument 0 expected to be of type BACnetObjectType or a string which is parseable but"
              + " was "
              + args[0].getClass().getName());
    }
    BACnetPropertyIdentifier propertyIdentifierArgument;
    if (args[1] instanceof BACnetPropertyIdentifier) {
      propertyIdentifierArgument = (BACnetPropertyIdentifier) args[1];
    } else if (args[1] instanceof String) {
      propertyIdentifierArgument = BACnetPropertyIdentifier.valueOf((String) args[1]);
    } else {
      throw new PlcRuntimeException(
          "Argument 1 expected to be of type BACnetPropertyIdentifier or a string which is"
              + " parseable but was "
              + args[1].getClass().getName());
    }
    BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument;
    if (args[2] instanceof BACnetTagPayloadUnsignedInteger) {
      propertyArrayIndexArgument = (BACnetTagPayloadUnsignedInteger) args[2];
    } else {
      throw new PlcRuntimeException(
          "Argument 2 expected to be of type BACnetTagPayloadUnsignedInteger or a string which is"
              + " parseable but was "
              + args[2].getClass().getName());
    }
    return staticParse(
        readBuffer, objectTypeArgument, propertyIdentifierArgument, propertyArrayIndexArgument);
  }

  public static BACnetPropertyAccessResultAccessResult staticParse(
      ReadBuffer readBuffer,
      BACnetObjectType objectTypeArgument,
      BACnetPropertyIdentifier propertyIdentifierArgument,
      BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument)
      throws ParseException {
    readBuffer.pullContext("BACnetPropertyAccessResultAccessResult");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetTagHeader peekedTagHeader =
        readPeekField(
            "peekedTagHeader",
            new DataReaderComplexDefault<>(
                () -> BACnetTagHeader.staticParse(readBuffer), readBuffer));
    short peekedTagNumber =
        readVirtualField("peekedTagNumber", short.class, peekedTagHeader.getActualTagNumber());

    // Switch Field (Depending on the discriminator values, passes the instantiation to a sub-type)
    BACnetPropertyAccessResultAccessResultBuilder builder = null;
    if (EvaluationHelper.equals(peekedTagNumber, (short) 4)) {
      builder =
          BACnetPropertyAccessResultAccessResultPropertyValue
              .staticParseBACnetPropertyAccessResultAccessResultBuilder(
                  readBuffer,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  propertyArrayIndexArgument);
    } else if (EvaluationHelper.equals(peekedTagNumber, (short) 5)) {
      builder =
          BACnetPropertyAccessResultAccessResultPropertyAccessError
              .staticParseBACnetPropertyAccessResultAccessResultBuilder(
                  readBuffer,
                  objectTypeArgument,
                  propertyIdentifierArgument,
                  propertyArrayIndexArgument);
    }
    if (builder == null) {
      throw new ParseException(
          "Unsupported case for discriminated type"
              + " parameters ["
              + "peekedTagNumber="
              + peekedTagNumber
              + "]");
    }

    readBuffer.closeContext("BACnetPropertyAccessResultAccessResult");
    // Create the instance
    BACnetPropertyAccessResultAccessResult _bACnetPropertyAccessResultAccessResult =
        builder.build(
            peekedTagHeader,
            objectTypeArgument,
            propertyIdentifierArgument,
            propertyArrayIndexArgument);
    return _bACnetPropertyAccessResultAccessResult;
  }

  public interface BACnetPropertyAccessResultAccessResultBuilder {
    BACnetPropertyAccessResultAccessResult build(
        BACnetTagHeader peekedTagHeader,
        BACnetObjectType objectTypeArgument,
        BACnetPropertyIdentifier propertyIdentifierArgument,
        BACnetTagPayloadUnsignedInteger propertyArrayIndexArgument);
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetPropertyAccessResultAccessResult)) {
      return false;
    }
    BACnetPropertyAccessResultAccessResult that = (BACnetPropertyAccessResultAccessResult) o;
    return (getPeekedTagHeader() == that.getPeekedTagHeader()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getPeekedTagHeader());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
