/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetPortPermission implements Message {

  // Properties.
  protected final BACnetContextTagUnsignedInteger port;
  protected final BACnetContextTagBoolean enable;

  public BACnetPortPermission(
      BACnetContextTagUnsignedInteger port, BACnetContextTagBoolean enable) {
    super();
    this.port = port;
    this.enable = enable;
  }

  public BACnetContextTagUnsignedInteger getPort() {
    return port;
  }

  public BACnetContextTagBoolean getEnable() {
    return enable;
  }

  public void serialize(WriteBuffer writeBuffer) throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetPortPermission");

    // Simple Field (port)
    writeSimpleField("port", port, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (enable) (Can be skipped, if the value is null)
    writeOptionalField("enable", enable, new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetPortPermission");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = 0;
    BACnetPortPermission _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (port)
    lengthInBits += port.getLengthInBits();

    // Optional Field (enable)
    if (enable != null) {
      lengthInBits += enable.getLengthInBits();
    }

    return lengthInBits;
  }

  public static BACnetPortPermission staticParse(ReadBuffer readBuffer, Object... args)
      throws ParseException {
    PositionAware positionAware = readBuffer;
    return staticParse(readBuffer);
  }

  public static BACnetPortPermission staticParse(ReadBuffer readBuffer) throws ParseException {
    readBuffer.pullContext("BACnetPortPermission");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger port =
        readSimpleField(
            "port",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagBoolean enable =
        readOptionalField(
            "enable",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (1), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    readBuffer.closeContext("BACnetPortPermission");
    // Create the instance
    BACnetPortPermission _bACnetPortPermission;
    _bACnetPortPermission = new BACnetPortPermission(port, enable);
    return _bACnetPortPermission;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetPortPermission)) {
      return false;
    }
    BACnetPortPermission that = (BACnetPortPermission) o;
    return (getPort() == that.getPort()) && (getEnable() == that.getEnable()) && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(getPort(), getEnable());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
