/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.bacnetip.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple
    extends BACnetConfirmedServiceRequest implements Message {

  // Accessors for discriminator values.
  public BACnetConfirmedServiceChoice getServiceChoice() {
    return BACnetConfirmedServiceChoice.SUBSCRIBE_COV_PROPERTY_MULTIPLE;
  }

  // Properties.
  protected final BACnetContextTagUnsignedInteger subscriberProcessIdentifier;
  protected final BACnetContextTagBoolean issueConfirmedNotifications;
  protected final BACnetContextTagUnsignedInteger lifetime;
  protected final BACnetContextTagUnsignedInteger maxNotificationDelay;
  protected final
  BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList
      listOfCovSubscriptionSpecifications;

  // Arguments.
  protected final Long serviceRequestLength;

  public BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple(
      BACnetContextTagUnsignedInteger subscriberProcessIdentifier,
      BACnetContextTagBoolean issueConfirmedNotifications,
      BACnetContextTagUnsignedInteger lifetime,
      BACnetContextTagUnsignedInteger maxNotificationDelay,
      BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList
          listOfCovSubscriptionSpecifications,
      Long serviceRequestLength) {
    super(serviceRequestLength);
    this.subscriberProcessIdentifier = subscriberProcessIdentifier;
    this.issueConfirmedNotifications = issueConfirmedNotifications;
    this.lifetime = lifetime;
    this.maxNotificationDelay = maxNotificationDelay;
    this.listOfCovSubscriptionSpecifications = listOfCovSubscriptionSpecifications;
    this.serviceRequestLength = serviceRequestLength;
  }

  public BACnetContextTagUnsignedInteger getSubscriberProcessIdentifier() {
    return subscriberProcessIdentifier;
  }

  public BACnetContextTagBoolean getIssueConfirmedNotifications() {
    return issueConfirmedNotifications;
  }

  public BACnetContextTagUnsignedInteger getLifetime() {
    return lifetime;
  }

  public BACnetContextTagUnsignedInteger getMaxNotificationDelay() {
    return maxNotificationDelay;
  }

  public
  BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList
      getListOfCovSubscriptionSpecifications() {
    return listOfCovSubscriptionSpecifications;
  }

  @Override
  protected void serializeBACnetConfirmedServiceRequestChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple");

    // Simple Field (subscriberProcessIdentifier)
    writeSimpleField(
        "subscriberProcessIdentifier",
        subscriberProcessIdentifier,
        new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (issueConfirmedNotifications) (Can be skipped, if the value is null)
    writeOptionalField(
        "issueConfirmedNotifications",
        issueConfirmedNotifications,
        new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (lifetime) (Can be skipped, if the value is null)
    writeOptionalField("lifetime", lifetime, new DataWriterComplexDefault<>(writeBuffer));

    // Optional Field (maxNotificationDelay) (Can be skipped, if the value is null)
    writeOptionalField(
        "maxNotificationDelay", maxNotificationDelay, new DataWriterComplexDefault<>(writeBuffer));

    // Simple Field (listOfCovSubscriptionSpecifications)
    writeSimpleField(
        "listOfCovSubscriptionSpecifications",
        listOfCovSubscriptionSpecifications,
        new DataWriterComplexDefault<>(writeBuffer));

    writeBuffer.popContext("BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (subscriberProcessIdentifier)
    lengthInBits += subscriberProcessIdentifier.getLengthInBits();

    // Optional Field (issueConfirmedNotifications)
    if (issueConfirmedNotifications != null) {
      lengthInBits += issueConfirmedNotifications.getLengthInBits();
    }

    // Optional Field (lifetime)
    if (lifetime != null) {
      lengthInBits += lifetime.getLengthInBits();
    }

    // Optional Field (maxNotificationDelay)
    if (maxNotificationDelay != null) {
      lengthInBits += maxNotificationDelay.getLengthInBits();
    }

    // Simple field (listOfCovSubscriptionSpecifications)
    lengthInBits += listOfCovSubscriptionSpecifications.getLengthInBits();

    return lengthInBits;
  }

  public static BACnetConfirmedServiceRequestBuilder
      staticParseBACnetConfirmedServiceRequestBuilder(
          ReadBuffer readBuffer, Long serviceRequestLength) throws ParseException {
    readBuffer.pullContext("BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    BACnetContextTagUnsignedInteger subscriberProcessIdentifier =
        readSimpleField(
            "subscriberProcessIdentifier",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (0),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagBoolean issueConfirmedNotifications =
        readOptionalField(
            "issueConfirmedNotifications",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagBoolean)
                        BACnetContextTag.staticParse(
                            readBuffer, (short) (1), (BACnetDataType) (BACnetDataType.BOOLEAN)),
                readBuffer));

    BACnetContextTagUnsignedInteger lifetime =
        readOptionalField(
            "lifetime",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (2),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetContextTagUnsignedInteger maxNotificationDelay =
        readOptionalField(
            "maxNotificationDelay",
            new DataReaderComplexDefault<>(
                () ->
                    (BACnetContextTagUnsignedInteger)
                        BACnetContextTag.staticParse(
                            readBuffer,
                            (short) (3),
                            (BACnetDataType) (BACnetDataType.UNSIGNED_INTEGER)),
                readBuffer));

    BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList
        listOfCovSubscriptionSpecifications =
            readSimpleField(
                "listOfCovSubscriptionSpecifications",
                new DataReaderComplexDefault<>(
                    () ->
                        BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList
                            .staticParse(readBuffer, (short) (4)),
                    readBuffer));

    readBuffer.closeContext("BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple");
    // Create the instance
    return new BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleBuilderImpl(
        subscriberProcessIdentifier,
        issueConfirmedNotifications,
        lifetime,
        maxNotificationDelay,
        listOfCovSubscriptionSpecifications,
        serviceRequestLength);
  }

  public static class BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleBuilderImpl
      implements BACnetConfirmedServiceRequest.BACnetConfirmedServiceRequestBuilder {
    private final BACnetContextTagUnsignedInteger subscriberProcessIdentifier;
    private final BACnetContextTagBoolean issueConfirmedNotifications;
    private final BACnetContextTagUnsignedInteger lifetime;
    private final BACnetContextTagUnsignedInteger maxNotificationDelay;
    private final
    BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList
        listOfCovSubscriptionSpecifications;
    private final Long serviceRequestLength;

    public BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleBuilderImpl(
        BACnetContextTagUnsignedInteger subscriberProcessIdentifier,
        BACnetContextTagBoolean issueConfirmedNotifications,
        BACnetContextTagUnsignedInteger lifetime,
        BACnetContextTagUnsignedInteger maxNotificationDelay,
        BACnetConfirmedServiceRequestSubscribeCOVPropertyMultipleListOfCovSubscriptionSpecificationsList
            listOfCovSubscriptionSpecifications,
        Long serviceRequestLength) {
      this.subscriberProcessIdentifier = subscriberProcessIdentifier;
      this.issueConfirmedNotifications = issueConfirmedNotifications;
      this.lifetime = lifetime;
      this.maxNotificationDelay = maxNotificationDelay;
      this.listOfCovSubscriptionSpecifications = listOfCovSubscriptionSpecifications;
      this.serviceRequestLength = serviceRequestLength;
    }

    public BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple build(
        Long serviceRequestLength) {
      BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple
          bACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple =
              new BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple(
                  subscriberProcessIdentifier,
                  issueConfirmedNotifications,
                  lifetime,
                  maxNotificationDelay,
                  listOfCovSubscriptionSpecifications,
                  serviceRequestLength);
      return bACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple)) {
      return false;
    }
    BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple that =
        (BACnetConfirmedServiceRequestSubscribeCOVPropertyMultiple) o;
    return (getSubscriberProcessIdentifier() == that.getSubscriberProcessIdentifier())
        && (getIssueConfirmedNotifications() == that.getIssueConfirmedNotifications())
        && (getLifetime() == that.getLifetime())
        && (getMaxNotificationDelay() == that.getMaxNotificationDelay())
        && (getListOfCovSubscriptionSpecifications()
            == that.getListOfCovSubscriptionSpecifications())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getSubscriberProcessIdentifier(),
        getIssueConfirmedNotifications(),
        getLifetime(),
        getMaxNotificationDelay(),
        getListOfCovSubscriptionSpecifications());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
